/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * Routines which load a team via the teamserver.
 *
 * Marvin Theimer, 6/83
 *	First version.
 * Marvin Theimer, 7/83
 *	Made into a separate library routine.
 * Tim Mann, 9/2/83
 *	Fixes to ValidProgram.
 * Tim Mann, 9/16/83
 *	Changed to take a root message as argument.
 * Marvin Theimer, 9/29/83
 *	Added root message which specifies io for the postmortem debugger.
 *	Load request to team server now passes root messages rather than
 *	just io instances.
 */


#include <Vteams.h>

# define LoadTeamBufLength 128


File *ValidProgram();
ProcessId RequestTeamLoad();



/*
 * LoadNewTeam:
 * Create and load a new team from the specified parameters.  
 * Returns the pid of the new team or 0 on error.
 */

ProcessId LoadNewTeam(teamServer, name, concurrent, argv,
	rtMsg, debugRtMsg, error)
    ProcessId teamServer;	/* Default local teamserver if 0. */
    char *name;
    int concurrent;
    char **argv;
    RootMessage *rtMsg, *debugRtMsg;
    SystemCode *error;
  {
    File *loadFile;
    ProcessId newPid;
    Message msg;
    LoadTeamRequest *reqMsg = (LoadTeamRequest *) msg;
    char argsBuf[LoadTeamBufLength];
    char *curPtr = argsBuf, *f;
    int len;
    short nameLength;
    LoadTeamReply *repMsg = (LoadTeamReply *) msg;

    /* Set default values where specified. */
    if (teamServer == 0)
	teamServer = GetPid(TEAM_SERVER, LOCAL_PID);

    loadFile = ValidProgram(name, error);
    if (*error != OK)
	return(0);

    /* Package up the parameters: filename and root messages. */
    nameLength = strlen(name);
    strcpy(curPtr, name);
    curPtr += nameLength + 1;

    f = (char *) rtMsg;
    len = sizeof(RootMessage);
    while (len-- > 0)
	*curPtr++ = *f++;
    f = (char *) debugRtMsg;
    len = sizeof(RootMessage);
    while (len-- > 0)
	*curPtr++ = *f++;

    /* Construct load request message. */    
    reqMsg->requestcode = TeamLoadRequest;
    reqMsg->bufferptr = argsBuf;
    reqMsg->bytecount = curPtr - argsBuf;
    reqMsg->fileserver = loadFile->fileserver;
    reqMsg->fileid = loadFile->fileid;
    reqMsg->noOwner = concurrent;
    
    /* Send msg to team server and get back the rootPid of the new team or an
       error. */
    Send(reqMsg, teamServer);
    
    if (repMsg->replycode != OK)
      {
        *error = repMsg->replycode;
	Close(loadFile);
	return(0);
      }

    SetInstanceOwner(loadFile->fileserver, loadFile->fileid, teamServer);
    loadFile->type &= ~FRELEASE_ON_CLOSE;  /* don't release the instance */
    Close(loadFile);

    newPid = repMsg->rootPid;
    ReceiveSpecific(msg, newPid);
    SetUpArguments(newPid, argv);

    *error = OK;
    return(newPid);
  }
