/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * Routines to create (and start running) a program.
 *
 * Marvin Theimer, 7/83
 *	First created from the relevant code in the exec.
 * Marvin Theimer 7/83
 *	Made into a separate library routine.
 * Tim Mann 8/5/83
 *	Changed path to use [public].
 * Marvin Theimer 8/83
 *	Added LoadProg to go along with ExecProg and changed ExecProg to
 *	call LoadProg to avoid code redundancy.
 * Tim Mann 8/25/83
 *	Added [bin] to path.  Added current-context-invalid detection.
 * Tim Mann 9/16/83
 *	Changed to take a root message as argument instead of 3 (File *)s.
 * Bill Nowicki September 22, 1983
 *	Fixed bug regarding string overflow in the path searching stuff.
 * Marvin Theimer 9/29/83
 *	Added root message which specifies io for postmortem debugger.
 */


#include <Venviron.h>
#include <Vteams.h>
#include <Vgts.h>

# define FALSE 0
# define TRUE 1


/* ***
 *
 * NOTE: PATH must start with a leading blank so that the current context
 * will be searched first.
 *
 * ***/

#define PATH " [bin] [public]"
#define DEFAULT_PROGRAM	"[public]fexecute"

#define LineLength 128		/* Max size of a program name. */


extern char *index();
extern ProcessId LoadNewTeam();




/*
 * LoadProg:
 * Tries to execute the command program residing in file  fileName.
 * The program is placed in a separate team and is set ready to run.  Its root
 * pid is returned as LoadProg's return value.
 * 
 * The command program is found by searching for it in the directories 
 * specified by PATH.  If it is not found (and no other significant errors
 * occurred) then the default command program is executed.  (This currently
 * tries to run the specified command as a remote command on the file
 * server host.)
 *
 * If teamServer is 0 then the local teamServer is used.
 */

ProcessId LoadProg(argv, concurrent, teamServer, rtMsg, debugRtMsg, error)
    char **argv;
    int concurrent;
    ProcessId teamServer;
    RootMessage *rtMsg, *debugRtMsg;
    SystemCode *error;
  {
    int i;
    register char *p, *name;
    char *dir;
    char nameBuf[LineLength];
    ProcessId newpid;

	dir = PATH;
	while (*dir != '\0')
	  {
	    name = nameBuf;
	    p = argv[0];

	    /* Copy the string name of the next directory to try into the 
	       nameBuf. */
	    while ((*dir != ' ') && (*dir != '\0'))
	      {
		*name++ = *dir++;
	      }
	    *name = '\0';	/* Make it into a C string. */
	    /* Append the cmd name to the directory name. */
	    strncat(nameBuf, p, LineLength - strlen(nameBuf) - 1);

	    newpid = LoadNewTeam(teamServer, nameBuf, concurrent, 
	    	    argv, rtMsg, debugRtMsg, error);
	    if (newpid != 0) 
		break;
	    
	    /* Error */
	    switch( *error )
	      {
		case NOT_FOUND :
		case NO_PERMISSION :
		case BAD_STATE :
		case END_OF_FILE :
		case INVALID_CONTEXT :
		    if( (argv[0][0] == '.') )
			return(0);  /* leading dot => current context only*/
		    break;	    /* else keep trying */

		case NO_MEMORY :
		    return(0);	    /* give up if not enough memory */

		case KERNEL_TIMEOUT :
		case NONEXISTENT_PROCESS :
		    if ( !ValidPid(PerProcess->nameserver) )
		      {
			/* Current context is invalid */
			*error = CURRENT_CONTEXT_INVALID;
			return(0);
		      }
		    break;	/* otherwise keep trying */

		default:
		    return(0);	    /* give up on other errors */
	      }
	    while (*dir == ' ')
	        dir++;		/* Skip over the blank separator(s) between
				   directory entries in PATH. */
	  }

	/* Execute the default command if the cmd couldn't be executed. */
	if( newpid == 0 )
	  {
	    strcpy(nameBuf, DEFAULT_PROGRAM);
	    newpid = LoadNewTeam(teamServer, nameBuf, concurrent, 
	    	    argv, rtMsg, debugRtMsg, error);
	    if (newpid == 0)
	      {
		return(0);	/* Did not manage to create program. */
	      }
	  }

	/* At this point the new cmd team is ready to run  */

	return(newpid);
  }




/*
 * ExecProg:
 * Tries to execute the command program residing in file  fileName.
 * The program is placed in a separate team and is set running.  Its root
 * pid is returned as ExecProg's return value.
 * 
 * The command program is found by searching for it in the directories 
 * specified by PATH.  If it is not found (and no other significant errors
 * occurred) then the default command program is executed.  (This currently
 * tries to run the specified command as a remote command on the file
 * server host.)
 *
 * If teamServer is 0 then the local teamServer is used.
 */

ProcessId ExecProg(argv, concurrent, teamServer, rtMsg, debugRtMsg, error)
    char **argv;
    int concurrent;
    ProcessId teamServer;
    RootMessage *rtMsg, *debugRtMsg;
    SystemCode *error;
  {
    ProcessId newpid;

    newpid = LoadProg(argv, concurrent, teamServer, rtMsg, debugRtMsg,
    		error);

     if (newpid != 0)
	Reply( rtMsg, newpid );  	/* pass stdio on to new process */

    return(newpid);
  }
