/*
 * Distributed V Kernel
 * Copyright (c) 1982 by David Cheriton, Tim Mann, Willy Zwaenepoel
 * (Transliterated from Zed and Verex Kernel)
 *
 * Process Descriptor, Team descriptor type definitions and related manifests
 *
 */


#ifndef PROCESS
#define PROCESS

#include "../../libc/include/Vprocess.h"
#include "config.h"  /* Machine dependent */
#include "machine.h" /* Machine dependent */

#define MSG_SIZE	(8*sizeof(long)) /* Size in bytes of a message */

struct _TD  /* Team Descriptor Record */
  {
	struct _TD	*link;		/* For various queues.  Must be 1st */
	Process_id	team_root;	/* Process id of first team process */
	short		team_priority;	/* Base priority for team processes */
	short		team_user;	/* User number for team */
	Team_space	team_space;	/* Descriptor of team space */
  };
typedef struct _TD Team;

struct _PD  /* Process Descriptor Record */
  {
	struct _PD	*link;		/* General-purpose queue link */
	Process_id	pid;		/* Process identifier */
	Process_id	old_pid;
	struct _PD	*father;	/* Pointer to PD of creator */
	struct _PD	*brother;	/* Pointer to next sibling */
	struct _PD	*son;		/* List of processes created */
	short		state;		/* Blocked state else ready */
	short		priority;	/* Processor allocation */
	Team		*team;		/* Team of process */
	Process_id	blocked_on;	/* Process or device blocked on */
	struct _PD	*last_sender;	/* PD of last sending process */
	char		msg[MSG_SIZE];	/* Process message buffer */
	struct _PD	*msg_queue;	/* Queue of messages waiting */
	struct _PD	*msg_queue_end;	/* Last PD in msg queue */
	Unspec		*returnMessage;	/* Address for Finish_up_arg */
	unsigned short	seqNo;		/* Sequence Number */
	unsigned short  moveIndex;	/* Next block to be moved */
	unsigned char	numTrans;	/* Number of retransmissions */
	unsigned char	dataSegmentPro; /* Data segment protection */
	Unspec		*dataSegmentPtr;/* Begin of datasegment */
	unsigned	dataSegmentSize;/* End of datasegment */
	Unspec		*dataExpected;	/* Next data expected for Moves */
	Unspec		*remoteSegmentPtr;
	unsigned	remoteSegmentSize;
	unsigned	*recBufPtr;	/* Buffer for immediate receive */
	unsigned	*recBufSizePtr;	/* Address for size on immediate
					   receive */
	unsigned	recBufSize;	/* Size of buffer */
	Unspec		(*finish_up)();	/* Called when process unblocks */
	Processor_state  proc_state;	/* Processor state and per-process info */
  };

typedef struct _PD Process;

/* dataSegmentPro bit fields */

#define READ_ACCESS		0x08
#define WRITE_ACCESS		0x04

/* #define old_pid blocked_on */	/* Used for both purposes */
#define forwarder last_sender	/* Used for both purposes */

#define MAX_PROCESS_PRIORITY  127 /* 0 to 127 are legal, with 127 lowest */
#define NULL_PROCESS_PRIORITY 192 /* Higher than any legal priority */

#define Map_to_pd(pid) (Pd_bundle[(pid)&(MAX_PROCESSES-1)])
#define ValidPid(pid) Map_pid(pid)

#define LOCAL_DEVICE_SERVER_PID (MAX_PROCESSES<<1)
	/* The real device server pid has the logical host id in it */
#define LOCAL_KERNEL_PROCESS_PID (0x4000)
	/* id. */

#endif
