/*
 * V Kernel - Copyright (c) 1982 by David Cheriton
 * (Transliterated from Zed and Verex Kernel)
 *
 * Kernel Process and Team Management Routines
 *
 */

#include "process.h"

/* Global data declarations */

Process *Free_pds, *Last_free_pd;
Team    *Teams;    /* List of teams */
extern Process *Map_pid();

/* Kernel operations */

Process_id CreateProcess( priority, entry, stack ) 
short priority; register char *entry, *stack;

  /* Create a new process with the specified priority on the same
   * team as the creator and return the new process id.
   */
  {
    extern    Process *Free_pds, *Last_free_pd, *Active;
    register Process *pd;

    if( priority > MAX_PROCESS_PRIORITY ) return( 0 );

    if( (pd = Free_pds) == NULL ) return( 0 ); 

    if( (Free_pds = pd->link) == NULL ) /* Allocating last free PD */
        Last_free_pd = (Process *) &Free_pds;

    /* Initialize the fields of the allocated PD */
    pd->blocked_on = Active->pid;
    pd->state = AWAITING_REPLY;
    pd->pid = pd->old_pid + MAX_PROCESSES;
    /* Avoid creating a process with the remote alias process bit on. */
    pd->pid &= (~REMOTE_ALIAS_PROCESS);
    pd->team = Active->team;
    pd->priority = priority + pd->team->team_priority;
    pd->finish_up = NULL;
    pd->proc_state.perProcessLoc = Active->proc_state.perProcessLoc;

    /* Link into the tree of processes */
    pd->father = Active;
    pd->brother = Active->son;
    Active->son = pd;
    pd->son = NULL;
    pd->link = NULL;

    pd->msg_queue = NULL;
    pd->msg_queue_end = (Process *) &(pd->msg_queue);

    /* Machine-dependent initialization of PD */
    Ms_CreateProcess( pd, entry, stack );

    return( pd->pid );
  }

SystemCode DestroyProcess( pid ) Process_id pid;

  /* Destroy the specified process and all its descendants.
   * Free PD's are added to the end of the Free_pd queue.
   */
  {
    extern    Process *Free_pds, *Last_free_pd, *Readyq_head,
              *Pd_bundle[], *Delayq_head, *Active;
    register Process *pd, *prev, *receiver;

    if( (pd=Map_to_pd(pid))->pid != pid )
        return( NONEXISTENT_PROCESS );

    /* Remove from process tree */
    prev = pd->father;
    if( prev->son == pd ) prev->son = pd->brother;
    else
      {
        prev = prev->son;
        while( prev->brother != pd ) prev = prev->brother;
        prev->brother = pd->brother;
      }
    pd->brother = pd->father = 0;

    while( pd->son != NULL ) pd = pd->son;

    while( pd != NULL )
      {
        /* Unqueue from kernel queues if any */
        disable;
        if( pd->state == READY )
          {
            prev = (Process *) &Readyq_head;
            while( prev->link != pd ) prev = prev->link;
            prev->link = pd->link;
          }
        else if( pd->state == SEND_BLKED &&
            (receiver = Map_pid(pd->blocked_on)) != NULL )
          {
            /* Remove from sender's queue */
            prev = (Process *) &(receiver->msg_queue);
            while( prev->link != pd ) prev = prev->link;
            if( (prev->link = pd->link) == NULL )
                receiver->msg_queue_end =
                    (Process *) &(receiver->msg_queue);
          }
        else if( pd->state == DELAYING )
          { /* Remove from delay queue */
            prev = (Process *) &Delayq_head;
            while( prev->link != pd ) prev = prev->link;
            prev->link = pd->link;
            /* Adjust delay times accordingly */
            if( (prev = prev->link) != NULL )
              prev->blocked_on += pd->blocked_on;
          }
        pd->old_pid = pd->pid; /* Save previous pid */
        pd->pid = 0; /* Invalidate process identifier */
        enable;

        /* Add to list of free PD's */
        Last_free_pd = (Last_free_pd->link = pd);
	pd->link = NULL;

        /* Find next process to remove */
        if( pd->brother != NULL )
          {
            pd = pd->brother;
            while( pd->son != NULL ) pd = pd->son;
          }
        else pd = pd->father;
      }
    return( OK );
  }

Process_id QueryProcessState( srcpid, pid ) Process_id srcpid, pid;
  /* General query about process descriptor 
   */
  {
    extern Process *Pd_bundle[], *Active;
    register Process *pd;
    register int i;
    extern ProcessBlock ProcBlock;
    register ProcessBlock *pb;

    if( (pd=Map_to_pd(pid))->pid != pid )
	return( 0 );
 
    pb = &ProcBlock;
    pb->team_root = pd->team->team_root;
    pb->team_priority = pd->team->team_priority;
    pb->team_user = pd->team->team_user;
    pb->team_size = pd->team->team_space.size;
    if( pd->link != NULL )
  	pb->link = pd->link->pid;
    else
	pb->link = 0;
    if( pd->father != NULL )
	pb->father = pd->father->pid;
    else
	pb->father = 0;
    if( pd->brother != NULL )
	pb->brother = pd->brother->pid;
    else
	pb->brother = 0;
    if( pd->son != NULL )
	pb->son = pd->son->pid;
    else
	pb->son = 0;
    pb->state = pd->state;
    pb->priority = pd->priority;
    pb->blocked_on = pd->blocked_on;
    pb->forwardedby = (Process_id) pd->forwarder;
    if( pd->msg_queue != NULL )
	pb->msg_queue = pd->msg_queue->pid;
    else
	pb->msg_queue = 0;
    if( pd->msg_queue != NULL && pd->msg_queue_end != NULL )
	pb->msg_queue_end = pd->msg_queue_end->pid;
    else
	pb->msg_queue_end = 0;
    pb->proc_state = pd->proc_state;
    if ( pd == Active ||
         pd->state == AWAITING_REPLY && pd->blocked_on == srcpid )
      {
	for( i=0; i<MSG_SIZE; i++ ) 
	    pb->msg[i] = pd->msg[i];
      }
    else
      {
	for( i=0; i<MSG_SIZE; i++ ) 
	    pb->msg[i] = 0;
      }

    return( pid );
  }

WriteProcessState( srcpid, pid, state )
    register Process_id srcpid, pid;
    register Processor_state *state;
  /*
   * Write the process's state as described in state.
   *   Must be awaiting reply from the active process.
   * The active process may write its own state, but
   *   this only affects the per-process area information
   *   kept in the state record, not the actual processor
   *   registers.
   */
  {
    extern Process *Pd_bundle[], *Active;
    register Process *pd;
    Processor_state oldstate;
    Process *GetAlien();

    if( (pd=Map_to_pd(pid))->pid != pid )
	return( 0 );
    if( pd != Active && 
        (pd->state != AWAITING_REPLY || pd->blocked_on != srcpid) )
	return( 0 );
    
    oldstate = pd->proc_state;
    pd->proc_state = *state;
    ProtectProcessState;	/* Machine specific macro to
				    ensure consistency of state */

    if (state->perProcessLoc && BadUserPtr(state->perProcessLoc))
	pd->proc_state.perProcessLoc = NULL;

    if (pd == Active && pd->proc_state.perProcessLoc)
	*(pd->proc_state.perProcessLoc) = pd->proc_state.perProcess;

    return( pid );
  }

short SetTeamPriority( pid, priority ) 
Process_id pid; short priority;
  /*
   * Set the specified team's priority.
   *   A team is specified by the pid of any process on it.
   */
  {
    extern Process *Readyq_head, *Pd_bundle[];
    register Process *pd, *last_pd;
    Process *prev;
    register Team *td;
    register short priority_dif;

    if( (pd=Map_to_pd(pid))->pid != pid ) return( 0 );
    td = pd->team;
    priority_dif = priority - td->team_priority;
    last_pd = Pd_bundle[MAX_PROCESSES-1];

    for( pd = Pd_bundle[0]; pd != last_pd; ++pd )
      {
        if( pd->pid == 0 || pd->team != td ) continue;

        disable;
        pd->priority += priority_dif;

        if( pd->state == READY )
          {
            prev = (Process *) &Readyq_head;
            while( prev->link != pd ) prev = prev->link;
            prev->link = pd->link;
            Addready( pd );
          }
        enable;
      }
    priority_dif = td->team_priority;
    td->team_priority = priority;

    return( priority_dif );
  }

ProcessId CreateTeam( priority, entry, stack )
    short priority;
    char *entry;
    char *stack;

  /* Create a new team, creating a new process as the root process
   * with the specified priority, entry  and stack and return its pid.
   * Return 0 if unsuccessful.
   */
  {
    extern Team *Teams;
    register Process *pd;
    register Team *td;
    register ProcessId pid;

    /* Find a free team descriptor */
    for( td = Teams; td != NULL; td = td->link )
        if( Map_pid(td->team_root) == NULL ) break;

    if( td == NULL ) return( 0 ); /* No available team descriptors */

    if( (pid = CreateProcess(priority, entry, stack)) != 0 )
      {
        /* Initialize team descriptor */
        pd = Map_pid( pid );
        td->team_root = pid;
        td->team_user = 0;
	td->team_priority = 0;
	pd->priority = priority; /* Correct priority to be relative to 0 */
	pd->proc_state.perProcessLoc = NULL;
        pd->team = td;
        Ms_CreateTeam( td, pd ); /* Machine-dependent portion */
      }
    return( pid );
  }

