/*
 * Distributed V Kernel - Copyright (c) 1983 by Willy Zwaenepoel, David Cheriton
 *
 *	Kernel Process
 */

#include "../../libc/include/Venviron.h"
#include "../../libc/include/Vikc.h"
#include "process.h"

extern Process_id SendKernel();

Process_id SendKernel( pd, msg ) 
register Process *pd; Unspec *msg;
  /*
   * Implements kernel process dispatcher
   */
  {
    register KernelRequest *req;
    Process_id GetReply(), Forward(), NonLocal();
    int WriteKernelPacket(), ReadDataPacket();
    extern Process_id Kernel_Process_Pid;
    extern Process *Active;
    extern ProcessBlock ProcBlock;
    extern unsigned short CurrentSeqNo;

    pd->state = AWAITING_REPLY;
    pd->blocked_on = Kernel_Process_Pid;
    if( !NonLocal( pd->pid ) )
      {
	Removeready();
	pd->finish_up = (Unspec (*)()) GetReply;
	pd->returnMessage = (Unspec *) msg;
      }

    req = (KernelRequest *)(pd->msg);

    if( req->pid == 0 )
	req->pid = Active->pid;
    switch( req->opcode )
      {
	case CREATE_PROCESS:
	  {
	    req->pid = CreateProcess( req->unspecified[0],
				      req->unspecified[1],
				      req->unspecified[2] );
	    req->opcode = OK;
	    ReplyWithSegment( req, pd->pid, NULL, NULL, 0 );
	    break;
	  }
	case DESTROY_PROCESS:
	  {
	    if( NonLocal(req->pid) )
	      {
		Forward( req, Active->pid, (req->pid & 0xffff0000) +
					   (Kernel_Process_Pid & 0xffff) );
		return;
	      }
	    req->pid = DestroyProcess( req->pid );
	    req->opcode = OK;
	    ReplyWithSegment( req, pd->pid, NULL, NULL, 0 );
	    break;
	  }
	case QUERY_PROCESS:
	  {
	    if( NonLocal(req->pid) )
	      {
		Forward( req, Active->pid, (req->pid & 0xffff0000) +
					   (Kernel_Process_Pid & 0xffff) );
		return;
	      }
	    req->pid = QueryProcessState( pd->pid, req->pid );
	    req->opcode = OK;
	    ReplyWithSegment( req, pd->pid, &ProcBlock, req->segment,
				sizeof(ProcessBlock) );
	    break;
	  }
	case MODIFY_PROCESS:
	  {
	    if( !NonLocal( pd->pid ) )
	      {
		if( NonLocal(req->pid) )
	      	  {
		    pd->blocked_on = (req->pid & 0xffff0000)
					+(Kernel_Process_Pid & 0xffff);
		    pd->seqNo = CurrentSeqNo++;
		    pd->numTrans = 1;
		    WriteKernelPacket( remoteSend, pd->pid,
		(req->pid & 0xffff0000)+(Kernel_Process_Pid & 0xffff), 0,
		sizeof(Processor_state),NULL,NULL,pd->seqNo,req,req->segment);
		    return;
		  }
		req->pid = WriteProcessState(pd->pid,req->pid, req->segment);
		req->opcode = OK;
	    	ReplyWithSegment( req, pd->pid, NULL, NULL, 0 );
	      }
	    else
	      {
		ReadDataPacket(sizeof(Processor_state),ProcBlock.proc_state);
		req->pid = WriteProcessState(pd->pid,req->pid,ProcBlock.proc_state );
		req->opcode = OK;
		ReplyWithSegment( req, pd->pid, NULL, NULL, 0 );
	      }
	    break;
	  }
	case CREATE_TEAM:
	  {
	    req->pid = CreateTeam( req->unspecified[0],
				   req->unspecified[1],
				   req->unspecified[2] );
	    req->opcode = OK;
	    ReplyWithSegment( req, pd->pid, NULL, NULL, 0 );
	    break;
	  }
	case SET_TEAM_PRIORITY:
  	  {
	    if( NonLocal( req->pid ) )
	      {
		Forward( req, Active->pid, (req->pid & 0xffff0000) +
					   (Kernel_Process_Pid & 0xffff) );
		return;
	      }
	    req->unspecified[0] = (unsigned)
				  SetTeamPriority( req->pid,
						   req->unspecified[0] );
	    req->opcode = OK;
	    ReplyWithSegment( req, pd->pid, NULL, NULL, 0 );
	    break;
	  }
	case SET_TEAM_SIZE:
	  {
	    if( NonLocal( req->pid ) )
	      {
		Forward( req, Active->pid, (req->pid & 0xffff0000) +
					   (Kernel_Process_Pid & 0xffff) );
		return;
	      }
	    req->unspecified[0] = (unsigned)
				  SetTeamSize( req->pid,
					       req->unspecified[0] );
	    req->opcode = OK;
	    ReplyWithSegment( req, pd->pid, NULL, NULL, 0 );
	    break;
	  }
	case DELAY:
	  {
	    Delay( req->unspecified[0], req->unspecified[1] );
	    break;
	  }
	case WAKEUP:
	  {
	    if( NonLocal( req->pid ) )
	      {
		Forward( req, Active->pid, (req->pid & 0xffff0000) +
					   (Kernel_Process_Pid & 0xffff) );
		return;
	      }
	    req->pid = Wakeup( req->pid );
	    req->opcode = OK;
	    ReplyWithSegment( req, pd->pid, NULL, NULL, 0 );
	    break;
	  }
	case SETTIME:
	  {
	    SetTime( req->unspecified[0], req->unspecified[1] );
	    req->opcode = OK;
	    ReplyWithSegment( req, pd->pid, NULL, NULL, 0 );
	    break;
	  }
	case GETTIME:
	  {
	    req->unspecified[0] = GetTime( &(req->unspecified[1]) );
	    req->opcode = OK;
	    ReplyWithSegment( req, pd->pid, NULL, NULL, 0 );
	    break;
	  }
	case SETPID:
	  {
	    req->unspecified[0] = SetPid( req->unspecified[0], req->pid,
					  req->unspecified[1] );
	    req->opcode = OK;
	    ReplyWithSegment( req, pd->pid, NULL, NULL, 0 );
	    break;
	  }
	default:
	  {
	    break;
	  }
      }
  }
