/*
 * V Kernel - Copyright (c) 1982 by David Cheriton
 * (Transliterated from Zed and Verex Kernel)
 *
 * Motorola 68000 dependent timer functions.
 *
 * Timer is set to interrupt at 100 Hz.
 *
 * For SMI workstations the timer interrupts every 2 ms rather than
 * every 10 ms so that the mouse can be correctly polled.  Normal Vkernel
 * interrupt chores are performed every 5th interrupt.
 * - Marvin Theimer 2/83.
 */

#include "interrupt.h"
#include "../mi/dm.h"
#include "timer.h"
#include "../mi/mouse.h"

static int IntrptCount = -5;		/* Used to count number of 2 ms
					   interrupts since last 10 ms
					   interrupt. */

/* Generation Number Routine */
unsigned char GetGenerationNumber()
  {
    return( emt_ticks() & 0xff );
  }

/* Interrupt service routine that calls machine-independent routine
 * on each interrupt. Assumes no need to disable interrupts because
 * no higher priority interrupt unblocks processes.
 */
Call_inthandler(Ms_Timer_interrupt); /* Macro expansion to interrupt-invoked
				   * C call to Ms_Timer_interrupt
				   */
Ms_Timer_interrupt()
  {
    extern short WsType;

    ACK_TIMER_INT;
    if (WsType == SMI)
      {
        SmiMouseInterrupt();
	IntrptCount++;
	if (IntrptCount < 0)
	  {
	    return;
	  }
	IntrptCount = -5;
	SMIKeyboardPoll();
      }
    if (MouseEvent)
	CheckMouseReader();
    Timer_interrupt();
  }


Init_timer()
  /*
   * Perform the required initialization for the timer.
   */
  {
    extern int Asm_Ms_Timer_interrupt();
    register int (**int_vec)() = (int(**)())0x78;

    *int_vec =  Asm_Ms_Timer_interrupt; /* Plug interrupt location */

    /* Initialize the AMD Am9513 Timer */
    TCSetModeLoad( TIMInter, KTimerMode, KTimerCount );
    TMRLoadCmd(TCArmCnt(TSCountSelect(TIMInter)));
  }
