
/* NewMouse.c - routines for mouse and non-firmware cursor, including 
 * interrupt handler  --  modified version for 8048 mouse controller
 *
 * Contains:
 * 
 * GetMouseButtons()
 * GetMouseCoords()
 *
 * NB. optimizer (-O) can not be used on this file
 */

#define ADRSPC_CONTEXT 0xE00000

#define MOUSE_REG_ADDR(n) \
	 	((unsigned short *)(ADRSPC_CONTEXT + ((3-n) << 6)))
	/* mouse is at SUN context register address and has
	 * four registers:  0 = Read coordinate and switches
	 *		    1 = (unused)
	 *		    2 = Interrupt 8048, load X into reg 0
	 *		    3 = Interrupt 8048, load Y into reg 0
	 */

#define MOUSE_ACK_MASK		0x8000
#define MOUSE_BUTTONS_MASK	0x7000
#define MOUSE_COORD_MASK	0x0fff

#define WANT_MOUSE_X		{ register unsigned short _dummy; \
				  _dummy = *MOUSE_REG_ADDR(2); }
#define WANT_MOUSE_Y		{ register unsigned short _dummy; \
				  _dummy = *MOUSE_REG_ADDR(3); }
#define READ_MOUSE_COORD(intoVariable) \
		      { register unsigned short _dummy; \
			do \
			{ \
			    _dummy = *MOUSE_REG_ADDR(0); \
			} \
			while (!(_dummy & MOUSE_ACK_MASK)); \
			intoVariable = _dummy & MOUSE_COORD_MASK; \
		      }

GetMouseCoords()
{
    register temp;

    WANT_MOUSE_X;
    READ_MOUSE_COORD(MouseX);
    WANT_MOUSE_Y;
    READ_MOUSE_COORD(MouseY);

    if (MouseX > 1023) MouseX = 1023;
    if (MouseX < 0) MouseX = 0;
    if (MouseY > 807) MouseY = 807;
    if (MouseY < 0) MouseY = 0;
    MouseY = 807 - MouseY;
}

GetMouseButtons()
{
    MouseButtons = (~(*MOUSE_REG_ADDR(0)) & MOUSE_BUTTONS_MASK) >> 12;
}
