/*
 * Distributed V Kernel
 * Copyright (c) 1982 by David Cheriton, Tim Mann, Willy Zwaenepoel
 * (Transliterated from Zed and Verex Kernel)
 *
 * Machine descriptive Header File for Motorola 68000
 */

/* See also Venviron.h */

#ifndef MACHINE
#define MACHINE
#include "memory.h"

#define ProtectProcessState\
	(pd->proc_state).context = oldstate.context;\
	(pd->proc_state).sr = ((pd->proc_state).sr & 0x80ff) |\
				(oldstate.sr & 0x7f00)

typedef struct
  {
	short	context;	/* SUN processor context number */
	char	*size;		/* Nominal size (actual size is this, rounded
				   up to a page boundary) */
  } Team_space;

#define disable ;asm("	orw	#/0700,sr")
#define enable  ;asm("	andw	#/F9FF,sr")

/* To save interrupt mask in Add_ready */
#define Interrupt_mask extern short sr; register short
#define Mask_interrupts()	sr; disable
#define Restore_interrupt_mask(mask) sr = mask

#define Ms_pd_init(pd, i) /* Nothing to do */

#define SetReturnValue( pd, value )	/* Set the return value for a blocked process */\
pd->proc_state.regs[0] = (Unspec) value /* providing it does no use a finish-up function */

/* Message copying macro - note it modifies the contents of src and dest */
#define CopyMessage( dest, src ) /* Message copying macro */	\
{								\
*dest++ = *src++;						\
*dest++ = *src++;						\
*dest++ = *src++;						\
*dest++ = *src++;						\
*dest++ = *src++;						\
*dest++ = *src++;						\
*dest++ = *src++;						\
*dest = *src;							\
 }

#define BadUserPtr(ptr) \
( ((unsigned)((unsigned)ptr - TSTART)) >= ((unsigned)(0x200000 - TSTART)) )
	/* Must be outside kernel space and less than 0x200000 */
#define SegOutsideTeamSpace(pd, ptr, len) \
( len && ( ((char *) ptr < (char *) TSTART) || ((char *) ptr + (unsigned long) len > pd->team->team_space.size) || (unsigned long) len > 0xFFFFFF ) )

#define SetProcessContext( pd ) *((short *) 0xE00000) = pd->proc_state.context

/* Definitions for automatic config routines */

#define GetConfig() (*((short *) 0xE00000))  /* Read config register */

#define STANFORD 1	/* Workstation types */
#define	CADLINC	 2
#define SMI	 3

#endif

