/*
 * V Kernel - Copyright (c) 1982 by David Cheriton, Tim Mann
 * (Transliterated from Zed and Verex Kernel)
 *
 * Interrupt service routine that calls a machine-independent
 * C routine to handle the interrupt.  The routine does four things:
 *
 *	1)  Save d0, d1, a0, and a1.  This is needed
 *	      because C functions destroy those registers.
 *	2)  Call the interrupt handler.
 *	3)  Restore the registers.
 *	4)  If the active process is no longer at the head of
 *	      the ready queue, and it was not running in the kernel,
 *	      do a process switch.
 *
 * The parameter to the macro should be the name of the function to
 *  handle the interrupt.  If the function name is "func", the
 *  interrupt vector needs to be plugged with the address of the assembly
 *  language function "Asm_func".
 *
 * The location KernelInterrupted is set to a nonzero value if the
 *  interrupt occurred during a kernel operation (indicated by the
 *  supervisor bit being on and the interrupt level different from 0,
 *  the latter to exclude the idle process). This assumes that no
 *  devices will interrupt at level 0 and that a trap causes the
 *  interrupt level to be set at a value bigger than 0.
 */

#ifndef INTERRUPT
#define INTERRUPT

#include "../mi/process.h"

#define Call_inthandler(handler)\
   intserv(handler,end_/**/handler,Asm_/**/handler,Not_/**/handler)

#define	intserv(handler,end_handler,Asm_handler,Not_handler)\
extern Process *Active, *Readyq_head, Idle_process;			\
extern short KernelInterrupted;						\
asm("	.text");							\
asm("	.globl	Asm_handler");						\
asm("Asm_handler:");							\
asm("	moveml	#/c0c0,sp@-");		/* Save d0,d1,a0,a1 */		\
asm("	movw	sp@(16),d1");		/* Take status register */	\
asm("	andl	#/2700,d1");		/* Supervisor and int-level */	\
asm("	cmpw	#/2000,d1");		/* Interrupted the kernel ? */	\
asm("	bles	Not_handler");						\
asm("	addqw	#1,KernelInterrupted"); /* Kernel interrupted */	\
asm("	jbsr	handler");						\
asm("	subqw	#1,KernelInterrupted");					\
asm("	moveml	sp@+,#/0303");		/* Restore registers */		\
asm("	rte");				/* Return */			\
asm("Not_handler:");			/* Kernel not interrupted */	\
asm("	jbsr	handler");						\
asm("	orw	#/0700,sr");		/* Disable interrupts */	\
asm("	movl	Active,d0");		/* Check if Active is still */	\
asm("	cmpl	Readyq_head,d0");	/*   at head of ready queue */	\
asm("	beqs	end_handler");		/* If so, don't switch */	\
asm("	moveml	sp@+,#/0303");		/* Restore registers */		\
asm("	jmp	Switch");						\
asm("end_handler:");							\
asm("	moveml	sp@+,#/0303");		/* Restore registers */		\
asm("	rte");				/* Return */			\
int	Asm_handler();

#endif
