/*
 * V Kernel - Copyright (c) 1982 by David Cheriton, Tim Mann
 * (Transliterated from Zed and Verex Kernel)
 *
 * Exception handling for MC68000
 */

#include "../../libc/include/Venviron.h"
#include "../../libc/include/Vexceptions.h"
#include "../mi/process.h"

#define exvec(vecname,vecnum) 						\
asm("	.globl	vecname");						\
asm("vecname:");							\
	ExceptionType = vecnum; /* Put vecnum in message */	\
asm("	jmp	callException");


#define setexvec(vecname,vecnum)  /* Initialize a vector */		\
*( (int (**)()) vecnum ) = vecname


static short ExceptionType;
extern char *StackBottom;

DummyExceptionHandler()
  {
   /*
    * Establish locations for each exception
    *  to vector to.
    */
    exvec(BusError,BUSERROR);
    exvec(AddrError,ADDRERROR);
    exvec(IllInst,ILLINST);
    exvec(ZeroDiv,ZERODIV);
    exvec(ChkInst,CHKINST);
    exvec(TrapvInst,TRAPVINST);
    exvec(PrivViol,PRIVVIOL);
    exvec(TraceTrap,TRACETRAP);
    exvec(Emu1010,EMU1010);
    exvec(Emu1111,EMU1111);

    exvec(SpurInt,SPURINT);
    exvec(Int1,INT1);
    exvec(Int2,INT2);
    exvec(Int3,INT3);

    exvec(Trap0,TRAP0);
    exvec(Trap1,TRAP1);
    exvec(Trap2,TRAP2);
    exvec(Trap3,TRAP3);
    exvec(Trap4,TRAP4);
  }
/*
 * Asm routine to call the HandleException() function
 *  Registers are saved and the stack is cleaned up
 *  so that the process state record will
 *  be accurate as of the time of the exception.
 */

asm("    .text");
asm("    .globl    callException");
asm("callException:");
disable;
asm("    movw    #0,sp@-");        /* Long-align stack */
asm("    moveml    #/c0c0,sp@-");        /* Save d0,d1,a0,a1 */
asm("    jsr    HandleException");
asm("    moveml    sp@+,#/0303");        /* Restore them */
asm("    movl    StackBottom,sp");    /* Flush stack */
asm("    jmp    Switch");        /* Switch to somebody else */



InitException()

/*
 * Function to initialize exception vectors
 */

  {
    extern BusError(), AddrError(), IllInst(), ZeroDiv(), ChkInst(),
	   TrapvInst(), PrivViol(), TraceTrap(), Emu1010(), Emu1111(),
	   SpurInt(), Int1(), Int2(), Int3(), Trap0(), Trap2(), Trap3(),
	   Trap4(), Asm_Forward_trap(), Asm_GetPid_trap(), 
	   Asm_MoveFrom_trap(), Asm_MoveTo_trap(), Asm_ReceiveSpecific_trap(),
	   Asm_ReceiveWithSegment_trap(), Asm_ReplyWithSegment_trap(),
	   Asm_RereadMsg_trap(), Asm_Send_trap();

    setexvec(BusError,BUSERROR);
    setexvec(AddrError,ADDRERROR);
    setexvec(IllInst,ILLINST);
    setexvec(ZeroDiv,ZERODIV);
    setexvec(ChkInst,CHKINST);
    setexvec(TrapvInst,TRAPVINST);
    setexvec(PrivViol,PRIVVIOL);
    setexvec(TraceTrap,TRACETRAP);
    setexvec(Emu1010,EMU1010);
    setexvec(Emu1111,EMU1111);

    setexvec(SpurInt,SPURINT);
    setexvec(Int1,INT1);
    setexvec(Int2,INT2);
    setexvec(Int3,INT3);

    setexvec(Trap0,TRAP0);
/*    setexvec(Trap1,TRAP1);*/
    setexvec(Trap2,TRAP2);
    setexvec(Trap3,TRAP3);
    setexvec(Trap4,TRAP4);
/* This now initializes the kernel traps */
    setexvec(Asm_Forward_trap,TRAP5);
    setexvec(Asm_GetPid_trap,TRAP6);
    setexvec(Asm_MoveFrom_trap,TRAP7);
    setexvec(Asm_MoveTo_trap,TRAP8);
    setexvec(Asm_ReceiveSpecific_trap,TRAP9);
    setexvec(Asm_ReceiveWithSegment_trap,TRAP10);
    setexvec(Asm_ReplyWithSegment_trap,TRAP11);
    setexvec(Asm_RereadMsg_trap,TRAP12);
    setexvec(Asm_Send_trap,TRAP13);

  }


HandleException(rd0,rd1,ra0,ra1,code,accaddr,irsr,errpc)
long unsigned rd0,rd1,ra0,ra1,code,accaddr,irsr,errpc;
/*
 * Kernel exception handler.  Packages up the information
 *  about the exception and causes the offending process to send
 *  a message off to the exception handler process, if one is
 *  registered.  Otherwise, the process sends the message to itself.
 *
 * This function sees the exception information automatically pushed
 *   on the stack by the processor as its arguments.
 */

  {
    extern Process *Active, Idle_process;
    ExceptionRequest *req;


    req = (ExceptionRequest *) Active->msg;

    /* Build msg to send to exception handler */

    req->requestcode = EXCEPTION_REQUEST;
    req->type = ExceptionType;

    if( ExceptionType == ADDRERROR || ExceptionType == BUSERROR )
      {
        req->code = code;
    	req->accaddr = accaddr;
    	req->instruction = irsr >> 16;  /* extract ir */
    	req->status = irsr & 0xffff;	/* extract sr */
    	req->errpc = errpc;
      }
    else
      {
    	req->status = code;    /* Status register */
    	req->errpc = accaddr; /* Really pc */
    	req->code = req->accaddr = req->instruction = 0;
      }

    /* Diagnose cause of bus error -- see memory.c */
    if (ExceptionType == BUSERROR)
	req->buserrortype = DiagnoseBusError(req);

    req->segment = (char *) TSTART; /* Include access to the team space */
    req->segmentsize = ((unsigned) (Active->team->team_space.size)) - TSTART;

    if( Active == &Idle_process ) /* Fatal kernel error */
      {
    	Kabort( "Exception in interrupt routine" );
      }

    /* Send to the exception server and send to self if that fails */
    Send(0, GetPid(EXCEPTION_SERVER,LOCAL_PID));
    if (Active->state == READY)	Send(0, Active->pid);
    Active->finish_up = NULL; /* We don't want to get the reply */
  }
