/*
 * V Kernel - Copyright (c) 1982 by David Cheriton
 *
 * Ethernet header: manifests, types, structs local to Ethernet code.
 */

#ifndef _ETHERNET
#define _ETHERNET

#include "../mi/dm.h"
 /*
  * Addresses of the Ethernet Interface registers on the Multibus 
  * These are in the "standard" multibus I/O space, which
  * starts at 0x1F0000.
  */
#define EIData0		*(short*)0x1F0100
#define EIData1		*(short*)0x1F0102
#define EIStatus	*(short*)0x1F0104
#define EIAddress	*(short*)0x1F0106

/* Write Status word bits, written into EIStatus  */

#define EnetInit		(128*256)
#define EnetLoopback		(64*256)
#define EnetNoFilterData	(32*256)
#define EnetRxIntDisable	(8*256)
#define EnetTxIntDisable	(16*256)
#define EnetIntDisable		(24*256)
#define EnetIntLevel0		(7*256)
#define EnetIntLevel1		(6*256)
#define EnetIntLevel2		(5*256)


/* Receiver status word fields, READ from EIdata0. */

#define EnetQueueEmpty	 	0x8000
#define EnetOverflow		0x4000
#define EnetCollision		0x2000
#define EnetCRCerror		0x1000
#define EnetCountMask		0x0FFF

/* Transmitter status word bit assignments, read from EIStatus. */

#define EnetTxInt		0x8000
#define EnetTimeout		0x4000
#define EnetRxInt		0x2000	/* On if receiver queue not empty */
#define EnetInt			0x1000	/* On if EnetTxInt or EnetRxInt */

#define ENET_READER_TIMEOUT	50	/* 500 ms timeout on read */

#endif
