/*
 * V Kernel - Copyright (c) 1982 by David Cheriton, Tim Mann
 * Circular buffer routines
 * Used by serial line device and console device
 */

#include "cbuff.h"

/* Exports */
extern int CbuffGet();
extern CbuffPut();
extern CbuffFlush();

static char cbuff[CBUFF_NUM*CBUFF_SIZE];
static char *cbuffIn[] = { &cbuff[0], &cbuff[CBUFF_SIZE], &cbuff[2*CBUFF_SIZE] },
	    *cbuffOut[] = { &cbuff[0], &cbuff[CBUFF_SIZE], &cbuff[2*CBUFF_SIZE] };

int CbuffGet( buff )
    int buff;
    /*
     *  Get a character from buffer buff
     *  Return CBUFF_EMPTY if buffer empty.
     */
  {
    register short c;

    if ( cbuffIn[buff] == cbuffOut[buff] ) return (CBUFF_EMPTY);
    c = *cbuffOut[buff]++;
    if ( cbuffOut[buff] >= CBUFF_LIMIT(buff) )
	cbuffOut[buff] -= CBUFF_SIZE;
    return (c);
  }


CbuffPut( buff, c )
    int	buff;
    char c;
  {
    /*
     * Put a character in buffer buff
     */
    *cbuffIn[buff]++ = c;  /* Ignore buffer overruns -- effect is to flush buffer */
    if ( cbuffIn[buff] >= CBUFF_LIMIT(buff) )
	cbuffIn[buff] -= CBUFF_SIZE;
  }

CbuffFlush( buff )
    int	buff;
  {
    /* Discard accumulated characters in buffer
     */
    cbuffOut[buff] = cbuffIn[buff];
  }

