/********************************************************/
/*							*/
/*	  Virtual Graphics Terminal Server		*/
/*							*/
/*		(C) COPYRIGHT 1983			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*							*/
/********************************************************/

/* init.c - Virtual Graphics Terminal Server Initialization
 *
 *
 * This provides the "main" program for the vgtsexec
 *
 * Bill Nowicki April 1983
 *
 * Marvin Theimer, 6/83:  Changed initialization to call InitFirstTeam
 *		to do the initialization of first team matters that is 
 *		common to all execs.
 */

# include <Vioprotocol.h>
# include "Vgts.h"

extern short TtyVGT, TtySDF;
extern short Unique, InputPad;		/* From mux.c */

short Debug = 0;

/*
 * main:
 * Main routine for the vgts package.
 * This routine sets up the vgts process and any applications
 * processes; in this case, Exec.
 */

main()
  {
    Message msg;
    short vgt;

    InitVgts( 690, 698, 1100, 790 );

    vgt = PadInit( TtySDF, Unique++, "Executive", PadHeight, PadWidth );
    InputPad = vgt;
    CreateView( vgt, 8, 304, 8+ViewWidth(PadWidth), 
    		304+ViewHeight(PadHeight), 0, 0, 0, 0);

    TtyMessage( "SUN Virtual Graphics Terminal Service" );
    TtyMessage( "With multiple executives" );
	/*
	 * set up stderr to go to the VGTS
	 */
    stderr = (File *)malloc(sizeof(File));
    *stderr = *stdout;
    stderr->fileid = TtyVGT;
    stderr->fileserver = GetPid(VGT_SERVER,ANY_PID);

    InitFirstTeam();  /* done here to give exception server the new stderr */

	/*
	 * The main Vgts loop here.  Create one default executive,
	 * then repeatedly receive messages and do the right thing.
	 */
    OpenExecFiles(InputPad);

    while (1) GetMessage( 0, 0, msg );
 }


