/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * Bill Nowicki September 1983
 * Special VGTS version using its line editing
 */

/*
 * GetLine:
 * Returns next input line.  Performs line editing ala emacs-style.
 * If inputLineLength > 0 then the line is displayed to allow it to be edited.
 *
 * Returns -1 if EOF, or the number of characters in the line.
 *
 * At most maxLineLength characters will be handled.  Overflow characters are
 * lost.
 */

# include <Vio.h>
# include <Vgts.h>

int GetLine(inputLine, inputLineLength, maxLineLength,
	printFlag, inFile, outFile)
    register char *inputLine;
    int inputLineLength, maxLineLength;
    int printFlag;
    File *inFile, *outFile;
  {
    extern short Debug; register char *s; register c, n;

    Flush(outFile);
    if (inputLineLength>0) EditLine(inFile,inputLine,inputLineLength);
    ModifyPad(inFile,CR_Input+LF_Output+Echo+LineBuffer);
    s = inputLine; n = maxLineLength-2;
    while (--n>0 && (c = getc(inFile))>=0)
      {
	*s++ = c;
	if (c=='\n' || c==7 /*^G*/)
		break;
      }
    if (c<0 && s==inputLine)
     {
       if (Debug) printf("Exec saw end of file\n");
       return -1;
     }
    inputLineLength = s - inputLine;
    *s++ = '\0';
    if (inFile->lastexception == EOF ) 
      {
        if (Debug) printf("Exec saw EOF but fgets returned!\n");
        return -1;
      }
    if (Debug) printf("Exec line length=%d\n", inputLineLength );
    if (inputLineLength > 0 && c != '\007') 
      {
	inputLine[inputLineLength-1] = 0;
        return( inputLineLength-1 );
      }
    return(inputLineLength);
 }
