/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANDFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * Program to list all registered V hosts.
 *
 * Marvin Theimer, 6/83.
 */


#include <Vio.h>
#include <Vhosts.h>


#define MaxHosts 50
#define LineLength 30
#define HalfLineLength 15


main()
  {
    ProcessId hostServer;
    Message msg, msg1;
    ReturnHostsRequest *reqMsg = (ReturnHostsRequest *) msg;
    ReturnHostsReply *repMsg = (ReturnHostsReply *) msg;
    ReturnHostsRequest *reqMsg1 = (ReturnHostsRequest *) msg1;
    ReturnHostsReply *repMsg1 = (ReturnHostsReply *) msg1;
    ProcessId buffer[MaxHosts];
    char nameBuf[LineLength];
    int i, j, n, len, len1;
    char *ptr;

    /* Find the host server. */
    hostServer = GetPid(HOST_SERVER, ANY_PID);
    if (hostServer == 0)
      {
	printf("Couldn't find the host server.\n");
	exit();
      }

    /* Get the root pids of all registered hosts. */
    reqMsg->requestcode = ReturnHosts;
    reqMsg->requestType = AllEntries;
    reqMsg->bufferptr = (char *) buffer;
    reqMsg->bytecount = MaxHosts * sizeof(ProcessId);
    hostServer = Send(msg, hostServer);
    if (hostServer == 0)
      {
	printf("Couldn't send a msg to the host server.\n");
	exit();
      }
    if (repMsg->replycode != OK)
      {
	printf("Error from host server: %s\n", 
		ErrorString(repMsg->replycode));
	exit();
      }
    printf("\nV-Hosts currently registered:\n\n");

    /* Get information for each specific host. */
    for (i = 0; i < repMsg->numEntries; i++)
      {
	reqMsg1->requestcode = ReturnHosts;
	reqMsg1->requestType = SpecificEntry;
	reqMsg1->regPid = buffer[i];
	reqMsg1->bufferptr = nameBuf;
	reqMsg1->bytecount = LineLength;
	hostServer = Send(msg1, hostServer);
	if (hostServer == 0)
	  {
	    printf("Couldn't send a msg to the host server.\n");
	    exit();
	  }
	if (repMsg1->replycode != OK)
	  {
	    printf("Error from host server: %s\n", 
		    ErrorString(repMsg1->replycode));
	    exit();
	  }
	len = strlen(nameBuf);
	ptr = nameBuf + len + 1;
	len1 = strlen(ptr);
	printf("%s,", ptr);
	n = HalfLineLength - len1;
	for (j = 0; j < n; j++)
	    printf(" ");
	printf("    %s,", nameBuf);
	n = HalfLineLength - len;
	for (j = 0; j < n; j++)
	    printf(" ");
	printf("    teamServer: %x    availability: %x\n",
		repMsg1->regPid, repMsg1->availability);
      }
    return(OK);
  }
