/*
 * Test program for V kernel
 * Tests the speed of kernel message passing by sending some
 *  large number of messages back and forth between two processes,
 *  and seeing how much time it takes.
 */

#include <Venviron.h>

#define		NORMAL    0	/* "Normal" process priority */
#define		TRIES    10000	/* How many messages to send */

main()
  {
    Message msg;
    int child();
    register ProcessId pid;
    register int i, *msgbuffer = (int *) msg;
	int time1sec,time1clicks, time2sec, time2clicks, Child();

    printf( "Message timing test.\n" );
#if DEBUG
    printf("Test program starting.\n");
#endif

    pid = Create(NORMAL, Child, 999);
#if DEBUG
    printf("Process created.\n");
#endif
    Ready( pid, 1, GetPid(ACTIVE_PROCESS, LOCAL_PID) );

    msgbuffer[0] = 0;

    time1sec = GetTime( &time1clicks ); /* Get the current time */
    for (i=1; i<=TRIES; i++)
      {
	msgbuffer[7] = i;
#if DEBUG
	printf("About to send.\n");
#endif
	Send( msgbuffer, pid ); /* Send to the child */
	if ( msgbuffer[7] != -i)
	   {
	    printf("Error:  Reply was wrong.\n");
	    break;
	  }    
      }
#if DEBUG
    printf("Messages sent.\n");
#endif

    time2sec = GetTime(&time2clicks);
    if( time1clicks > time2clicks )
      {
	time2clicks += CLICKS_PER_SEC; 
	--time2sec;
      }
    time2sec -= time1sec;
    time2clicks -= time1clicks;
    printf("Total time: %d seconds, %d clicks.  Avg time: %d microsec.\n",
	time2sec,time2clicks,1000000*(time2sec*CLICKS_PER_SEC+time2clicks)
	/(TRIES*CLICKS_PER_SEC));

    time1sec = GetTime( &time1clicks );

/* Dummy loop to time loop overhead.  Same as above, but with
 *  Send deleted.  Instead, this process does the negation
 *  of msgbuffer[7] itself.
 */
    for( i=1; i<=TRIES; i++)
      {
	msgbuffer[7] = i;
	msgbuffer[7] = -msgbuffer[7];
	if (msgbuffer[7] != -i)
	  {
	    printf("Error:  A miracle occured.\n");
	    break;
	  }
      }
    time2sec = GetTime( &time2clicks );
    if( time1clicks > time2clicks )
      {
	time2clicks += CLICKS_PER_SEC; 
	--time2sec;
      }
    time2sec -= time1sec;
    time2clicks -= time1clicks;

    printf("Total overhead: %d seconds, %d clicks.  Avg overhead: %d microsec.\n\n",
	time2sec,time2clicks,1000000*(time2sec*CLICKS_PER_SEC+time2clicks)
	/(TRIES*CLICKS_PER_SEC));
    DestroyProcess( pid );
  }

/* Code executed by child process */

Child()
  {
    register int senderpid;
    Message msg;
    register int *message = (int *) msg;

    while( 1 )
      {
	senderpid = Receive( message );
#if DEBUG
	printf("Got the message.\n");
#endif

	message[7] = -message[7];
	Reply( message, senderpid );
#if DEBUG
	printf("Sent the reply.\n");
#endif
      }
  }
