/*
 * Utility program to delete context names.
 *
 * Delete the context names argv[1] to argv[argc-1] from local name
 * server's name space.
 */

#include <Venviron.h>
#include <Vio.h>
extern char *ErrorString();
extern SystemCode AliasContextName();
extern SystemCode DeleteContextName();

main( argc, argv )
    int argc;
    char **argv;
  {
    register char **Name;
    register int NameCount;
    register SystemCode r;
    
    if ( (NameCount = --argc) < 1 )
      {
        fprintf( stderr, "usage: %s contextname1 ... contextnameN", argv[0] );
	exit( BAD_ARGS );
      }

    for( Name = &argv[ 1 ]; NameCount > 0; Name++, NameCount-- )
      {
        if ( (r = DeleteContextName( *Name )) != OK )
	  {
	    fprintf( stderr, "%s %s: %s\n", argv[0], *Name,
	             ErrorString( r ) );
	    exit( r );
	  }
      }

  } /* main */
        

    
