/* 
 * logout.c
 * "Log out" a user by deleting some or all of his sessions and
 *   invalidating their names.
 * Tim Mann
 * January 25, 1983
 * June 1983 Marvin Theimer - Added registraion with host server.
 * Aug 4, 1983 (TPM) - Rewrote for new naming protocol
 */

#include <Vio.h>
#include <Vdirectory.h>
#include <Vnaming.h>

main(argc, argv)
int argc;
char *argv[];
  {
    File *contexts;
    int i, count, errorOccurred;
    SystemCode error;
    ArbitraryDescriptor desc;    
    char *myName;
    char name[NameServerNameLen+1];
    ProcessId homePid, logoutPid;
    ContextId cid;

    myName = argv[0];
    count = 0;
    errorOccurred = 0;

    if (argc == 1)
      {
	/* Global logout */

#ifdef HOSTSERVER
	/* Check if we can make the host available for remote task
	 *   execution. Currently we just check if this is a
	 *   logout of all sessions.  Later this will
	 *   be turned into a check for no sessions left.
	 *   (Or so Marvin promises.) */
	UnregisterTeamServer();
#endif HOSTSERVER

	/* Read local name server's directory and log out all
	 *   sessions found */
	contexts = Open("[context]", FREAD|FDIRECTORY, &error);
	if (error != OK)
	  {
	    printf("%s: Can't open '[context]': %s", myName, 
		ErrorString(error));
	    exit(1);
	  }

	while ( Read(contexts, &desc, contexts->blocksize) == 
		    contexts->blocksize )
	  {
	    contexts->block++;
	    if (desc.n.descriptortype != LOCALNAME_DESCRIPTOR) continue;

	    if (desc.n.entrytype & SESSION)
	      {
		/* Get null-terminated session name */
		strncpy(name, desc.n.name, NameServerNameLen);
		name[NameServerNameLen] = '\0';

	        /* Terminate it */
	        error = TerminateSession(name);
	        if (error == OK) 
		  {
	            count++;
		  }
		else
		  {
	            printf("%s: %s %s\n", myName, name, ErrorString(error));
		    errorOccurred++;
		  }
	      }
	  }
	if (contexts->lastexception != END_OF_FILE)
	  {
	    printf("%s: Error reading directory: %s\n", myName,
		ErrorString(error));
	    errorOccurred++;
	  }

	DeleteContextName("[home]");	/* redefine [home] */
	AliasContextName("[home]", "[public]");
	DeleteContextName("[bin]");
	AliasContextName("[bin]", "[public]");

	/* Clear screen */
	if (!errorOccurred) printf("\f");
      }
    else
      {
	/* Get pid of [home] to see if we are logging it out */
	if (GetContextId("[home]", &homePid, &cid) != OK) homePid = 0;

	for (i=1; i<argc; i++)
	  {
	    /* Find out what pid we are logging out */
	    GetContextId(argv[i], &logoutPid, &cid);

	    /* Log it out */
	    error = TerminateSession(argv[i]);
	    if (error == OK) 
	      {
		count++;
	        if (logoutPid == homePid)
		  {
		    /* Redefine [home] and [bin] */
		    DeleteContextName("[home]");
		    DeleteContextName("[bin]");
		    AliasContextName("[home]", "[public]");
		    AliasContextName("[bin]", "[public]");
		  }
	      }
	    else
	      {
	        printf("%s: %s %s\n", myName, argv[i], ErrorString(error));
		errorOccurred++;
	      }
	  }

	/*%% It would be easier to check if [home] has been logged out by
	 *   doing a ValidPid on it, if that worked in the Vserver */
      }

    printf("Logged out %d session%s\n", count, count==1 ? "" : "s");

    exit(errorOccurred);

  }


