/* 
 * login.c
 * "Log in" a user on a new host by creating a session on the host
 *    and defining a local name for it.  Also sets [home] to refer to
 *    the new session, and [bin] to refer to the PUBLIC_CONTEXT on that
 *    session.
 * Currently this code uses GetWord for lack of an I/O Chef.
 *
 * Tim Mann
 * January 25, 1983 - Created
 * January 30, 1983 - Modified to set the new session to be the current
 *	session after creating it.
 * March 1983 (WIN) Set Pad to right mode
 * June 1983 Marvin Theimer - Added registration with host server.
 * Aug 3, 1983 (TPM) - Rewrote for new naming stuff.
 */

#include <Vio.h>
#include <Vgts.h>
#include <Vnaming.h>
#include <chars.h>

#define MAX_FIELD_SIZE 16
#define INBUF_SIZE 128
#define TRUE 1
#define FALSE 0
#define null(string) ((string)[0] == '\0')

main(argc, argv)
int argc;
char *argv[];
  {
    char inputbuffer[INBUF_SIZE];
    char hostname[MAX_FIELD_SIZE+1], username[MAX_FIELD_SIZE+1],
         password[MAX_FIELD_SIZE+1], sessionname[MAX_FIELD_SIZE+3];
    int i;
    SystemCode error;
    SystemCode CreateSession();
    ProcessId sessionPid;
    ContextId sessionCid;

    hostname[0] = username[0] = password[0] = '\0';
    sessionname[0] = '[';
    sessionname[1] = '\0';

    ModifyPad(stdout,LF_Output);
    /* Get host name */
    if (argc > 1)
      {
	strncat(hostname, argv[1], MAX_FIELD_SIZE);
	/* Host name is default session name */
	strncat(sessionname, argv[1], MAX_FIELD_SIZE);
      }
    else
      {
	printf("Host name: ");
	GetWord(inputbuffer, TRUE, TRUE, stdin, stdout); 
	putchar('\n');
	strncat(hostname, inputbuffer, MAX_FIELD_SIZE);
	strncat(sessionname, inputbuffer, MAX_FIELD_SIZE);
      }

    /* Get user name */
    printf("User name: ");
    GetWord(inputbuffer, TRUE, TRUE, stdin, stdout);
    putchar('\n');
    strncat(username, inputbuffer, MAX_FIELD_SIZE);

    /* Get password (no echo) */
    printf("Password: ");
    GetWord(inputbuffer, TRUE, FALSE, stdin, stdout);
    putchar('\n');
    strncat(password, inputbuffer, MAX_FIELD_SIZE);

    /* Get session name */
    if (argc > 2)
      {
	sessionname[1] = '\0';	/* Wipe out host name */
	strncat(sessionname, argv[2], MAX_FIELD_SIZE);
      }
    strcat(sessionname, "]");

#ifdef HOSTSERVER
    /* Register the host as unavailable for remote task execution
       with the host server. */
    RegisterTeamServer(inputbuffer, 0);
#endif HOSTSERVER

    /* Create and register the session, making the local name server
     *   its owner so it will be permanent until logged out explicitly */
    error = CreateSession(hostname, username, password, sessionname,
        GetPid(NAME_SERVER, LOCAL_PID));

    if (error != OK)
      {
	PrintError(error, "login");
        exit(error);
      }

    /* Set [home] to be the home context in the new session,
     *  and [bin] to be the public context there. */
    GetContextId(sessionname, &sessionPid, &sessionCid);
    DeleteContextName("[home]");
    AddContextName("[home]", sessionPid, LOGIN_CONTEXT);
    DeleteContextName("[bin]");
    AddContextName("[bin]", sessionPid, PUBLIC_CONTEXT);

    exit(OK);
  }


/* Copied from exec.c. */
int GetWord(Word, OneWord, PrintChars, in, out)
    register char *Word;
    unsigned OneWord, PrintChars;
    File *in, *out;
 /*
  * Read a word from the console (megakludge)
  */
  {
    register int i;
    register char ch,lastCh;

    lastCh = ' ';
    for (i=0;i<100;) 
      {
        Flush(out);
        ch = getc(in) & 0177;
	if (in->lastexception || in->state)
	  printf("Error on read: %s, state=0x%x\n", 
	  	ErrorString(in->lastexception), in->state );
        if (ch < ' ' || ch == DEL)
	 {
	 switch (ch)
	   {
	   case DEL:
	   case BS:
	       if (i > 0)
	         {
	           i--;
	           if (PrintChars) 
    	               fprintf(out,"\b \b");
	         }
	       continue;

	    case NAK:		/* control U - line erase */
	      while (i>0)
	         {
	           i--;
	           if (PrintChars) 
    	               fprintf(out,"\b \b");
	         }
	      continue;
	      
	    case ETB:		/* control W - word erase */
	      while (i>0 && Word[i-1]==' ')
	        {
	           if (PrintChars) 
    	               fprintf(out,"\b \b");
		   i--;
		}
	      while (i>0 && Word[i-1]!=' ')
	         {
	           if (PrintChars) 
    	               fprintf(out,"\b \b");
		   i--;
	         }
	      lastCh = ' ';
	      continue;
	      
	     case CR:
	     case LF:
	        break;

	     default: continue;
	    }
	    break;
	   }

        if (OneWord && ch == ' ')
	    break;

	if (PrintChars)
	    putc(ch, out);

	if ((ch != lastCh) || (lastCh != ' ')) 
	 {
	  Word[i] = ch;
	  lastCh = ch;
	  i++;
	 }
      }  /* end for */
    Word[i] = 0;
    return(i);
  }

