/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * Print out a name descriptor in an aesthetically pleasing format.
 */

#include <sys/types.h>
#include <stat.h>
#include <time.h>
#include <Vioprotocol.h>
#include <Vnaming.h>
#include <Vdirectory.h>
#include <Vgts.h>
 
PrintDescriptor( desc, bannertype )
    register ArbitraryDescriptor *desc;
    register int *bannertype; 
/*
 * Each descriptor has an associated banner defined by this routine.
 * If "bannertype" is not the same as "desc->e.descriptortype" then
 * this routine will output the banner for this type.  
 */
  {
    unsigned short mode;

    switch (desc->e.descriptortype)
      {
	case EMPTY_DESCRIPTOR:
	    break;

	case FILE_DESCRIPTOR:
	    /* Not implemented yet */
	    break;

	case TEAM_DESCRIPTOR:
	    if (*bannertype != TEAM_DESCRIPTOR)
	      {
		/* Generate a banner */
		printf("\n%-40s %10s %10s\n", "File name",
		    "OwnerPid", "RootPid");
		*bannertype = TEAM_DESCRIPTOR;
	      }

	    printf("%-40s %10x %10x\n", desc->t.fileName, 
		    desc->t.ownerPid, desc->t.rootPid);
	    break;

	case LOCALNAME_DESCRIPTOR:
	    if (*bannertype != LOCALNAME_DESCRIPTOR)
	      {
		/* Generate a banner */
		printf("\n%-16s %10s %10s\n", "Context name", "ServerPid",
		    "ContextId");
		*bannertype = LOCALNAME_DESCRIPTOR;
	      }

	    printf("%-16s %10x %10x  %s%s\n", desc->n.name,
		desc->n.serverpid, desc->n.contextid,
		desc->n.entrytype & SESSION ? "(Session)" : "",
		desc->n.entrytype & LOGICAL_PID ? "(Logical pid)" : "");
	    break;

	case DEVICE_DESCRIPTOR:
	    if (*bannertype != DEVICE_DESCRIPTOR)
	      {
		/* Generate a banner */
		printf("\n%-16s %10s\n", "Device name", 
		    "Type");
		*bannertype = DEVICE_DESCRIPTOR;
	      }

	    printf("%-16s %10d\n", desc->d.name,
		desc->d.devicetype);
	    break;

	case UNIXFILE_DESCRIPTOR:
	    if (*bannertype != UNIXFILE_DESCRIPTOR)
	      {
            /* -rw-r--r--   1  nagler   netgraph  25808  8/07/83 02:32 list */ 
    printf( "\n   Mode   Links Owner    Group      Size %s Name\n",
			FormatDate( 0 ) );
		*bannertype = UNIXFILE_DESCRIPTOR;
	      }

	    mode = desc->u.st_mode;

	    /* Print out type of file and protection mode bits */
	    switch (mode & S_IFMT)
	      {
	        case S_IFDIR:	putchar('d'); break;
	        case S_IFCHR:	putchar('c'); break;
		case S_IFBLK:	putchar('b'); break;
		case S_IFREG:	putchar('-'); break;
		case S_IFMPC:	putchar('m'); break;
		case S_IFMPB:	putchar('M'); break;
		default:	putchar('?'); break; /* illegal */
	      }
	    putchar(mode&S_IREAD ? 'r' : '-');
	    putchar(mode&S_IWRITE ? 'w' : '-');
	    switch (mode & (S_IEXEC|S_ISUID))
	      {
		case 0:		putchar('-'); break;
		case S_IEXEC:	putchar('x'); break;
		case S_ISUID:	putchar('S'); break; /* anomaly */
		default:	putchar('s'); break;
	      }
	    putchar(mode&(S_IREAD>>3) ? 'r' : '-');
	    putchar(mode&(S_IWRITE>>3) ? 'w' : '-');
	    switch (mode & ((S_IEXEC>>3)|S_ISGID))
	      {
		case 0:		putchar('-'); break;
		case S_IEXEC>>3:putchar('x'); break;
		case S_ISGID:	putchar('S'); break; /* anomaly */
		default:	putchar('s'); break;
	      }
	    putchar(mode&(S_IREAD>>6) ? 'r' : '-');
	    putchar(mode&(S_IWRITE>>6) ? 'w' : '-');
	    switch (mode & ((S_IEXEC>>6)|S_ISVTX))
	      {
		case 0:		putchar('-'); break;
		case S_IEXEC>>6:putchar('x'); break;
		case S_ISVTX:	putchar('T'); break; /* strange */
		default:	putchar('t'); break;
	      }

	    desc->u.name[ UnixFileNameLen ] = 0;
	    printf("  %2d  %-8.8s %-8.8s%7d %s %s\n", desc->u.st_nlink,
		desc->u.ownername,
		desc->u.groupname,
		desc->u.st_size,
		FormatDate(desc->u.st_mtime), 
		desc->u.name );
	    break;


	case VGT_DESCRIPTOR:
	    if (*bannertype != VGT_DESCRIPTOR)
	      {
		/* Generate a banner */
		printf("\nVGT Lines Columns Owner  %-14s %10s\n", "Name", 
		    "Banner");
		*bannertype = VGT_DESCRIPTOR;
	      }

	    printf("%2d", desc->v.vgt);
	    if (desc->v.typeVGT & TTY)
	        printf("   %3d  %3d ", desc->v.lines, desc->v.columns );
	    else 
	        printf("    Graphics");		
	    if (desc->v.ownerPid)
	        printf("  %8x ", desc->v.ownerPid );
	    else 
	        printf("           ");
	    printf("%-14s %-40s\n", desc->v.name, desc->v.banner);
	    break;

	default:
	    printf("%s: unrecognized directory entry type %d.\n",
		myName, desc->e.descriptortype );
	    break;
      }
  } /* PrintEntry */


static char *FormatDate(clock)
    long clock;
/*
 * Create a fixed width string for the date specified by "clock"
 */
  {
    static char date[ 20 ];
    register struct tm *time;

    if ( clock == 0 )
        return( " Last Modified" );	/* must be same length as "date" */
    else
      {
        time = localtime(&clock);
    
        sprintf( date, "%2d/%02d/%02d %02d:%02d", time->tm_mon, time->tm_mday
    	     , time->tm_year % 100, time->tm_hour, time->tm_min );
        return ( date );
      }
  } /* FormatDate */
