/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANDFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/


/*
 * iptelnet/standalone.c - IP user telnet under Vkernel with VGTS!
 *
 * by Bill Nowicki
 *  Rewritten April 1983
 */

# include <Venviron.h>
# include <Vioprotocol.h>
# include <Vgts.h>
# include <confreg.h>

# define MaxVGTs 4		/* number of displays for now */

short TtyVGT;
short InputPad = -1;		/* pad for current input */
short TtySDF;
short Unique;

File *FileTable[MaxVGTs][2];

int VgtsProcess(), Telnet(), InitInternetServer();

main ()
{
    Message msg;
    int i;
    ProcessId pid;
    SystemCode error;

    SetTime(GetRemoteTime(), 0);
    InitExceptionServer();

    pid = Create(4, InitInternetServer, 3000);
    Ready(pid, 3, 0, 1, 0);

    pid = Create(4, VgtsProcess, 4000);
    Reply( msg, pid);

    for (i=0; i<MaxVGTs; i++)
      {
        FileTable[i][0] = OpenFile( pid, i+1, FREAD, &error );
	if (FileTable[i][0]==NULL) 
	    printf("Error %s on pad %d input\n", ErrorString(error), i+1);
        FileTable[i][1] = OpenFile( pid, i+1, FCREATE, &error );
	if (FileTable[i][1]==NULL) 
	    printf("Error %s on pad %d output\n", ErrorString(error), i+1);
        ModifyPad(FileTable[i][0],ReportEscSeq);
      }
    for (i=1; i<MaxVGTs; i++)
      {
        pid = Create(40, Telnet, 3000);
        Ready(pid, 3, FileTable[i][0], FileTable[i][1], 0);
      }
    Telnet(FileTable[0][0],FileTable[0][1], 0);
}


VgtsProcess()
  {
	/*
	 * The master multiplexor process for this program
	 */
    Message msg;
    short vgt, config, emt_getconfig();
    char AwaitCharInput();

    config = emt_getconfig();

    InitVgts( 690, 688, 1050, 790);
    vgt = PadInit( TtySDF, Unique++, "IP Telnet 1", 
    		PadHeight, PadWidth );
    if (( (struct ConfReg *)&config )->FBType )
      {
      	/*
	 * Landscape format screen (wide)
	 */
        CreateView( vgt, 6, 318, 
		6+ViewWidth(PadWidth), 318+ViewHeight(PadHeight), 0, 0, 0, 0);
        InputPad = vgt;
        vgt = PadInit( TtySDF, Unique++, "IP Telnet 2",
    		PadHeight, PadWidth );
        CreateView( vgt, 116, 212, 
	      116+ViewWidth(PadWidth), 212+ViewHeight(PadHeight), 0, 0, 0, 0);
        vgt = PadInit( TtySDF, Unique++, "IP Telnet 3",
    		PadHeight, PadWidth );
        if (vgt>0)
	  CreateView( vgt, 220, 100, 
	     220+ViewWidth(PadWidth), 100+ViewHeight(PadHeight), 0, 0, 0, 0);
        vgt = PadInit( TtySDF, Unique++, "IP Telnet 4",
		 PadHeight, PadWidth );
        if (vgt>0)
	  CreateView( vgt, 324, 4, 
	      324+ViewWidth(PadWidth),  4+ViewHeight(PadHeight), 0, 0, 0, 0);
        MakeTopXY( 10, 350);
      }
     else
     {
	   /*
            * Portrait format screen (tall)
	    */
        CreateView( vgt, 4, 566, 4+ViewWidth(PadWidth), 566+ViewHeight(PadHeight), 0, -2, 0, 0);
        InputPad = vgt;
        vgt = PadInit( TtySDF, Unique++, "IP Telnet 2",
    		PadHeight, PadWidth );
        if (vgt>0)
	  CreateView( vgt, 24, 414, 24+ViewWidth(PadWidth), 414+ViewHeight(PadHeight), 0, -2, 0, 0);
        vgt = PadInit( TtySDF, Unique++, "IP Telnet 3",
    		PadHeight, PadWidth );
        if (vgt>0)
	  CreateView( vgt, 44, 262, 
	    44+ViewWidth(PadWidth), 262+ViewHeight(PadHeight), 0, -2, 0, 0);
        vgt = PadInit( TtySDF, Unique++, "IP Telnet 4",
    		PadHeight, PadWidth );
        if (vgt>0)
	  CreateView( vgt, 84, 110, 
	    84+ViewWidth(PadWidth), 110+ViewHeight(PadHeight), 0, -2, 0, 0);
        MakeTopXY( 20, 990);
     }

    TtyMessage( "SUN Virtual Graphics Terminal Service" );
    TtyMessage( "With IP User Telnet" );

    while (1)
      GetMessage( 0, 0, msg);
  }


ExecControl()
  {
    TtyBlinkError("Execs not implemented");
  }
