/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANDFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/


/*
 * hosts.c - IP host name lookup
 *
 * Marvin Theimer and Bill Nowicki October 1983
 *
 * This version has hardwired table, + reads from a file
 */

# include <Vio.h>
# include <ctype.h>

# define HostFileName "/etc/net/Hostmap/hosts.txt"

# define Arpanet (10 << 24)	/* Arpanet in IP address position */
# define SUNet (36 << 24)	/* Stanford Network (Class A now) */
# define CSDNet (40 << 16)

struct HostAdrType
  {
      char *hostName;
      unsigned long hostAdr;
  }
 Hosts[] =
  {
	"shasta", (SUNet | CSDNet | (0300)),
	"diablo", (SUNet | CSDNet | (0301)),
	"sail", (SUNet | CSDNet | (0302)),
	"score",  (SUNet | CSDNet | (0303)),
	"navajo", (SUNet | CSDNet | (0313)),
	"whitney",(SUNet | CSDNet | (0314)),
	"glacier", (SUNet | CSDNet | (0315)),
	"fuji", (SUNet | CSDNet | (0316)),
	"star",   (SUNet | CSDNet | (0317)),
	"su-star",   (SUNet | CSDNet | (0317)),
	"carmel", (SUNet | CSDNet | (0324)),
	"sierra", (SUNet | CSDNet | (0325)),
	"sumex", (SUNet | (45 << 16) | 87),
	"ardvax", (SUNet | (45<< 16) | 85),
	"safe", (SUNet | (45<< 16) | 86),
	"isia",  (Arpanet | (1 << 16) | (22)),
	"isib",  (Arpanet | (3 << 16) | (52)),
	"isi-vaxa", (Arpanet | (2 << 16) | (27)),
	"isi-vaxb", (Arpanet | (52)),
	0,0
    };


/*
 * GetHostAddress:
 * Returns the host address for the specified host name string.
 */

GetHostAddress(in,out,host)
    File *in, *out;
    char *host;
  {
    int i;
    int f1, f2, f3, f4;
    File *hostFile;
    SystemCode error;

    Lower(host);
    for (i = 0; Hosts[i].hostName != NULL; i++)
      {
	if (strcmp(host, Hosts[i].hostName) == 0)
	  {
	    fprintf(out,"Trying %s...",host);
	    Flush(out);
	    return(Hosts[i].hostAdr);
          }
      }
    if (isdigit(host[0]))
      {
        if (sscanf(host, "%d.%d.%d.%d", &f1, &f2, &f3, &f4) == 4)
	  {
	    fprintf(out,"Trying %s...",host);
	    Flush(out);
	    return((f1 << 24) | (f2 << 16) | (f3 << 8) | f4);
	  }
      }

    hostFile = Open(HostFileName,FREAD+FRELEASE_ON_CLOSE,&error);
    if (hostFile==NULL)
      {
        char alternate[256];
	
	strcpy(alternate,"[public]");
	strcat(alternate,HostFileName);
	hostFile = Open(alternate,FREAD+FRELEASE_ON_CLOSE,&error);
      }
    if (hostFile==NULL)
      {
        printf("Unable to open host file: %s %s\n",
		HostFileName,ErrorString(error) );
        return(0);
      }
    Flush(out);
    while (!Eof(hostFile))
      {
        register char *h;
        register c = getc(hostFile);
	
	  /*
	   * read a line of the host file
	   */
	while (!Eof(hostFile) && c!='\n' && c!=':')
	  {
	      /*
	       * Read a word from the host file
	       */
	    while (c=='\n') c = getc(hostFile);
	    h = host;
	    while (*h && c==*h)
	      {
	        c = getc(hostFile);
		h++;
		if (*h==0 && c==' ')
		  {
		    /*
		     * Found a match!! Now we skip to the colon and space,
		     */
		    while (c!=':' && !Eof(hostFile)) c = getc(hostFile);
		    c = getc(hostFile);
		    while (c==' ') c = getc(hostFile);
		    
		    f1 = 0;
		    f2 = 0;
		    while (c!=' ' && !Eof(hostFile)) 
		      {
		        if (isdigit(c))
			  {
			    f1 *= 10;
			    f1 += c - '0';
			  }
			if (c=='.')
			  {
			    f2 <<= 8;
			    f2 |= f1;
			    f1 = 0;
			  }
		        c = getc(hostFile);
		      }
		    f2 <<= 8;
		    f2 |= f1;
		    fprintf(out,"Trying %s...",host);
		    Flush(out);
	            Close(hostFile);
		    return(f2);
		  }
	      }
	    while (c!=' ') c = getc(hostFile);
   	    c = getc(hostFile);
	    if (c==':')
	        while (c!='\n' && !Eof(hostFile)) c = getc(hostFile);  
	  }
      }
    printf("Host %s is unknown\n", host);
    Close(hostFile);
    return(0);
  }

