/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * General include file for V shell.
 * Marvin Theimer.
 *
 * Marvin Theimer, 8/83
 *	File first created.
 */

# define FALSE 0
# define TRUE 1

# define MaxArgs 32		/* Maximum number of arguments on a command 
				   line. */
# define LineLength 128		/* Max size of input line. */


/*
 * History mechanism definitions.
 */

#define MaxCmds 20		/* Maximum number of commands remembered
				   in history. */


typedef struct HistoryRecType
  {
    char *cmds[MaxCmds];	/* Ptrs to last MaxCmds commands. */
    int nextCmd;		/* Next slot in cmds in which to place a
				   new command. */
  } HistoryRec;


/*
 * Alias mechanism definitions
 */

#define MaxAliases 20		/* Maximum number of aliases remembered. */


typedef struct AliaseRecType		/* Alias defn. record. */
  {
    char *alias;		/* Alias */
    char *cmd;			/* Cmd for which the alias stands. */
  } AliaseRec;


/*
 * Input line-editting definitions
 */

typedef struct LineRecType
  {
    char *line;			/* Global ptr to current input line. */
    int lineLength;		/* Maximum allowed length of input line. */
    int endLine;		/* Index of end of input line. */
    int printChars;		/* Indicates whether output should be 
				   displayed. */
    int cursor;			/* Index of location of cursor. */
    File *in;			/* Input file from which to get input. */
    File *out;			/* Output file on which to display things. */
    int escFlag;		/* True if next char. should be ESC'd. */
  } LineRec;
