/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * Io redirection mechanism for V shell.
 * Marvin Theimer.
 *
 * Marvin Theimer, 8/83
 *	File first created.
 * Tim Mann, 9/16/83
 *	Major rework.
 */

#include <Vioprotocol.h>
#include <Vpipe.h>
#include <Vteams.h>
#include "sh.h"

#define PIPE_SERVER_FILE "pipeserver"

ProcessId PipeServerPid = 0;

extern File *Open();
extern ProcessId ExecProg();




/*
 * InitPipeServer:
 * Make sure a pipe server is available.
 */

SystemCode InitPipeServer()
  {
    extern ProcessId Kernel_Process_Pid;
    char *argv1[2];		/* Used to load the pipeserver. */
    Message msg;
    register RootMessage *rtMsg = (RootMessage *) msg;
    SystemCode error;

    PipeServerPid = GetPid(PIPE_SERVER, LOCAL_PID);
    if ( !ValidPid(PipeServerPid) )
      {
	argv1[0] = PIPE_SERVER_FILE;
	argv1[1] = NULL;
	rtMsg->stdinserver = stdin->fileserver;
	rtMsg->stdinfile = stdin->fileid;
	rtMsg->stdoutserver = stdout->fileserver;
	rtMsg->stdoutfile = stdout->fileid;
	rtMsg->stderrserver = stdout->fileserver;  /* minor kludge */
	rtMsg->stderrfile = stdout->fileid;
	rtMsg->rootflags = 0;
	rtMsg->nameserver = PerProcess->nameserver;
	rtMsg->contextid = PerProcess->contextid;
	rtMsg->kernelpid = Kernel_Process_Pid;

	PipeServerPid = ExecProg(argv1, 1, FALSE, rtMsg, rtMsg, &error);
				/* Use rtMsg also as root message for
				   postmortem debugger. */
	if (PipeServerPid == NULL)
	  {
	    return(error);
	  }
      }
    return(OK);
  }




/*
 * SetUpPipe:
 * Set up a pipe and return the CreateInstanceReply
 */

SystemCode SetUpPipe(pipeReply, shOut)
    File *shOut;
    register CreateInstanceReply *pipeReply;
  {
    register CreatePipeRequest *pipeReq = (CreatePipeRequest *) pipeReply;
    ProcessId localPid = GetPid(ACTIVE_PROCESS, LOCAL_PID);
    SystemCode error;

    if ( !ValidPid(PipeServerPid) )
      {
	error = InitPipeServer();
	if (error != OK)
	  {
	    fprintf(shOut, "ERROR: couldn't create a pipe server: %s\n", 
	        ErrorString(error));
	    return(error);
	  }
      }

    /* Create a pipe. */
    pipeReq->requestcode = CREATE_INSTANCE;
    pipeReq->filemode = FCREATE;
    pipeReq->readowner = localPid;
    pipeReq->writeowner = localPid;
    pipeReq->buffers = 10;
    pipeReq->filename = "pipe";
    pipeReq->filenamelen = 0;
    Send(pipeReq, PipeServerPid);
    if (pipeReply->replycode != OK)
      {
	fprintf(shOut, "ERROR: couldn't create a pipe instance: %s\n", 
	    ErrorString(pipeReply->replycode));
	return(pipeReply->replycode);
      }

    return(OK);
  }






/*
 * RedefineEnvironment:
 * Redefines the execution environment of a command.
 */

SystemCode RedefineEnvironment(ptrArgc, args, concurrent, teamServerPid,
		rtMsg, shOut)
    int *ptrArgc;
    char **args;
    int *concurrent;
    ProcessId *teamServerPid;
    register RootMessage *rtMsg;
    File *shOut;
  {
    Message msg;
    register CreateInstanceReply *creply = (CreateInstanceReply *) msg;
    int argc = *ptrArgc;
    SystemCode error;

    while (1)			/* Loop until all redefinitions have been
				   processed. */
      {
	/* Check if a concurrent command */
	if ((argc >= 2) && (strcmp(args[argc-1], "&") == 0))
	  {
	    args[--argc] = NULL; 
			    	/* Eliminate the argument */
	    *concurrent = 1;
	  }

	/* Check if a different team server is specified. */
	else if ((argc >= 3) && (strcmp(args[argc-2], "@") == 0))
	  {
	    sscanf(args[argc-1], "%x", teamServerPid);
	    args[argc-2] = NULL;
	    argc -= 2;
	  }

	/* Check for io redirection. */
	else if ((argc >= 3) && ((args[argc-2][0] == '>') ||
			    (args[argc-2][0] == '<')))
	  {
	    if (strcmp(args[argc-2], "<") == 0)
	      {
		error = CreateInstance(args[argc-1], FREAD, creply);
		rtMsg->stdinserver = creply->fileserver;
		rtMsg->stdinfile = creply->fileid;
		rtMsg->rootflags |= STDIN_REDIRECTED + RELEASE_INPUT;
	      }
	    else if (strcmp(args[argc-2], ">") == 0)
	      {
		error = CreateInstance(args[argc-1], FCREATE, creply);
		rtMsg->stdoutserver = creply->fileserver;
		rtMsg->stdoutfile = creply->fileid;
		rtMsg->rootflags |= STDOUT_REDIRECTED + RELEASE_OUTPUT;
	      }
	    else if (strcmp(args[argc-2], ">>") == 0)
	      {
		error = CreateInstance(args[argc-1], FAPPEND, creply);
		rtMsg->stdoutserver = creply->fileserver;
		rtMsg->stdoutfile = creply->fileid;
		rtMsg->rootflags |= STDOUT_REDIRECTED + RELEASE_OUTPUT +
			STDOUT_APPEND;
	      }
	    else if (strcmp(args[argc-2], ">?") == 0)
	      {
		error = CreateInstance(args[argc-1], FCREATE, creply);
		rtMsg->stderrserver = creply->fileserver;
		rtMsg->stderrfile = creply->fileid;
		rtMsg->rootflags |= STDERR_REDIRECTED + RELEASE_ERR;
	      }
	    else if (strcmp(args[argc-2], ">>?") == 0)
	      {
		error = CreateInstance(args[argc-1], FAPPEND, creply);
		rtMsg->stderrserver = creply->fileserver;
		rtMsg->stderrfile = creply->fileid;
		rtMsg->rootflags |= STDERR_REDIRECTED + RELEASE_ERR +
			STDERR_APPEND;
	      }
	    else if (strcmp(args[argc-2], ">&") == 0)
	      {
		error = CreateInstance(args[argc-1], FCREATE, creply);
		rtMsg->stdoutserver = creply->fileserver;
		rtMsg->stdoutfile = creply->fileid;
		rtMsg->stderrserver = creply->fileserver;
		rtMsg->stderrfile = creply->fileid;
		rtMsg->rootflags |= STDOUT_REDIRECTED + STDERR_REDIRECTED +
			RELEASE_OUTPUT;
	      }
	    else if (strcmp(args[argc-2], ">>&") == 0)
	      {
		error = CreateInstance(args[argc-1], FAPPEND, creply);
		rtMsg->stdoutserver = creply->fileserver;
		rtMsg->stdoutfile = creply->fileid;
		rtMsg->stderrserver = creply->fileserver;
		rtMsg->stderrfile = creply->fileid;
		rtMsg->rootflags |= STDOUT_REDIRECTED + STDERR_REDIRECTED +
			STDOUT_APPEND + STDERR_APPEND + RELEASE_OUTPUT;
	      }
	    else if (strcmp(args[argc-2], "<>") == 0)
	      {
		error = CreateInstance(args[argc-1], FCREATE, creply);
		rtMsg->stdoutserver = creply->fileserver;
		rtMsg->stdoutfile = creply->fileid;
		rtMsg->stdinserver = creply->fileserver;
		rtMsg->stdinfile = creply->fileid + 1;
		rtMsg->rootflags |= STDIN_REDIRECTED + STDOUT_REDIRECTED +
			RELEASE_INPUT + RELEASE_OUTPUT;
	      }
	    else if (strcmp(args[argc-2], "<>&") == 0)
	      {
		error = CreateInstance(args[argc-1], FCREATE, creply);
		rtMsg->stdoutserver = creply->fileserver;
		rtMsg->stdoutfile = creply->fileid;
		rtMsg->stderrserver = creply->fileserver;
		rtMsg->stderrfile = creply->fileid;
		rtMsg->stdinserver = creply->fileserver;
		rtMsg->stdinfile = creply->fileid + 1;
		rtMsg->rootflags |= STDIN_REDIRECTED + STDOUT_REDIRECTED +
			STDERR_REDIRECTED + RELEASE_INPUT + RELEASE_OUTPUT;
	      }


	    if (error != OK)
	      {
		fprintf(shOut, "ERROR: couldn't open %s for IO: %s.\n",
			args[argc-1], ErrorString(error));
		return(error);
	      }
	    args[argc-2] = NULL;
	    argc -= 2;
	  }

	else
	  {
	    break;		/* No more redefinitions to handle. */
	  }
      }
    *ptrArgc = argc;
    return(OK);
  }
