/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * History mechanism for V shell.
 * Marvin Theimer.
 *
 * Marvin Theimer, Aug/83
 *	File first created.
 *
 * Handle !! when no history. Per Bothner. Oct/83
 */

#include <Vio.h>
#include "sh.h"

extern char *strsave();




/*
 * InitHistory:
 * Initialize history mechanism.
 */

InitHistory(h)
    HistoryRec *h;
  {
    int i;

    for (i = 0; i < MaxCmds; i++)
      {
	h->cmds[i] = NULL;
      }
    h->nextCmd = 0;
  }




/*
 * DoHistory:
 * Either replaces the input line with the appropriate history line or
 * enters the line as a new line in the history.  
 * Returns -1 if an error occurs, 0 if no history reference is encountered,
 * and the length of the history line designated if one is encountered.
 */

int DoHistory(lineBuf, h)
    char lineBuf[];
    HistoryRec *h;
  {
    int j, flag;
    char *s1, *s2;

	if (lineBuf[0] == '!')	/* This is a command history invocation. */
	  {
	    if (lineBuf[1] == '!')
				/* Reexecute the last command. */
	      {
	        if (h->nextCmd != 0)
		    j = h->nextCmd - 1;
		else
		  {
		    j = MaxCmds - 1;
		    if (h->cmds[j] == NULL)
		        return -1; /* no previous command */
		  }
	      }
	    else
	      {
		for (j = h->nextCmd - 1; j != h->nextCmd; j--)
		  {
		    if (j == -1)
			j = MaxCmds - 1;
		    flag = 0;
		    if (h->cmds[j] == NULL)
				/* Haven't filled the whole history yet. */
			break;
		    s1 = lineBuf + 1;
		    s2 = h->cmds[j];
		    while (*s1++ == *s2++)
			if ((*s1 == '\0') || (*s1 == ' '))
			  {
			    flag = 1;
			    break;
			  }
		    if (flag)
			break;
		  }
		if (!flag)
				/* Couldn't find the designated command. */
		  {
		    return(-1);
		  }
	      }
	    strcpy(lineBuf, h->cmds[j]);
	    return(strlen(lineBuf));
	  }
	else
	  {
	    /* Save the command in the command history. */
	    if (h->cmds[h->nextCmd] != NULL)
		free(h->cmds[h->nextCmd]);
	    h->cmds[h->nextCmd++] = strsave(lineBuf);
	    if (h->nextCmd == MaxCmds)
		h->nextCmd = 0;
	    return(0);
	  }
  }




/*
 * PrintHistory:
 * Print out the command history.
 */

PrintHistory(h, out)
    HistoryRec *h;
    File *out;
  {
    int j;

    for (j = h->nextCmd + 1; j != h->nextCmd; j++)
      {
	if (j == MaxCmds)
	  {
	    j = 0;
	  }
	if (h->cmds[j] ==  NULL)
	  {
	    continue;
	  }
	fprintf(out, "%s\n", h->cmds[j]);
      }
  }
