/*	extra.c:	ved features and improvements			*/
#include "vedit.h"
#include <Vnaming.h>

/***************************  Window Banners  ***************************/

static int b_modified;
extern File *OpenName();
extern char *ErrorString(), *fgets();

/* RJN - 8/12/83 - Changed banner routines to use VGT banners instead of
 *		   ved's own.   Created SetContextBanner for the command vgt.
 *		   Removed blinking banners (impossible in current scheme),
 *		   will wait for VGTS to implement visual bells.
 */
DisplayBanner( VgtFile, prefix, line )
    File *VgtFile;
    char *prefix;
    char *line;
  {
    static char TmpBanner[ MAX_FILE_NAME_LEN ];
    static char BannerFormat[] = "%s%s";

    strcpy( TmpBanner, prefix );
    strcat( TmpBanner, line );
    SetVgtBanner( VgtFile, TmpBanner );

  } /* DisplayBanner */
    
    
Banner()
  {
    static char NoFileName[] = "(No file)";
    DisplayBanner( pad, modified ? "*" : ""
    		, *filename == NULL ? NoFileName : filename );
    DisplayFixedMenu( pad, Nrows );
    PadPosition( pad, currow, curcol );
  } /* Banner */

extern char *ErrorString(), *strncat();
extern SystemCode GetContextName();

#define NAME_BUFFER_SIZE	512
static char NameBuffer[2][ NAME_BUFFER_SIZE + 1 ];
char *CurrentContextName = NULL;

SystemCode SetContextBanner()
  {
    SystemCode error;
    ProcessId ServerPid,NewServerPid;
    ContextId Context;
    register char *NewName, *OldName, *TmpName;
    register int NameLen;
    int NewNameLen;

    ServerPid = PerProcess->nameserver;
    Context = PerProcess->contextid;
    NewName = NameBuffer[0];
    OldName = NameBuffer[1];
    *OldName = NULL;
    *NewName = NULL;
    NameLen = 0;

    do 
      {
	NewServerPid = ServerPid;
	
	NewNameLen = NAME_BUFFER_SIZE - NameLen;
	
        if ( (error = GetContextName( NewName, &NewNameLen, &NewServerPid
	            		      , &Context, NewServerPid )) != OK )
          {
            /* failed to get name */
	    NewMsg( NewName ); 
	    Msg( ": " );
 	    Msg( ErrorString( error ) );
            return( error );
          }
	
        /* prepend the new name */
	TmpName = strncat( NewName, OldName, NameLen );
	NewName = OldName; 
	OldName = TmpName;
	
	if ( (NameLen += NewNameLen) >= NAME_BUFFER_SIZE )
	    break;
      }      
    while ( NewServerPid != ServerPid && Context != ANY_CONTEXT );

    NewNameLen = NAME_BUFFER_SIZE;
    NewName[0] = NULL;

    ServerPid = GetPid( NAME_SERVER, LOCAL_PID );
    if ( ServerPid != NewServerPid
         && (error = GetContextName( NewName, &NewNameLen, &NewServerPid
 	        		     , &Context, ServerPid )) != OK )
      {
        /* failed to get name */
	NewMsg( NewName ); 
	Msg( ": " );
	Msg( ErrorString( error ) );
        return( error );
      }

    if ( NewName[0] != NULL )
        strncat( NewName, OldName, NAME_BUFFER_SIZE - NewNameLen );
    else
        NewName = OldName, NewNameLen = 0;

    if ( NameLen >= NAME_BUFFER_SIZE || NewNameLen >= NAME_BUFFER_SIZE )
        NewMsg( "context name may have been truncated" );

    DisplayBanner( stdout, "", NewName );
    
    CurrentContextName = NewName;

    return( OK );

  } /* SetContextBanner */

UpdateBanner()
{
  if (b_modified != modified) 
    {
      Banner();
      b_modified = modified;
    }	
  }


/****************************  Auto Indentation  ****************************/

/* CountIndent: count the number of physical spaces of indentation on	*/
/* the line containing "here".  Backrows(here,0) gets us to the beginning*/
/* of the line.								*/
int CountIndent(here)  Mark here;
{ Mark m;
  register int indent = 0;
  register char ch;

  m = Backrows(here, 0);
  while ((*m.cp == '\n' || Atend(m)) && !Atstart(m))  m = Backrows(m, 1);
/*^*/myprint(0x100)("m = (%x, %x)\n", m.chunk, m.cp);
  ch = *m.cp++;  Advance(&m);

  while (ch == ' ' || ch == '\t') {
    if (ch == '\t')  indent = 1 + (indent | 07);
    else indent++;
    ch = *m.cp++;
    Advance(&m);
    }
/*^*/myprint(0x100)("indent is %d\n", indent);
  return(indent);
  }

/* InsertIndent: At the cursor, which we presume is at the start of a	*/
/* line, we insert "indent" spaces, using tabs where possible.		*/
InsertIndent(indent)  register int indent;
{ register int i, tabs, spaces;

  tabs = indent >> 3;		/* divided by 8 */
  spaces = indent & 07;		/* modulo 8 */
  for (i=0; i<tabs; i++)  SelfInsert('\t');
  for (i=0; i<spaces; i++)SelfInsert(' ');
  }

/* RemoveIndent: Remove all whitespace from the head of this line,	*/
/* leaving the cursor at the beginning of the line.			*/
RemoveIndent()
{
  curmark = Backrows(curmark, 0);	/* to beginning of line */
  MarkSetcursor(curmark);
  PreAdjust(curmark, curpos, &eolmark, &eolpos);
  while (*curmark.cp == ' ' || *curmark.cp == '\t')
    TextDeleteForward();
  AdjustDisplay(curmark, eolmark, &curpos, &eolpos);
  MarkSetcursor(curmark);
  }

/* ShoveRight: Increase the indentation of the current line by n	*/
/* Tabs are used wherever possible.					*/
ShoveRight(n)  int n;
{ register int i;

  i = CountIndent(curmark);
  RemoveIndent();
  InsertIndent(i+n);
  }

/* ShoveLeft: Decrease the indentation of the current line by n		*/
/* Lines indented by less than n end up flush left.			*/
ShoveLeft(n)  int n;
{ register int i;

  i = CountIndent(curmark);
  RemoveIndent();
  if (i > n) InsertIndent(i-n);
  }


/* OpenBrace: V project styling for '{' (key esc-{ 			*/
OpenBrace()
{ register int i;

  i = CountIndent(curmark);
  SelfInsert('\n');
  InsertIndent(i+2);
  SelfInsert('{');
  SelfInsert('\n');
  InsertIndent(i+4);
  }

/* CloseBrace: V project styling for '}'				*/
CloseBrace()
{ register int i;

  i = CountIndent(curmark);
  if (i < 4) {Beep();  return;}
  SelfInsert('\n');
  InsertIndent(i-2);
  SelfInsert('}');
  SelfInsert('\n');
  InsertIndent(i-4);
  }


/* GotoLine: Go to a line by line number.  The first line is numbered 1.*/
/* Returns the number of the line it actually got, which may be less	*/
/* than "goal" if end of file is encountered.				*/
int GotoLine(goal)  register int goal;
{ register Chunk chunk = headmark.chunk;
  register char *cp;
  register int line = 1;
  Mark m;

  if (goal <= 1) {
    DispSetcursor(headmark);
    return(1);
    }
  for (; chunk; chunk = chunk->next) {
    for (cp = chunk->text; cp < Chunkend(chunk);  cp++) {
	if (*cp == '\n') {
	    line++;
	    if (line == goal) {
		m = Makemark(chunk, cp+1);  Advance(&m);
		DispSetcursor(m);
		return(line);
		}
	    }
	}
    }
  DispSetcursor(endmark);
  return(line);
  }


#define wordchar(c) 	( (c >= '0' && c <= '9') || (c >= 'A' && c <= 'Z') || \
			  (c >= 'a' && c <= 'z') || (c == '_') )

/* ForwardWord: find the next end of word, forward */
Mark  ForwardWord(m)  Mark m;
{
  int eof;
  char ch;

  ch = *m.cp;
  while (!wordchar(ch)) {
    m.cp++;
    eof = Advance(&m);
    if (eof) return(m);
    ch = *m.cp;
    }
  while (wordchar(ch)) {
    m.cp++;
    eof = Advance(&m);
    if (eof) return(m);
    ch = *m.cp;
    }
  return(m);
  }


/* BackWord: find the next beginning of word, backward */
Mark  BackWord(m)  Mark m;
{
  int eof;
  char ch;

  do {
    eof = Retract(&m);
    if (eof) return(m);
    ch = *m.cp;
    }
   while (!wordchar(ch));

  while (wordchar(ch)) {
    eof = Retract(&m);
    if (eof) return(m);
    ch = *m.cp;
    }
  m.cp++;
  Advance(&m);
  return(m);
  }


/* RJN -- 4/22/83 -- created the tags package */
/*
 * Find a tag in the tags file in the current context.  
 * The tag file is presumed to be structured like a unix tags file
 * The definitions for the apropriate seperators and terminators
 * are included here.  The file is presumed to have variable lenght
 * records, if otherwise the algorithm should be modified to increase
 * performance. 
 */
#define TRUE			1
#define FALSE			0

#define MAX_REC_SIZE		256
#define TAG_FILE_NAME		"tags"

#define BIN_SRCH_LIMIT		100	/* Binary search threshold */

/* Record seperator is the newline character */
#define BACK_SLASH		'\\'
#define TAG_FIELD_SEP	 	'\t'
#define TAG_START_SEARCH	'^'
#define TAG_DELIM_SEARCH	'?'
#define TAG_END_SEARCH		'$'

#define	TAG_NOT_FOUND	0
#define BAD_TAG_ENTRY	1
#define TAG_FILE_ERR	2
static char *TagErrors[] =
  {
    "Tag not found",
    "bad tag file entry",
    "Tags file: "
  };
typedef struct
  { 
    char *filename;
    char *searchstring;
  } TagStruct;

static char TagFileBuffer[MAX_REC_SIZE];
static TagStruct TagDesc;

TagStruct *FindTag( Tag )
    char Tag[];
  /* 
   * Open the file 'tags' and search the file for a line that contains
   * Tag as its first field.  Once found the next field should be the
   * file that the tag is in and the last field should contain a search
   * string to locate the tag in the named file.  On error the file name
   * pointer will be null and searchstring will contain an error message
   * describing the problem.
   * Algorithm:
   *	Use a binary search until the search space is less than a threshold
   *	amount.  A simple linear search is performed on this remaining
   *	search space.  Tag matches are expected to be exact, but this
   *	is not necessary
   */
  {
    register long start,end,middle;	/* for binary search */
    register char *tp;
    register char *bp;
    File *TagFile;
    SystemCode err;
    extern Close(), Seek();
    extern File *Open();

    TagDesc.filename = NULL;	/* rather pessimistic assumption */
    TagDesc.searchstring = NULL;

    if ( (TagFile = Open( TAG_FILE_NAME, FREAD, &err )) == NULL )
      {
       	TagDesc.searchstring = ErrorString( err );
	goto quit;
      }

    start = 0;
    end = (TagFile->blocksize * TagFile->lastblock) + TagFile->lastbytes;
    
    /* Do a binary search on the file */
    while ( start + BIN_SRCH_LIMIT < end )
      {

        tp = Tag;
	bp = TagFileBuffer;
	middle = (start + end)/2;
	Seek( TagFile, middle, ABS_BYTE );

	if (  fgets( bp, sizeof(TagFileBuffer), TagFile ) == NULL )
	  {
	    if ( TagFile->lastexception != END_OF_FILE )
	      {
       		TagDesc.searchstring = ErrorString( TagFile->lastexception );
		goto quit;
	      }
	    else
		break; /* go to linear search */
          }

	/* get the string to be checked */
	if ( fgets( bp, sizeof(TagFileBuffer), TagFile ) == NULL 
	     && TagFile->lastexception != END_OF_FILE )
	  {
       	    TagDesc.searchstring = ErrorString( TagFile->lastexception );
	    goto quit;
          }

	/* compare tag with the value read in */
	while ( *bp != TAG_FIELD_SEP && *bp == *tp)
	    bp++, tp++;

	if ( *bp == TAG_FIELD_SEP && *tp == NULL )  /* exact match */
	  { /* found it */
	    TagDesc.filename = ++bp;
	    break;
	  }

	/* This tag didn't match */
	if ( *bp > *tp )
   	    end = middle+1;  /* variable record lengths require this */
	else
	    start = middle-1;

      } /* binary search */
    
    if ( TagDesc.filename == NULL )
      {
        /* haven't found nor failure attempt a linear search from start */
	Seek( TagFile, start, ABS_BYTE );

	/* align to record seperator */        
	if ( start != 0 
	  && fgets( TagFileBuffer, sizeof(TagFileBuffer), TagFile ) == NULL )
	      {
	        if ( TagFile->lastexception != END_OF_FILE )
	            TagDesc.searchstring = ErrorString( TagFile->lastexception );
		/* else not found */
	        goto quit; /* to common exit */
              }

	/* do a linear search from start to end */ 
	do
	  {
	    bp = TagFileBuffer;
	    tp = Tag;
	    if ( fgets( bp, sizeof(TagFileBuffer), TagFile ) == NULL 
	         && TagFile->lastexception != END_OF_FILE )
	      {
	        TagDesc.searchstring = ErrorString( TagFile->lastexception );
		goto quit;
	      }
	    /* compare tag with the value read in */
	    while ( *bp != TAG_FIELD_SEP && *bp == *tp)
	        bp++, tp++;

	    if ( *bp == TAG_FIELD_SEP && *tp == NULL )  /* exact match */
	      { /* found it */
	        TagDesc.filename = ++bp;
	        break;
	      }
	  } 
        while( (TagFile->blocksize*TagFile->block + TagFile->readindex) < end );
	/* end do linear search */


	/* did we fail? */
        if (TagDesc.filename == NULL) goto quit;
      }
     
    /* found it so try to parse the entry */
    tp = bp;
    while( *bp != NULL && *bp != TAG_FIELD_SEP ) bp++;

    /* bp == tp  ==> null filename */
    if ( bp != tp && *bp == TAG_FIELD_SEP ) /* else bad entry */
      {
	/* Terminate filename and look for search string start */
        *bp++ = NULL;
	
        while ( *bp != NULL && *bp != TAG_START_SEARCH ) bp++;

	if ( *bp == TAG_START_SEARCH ) /* else bad entry */
          {
	    /* save search string and search for end to terminate */
	    TagDesc.searchstring = ++bp;
	    middle = 0;
	    while( *bp != NULL && *bp != TAG_END_SEARCH 
		   && *bp != TAG_DELIM_SEARCH ) 
	      {
		/* ctags inserts a escapes a backslash character with
		   another back slash, so we must eliminate this occurance 
		 */
		*bp = bp[middle];
	        if( *bp++ == BACK_SLASH ) middle++;
	      }

	    /* terminate search string and return entry */
	    *bp = NULL;
	    goto quit; /* go to common exit of routine */
	  }
      } /* entry parsing */
	
    /* the tag file entry had some type of error in it */
    TagDesc.filename = NULL;
    TagDesc.searchstring = TagErrors[ BAD_TAG_ENTRY ];

quit:
    if (TagDesc.filename == NULL )
      {
        if (TagDesc.searchstring == NULL) /* default error */
	    TagDesc.searchstring = TagErrors[ TAG_NOT_FOUND ];
	else
	  { /* file error of some sort */
	    bp = TagFileBuffer, tp = TagErrors[ TAG_FILE_ERR ];
	    while( *tp ) *bp++ = *tp++;
	    tp = TagDesc.searchstring;
	    while( *tp ) *bp++ = *tp++;
	    *bp = NULL;
            TagDesc.searchstring = TagFileBuffer;
	  }
       }
	   
    if (TagFile != NULL) Close( TagFile );
    
    return( &TagDesc );

  } /* FindTag */

        
/* 
 * Do a tag find on the string.  If the tag is found then try to open
 * the file in the TagDesc.  If a buffer already exists for that file
 * then do not create new window just select the buffer associated with
 * that file. Once a pad is selected, we then must search for the tag
 * searchstring.  This is done by first going forwards, then backwards.
 * This order could be improved, if information about fileposition was
 * taken into account.  More often than not a new file we be opened and
 * that is why the forward search is attemted first.
 */
 
TagSearch( tagname )
    char *tagname;
  {
    register int n;
    register TagStruct *TagDesc;
    Chunk nchunk;
    extern char searchstring[], filename[];
    extern int searchlen, thisbuffer, wishcol;
    extern short selectionexists;
    extern Mark curmark, mousemark;
    extern int TextString(), NewMsg(), FindBuffer(), StoreBuffer();
    extern int strcpy(), NewBuffer(), FreeText(), PickBuffer();
    extern int SelFind(), Search(), ReverseSearch();
    extern TagStruct *FindTag();
    extern Chunk ReadFile();
    char TmpName[ MAX_FILE_NAME_LEN ];
    char TmpName2[ MAX_FILE_NAME_LEN ];
    File *FileDesc;

    TagDesc = FindTag( tagname );
    if (TagDesc->filename == NULL)
      {  /* fail */
	if( selectionexists)
	   TextString(curmark, mousemark, searchstring, 80);
        NewMsg( TagDesc->searchstring );
      }
    else
      { /* found */
	regionmark = curmark;	/* so you can get back to former place */
        StoreBuffer(thisbuffer); /* must do here, because this buffer may
	 			     not be stored. FindBuffer only looks
			             at "stored" filenames.
				   */
/*^*/ myprint(0x800)("Buffer #%d stored\n",thisbuffer);

	/* See if the filename matches any of the buffer names */
        
	strcpy( TmpName2, TagDesc->filename );
	FileDesc = OpenName( TmpName, TmpName2 );
        if ((n = FindBuffer( TmpName )) < 0)
          { /* get a new buffer */
	   /* Most of this magic stolen from "get file:" (^Xg) */
           strcpy( filename, TmpName );

            /* guarranteed to have a non-null
               filename from findtag and also the name is guarranteed
	       to be full. */
	    nchunk = ReadFile( FileDesc );
/*^*/ myprint(0x800)("file %s chunk %x  ",filename,nchunk);
	    n = NewBuffer(nchunk);  /* handles display and cursor */
            if (n==0) FreeText(nchunk);
/*^*/ myprint(0x800)("done.\n");
            wishcol = 0; 
	    if (n==0) return; /* don't bother searching */
          }
	else /* TagDesc.filename buffer exists */
		  /* May want to change this */
          {
	    Close( FileDesc );	/* only used to get file name */
	    PickBuffer( n );
	  }

	{ /* copy the strings and get the byte count 
	     nice if strcpy returned bytes instead of s1 */
	  register char *s1 = searchstring;
	  register char *s2 = TagDesc->searchstring;
	  n = 0;
	  while( (*s1 = *s2) != NULL ) s1++, s2++, n++;
	  searchlen = n;
	}

        /* Search Reverse then forward */
        /* tricky */
	SelFind( Search( searchstring, searchlen)
		         || ReverseSearch( searchstring, searchlen) );
      }
      
  } /* TagSearch */

