/* convert.c: elementary routines to convert between the (chunk,cp) 	*/
/* representation and the (row,col) representation of a place in the	*/
/* text.  Various other routines for computing places in the text.	*/

#include "vedit.h"

/* Makepos: construct a Pos out of two integers */
Pos Makepos(r,c)  int r,c;
{ Pos p;
  p.row = r;  p.col = c;
  return(p);
  }

/* Makemark: construct a Mark out of a chunk pointer and a char pointer */
Mark Makemark(chunk,cp)  Chunk chunk;  char *cp;
{ Mark m;
  m.chunk = chunk;  m.cp = cp;
  return(m);
  }

/* Rowmark: given a row number, find the Mark of its first character.	*/
/* warning: do not call Rowmark on a nonexistent row.			*/
Mark Rowmark(row) register int row;
{ Mark m;
  m.chunk = rows[row].chunk;
  m.cp = rows[row].cp;
  return(m);
  }


/* Rowsend: given a row number, find the Mark at the end of the row:	*/
/* For a continued line, the last character on this row, else the \n	*/
/* which ends this row. 						*/
Mark Rowsend(row) register int row;
{ Mark m;
  register int nextrow;

  if (row < 0 || row >= Nrows) {
    printf("Rowsend on row %d!\n",row);
    return(Rowmark(Nrows));
    }
  nextrow = row + 1;
  if (!rows[nextrow].exists) return(endmark);
  else {
    m = Rowmark(nextrow);
    Retract(&m);
    return(m);
    }
  }


/* Markcol: given a row and a Mark (which must be in that row) find 	*/
/* the column position of that Mark.					*/
int Markcol(row, mark)  register int row; Mark mark;
{ register int col=0;
  register char ch;
  Mark m;

  m = Rowmark(row);
  while(MarkNEQ(m,mark)) {
    ch = *m.cp++;
    Advance(&m);
    col = CountWidth(ch,col);
    if (col < 0) {
	printf("Markcol mark not found: row %d with cp %x, mark at %x\n",
	    row, rows[row].cp, mark.cp);
	return(0);
	}
    }
/*^*/ myprint(2)("Markcol of %d, (%x, %x) gives %d\n", row,
	mark.chunk, mark.cp, col);
  return(col);
  }


/* Markpos: given a Mark, which must be on the screen somewhere, return the
   position of that character on the screen. */
Pos Markpos(mark)  Mark mark;
{ Pos p; Chunk chunk;
  register int row;

/* easy search: some row starts in this chunk */
  for (row=0; row<Nrows && rows[row+1].exists; row++)
    if (rows[row].chunk == mark.chunk) break;
  if (row < Nrows) {
    if (mark.cp < rows[row].cp) row--;
    else while (mark.chunk == rows[row+1].chunk && mark.cp >= rows[row+1].cp
		&& rows[row+1].exists )
	row++;
    }
/* long search: search all chunks on the page.  If the chunk is indeed	*/
/* on the page, it is entirely within one row.				*/
  else {
    row = 0;
    for (chunk = rows[0].chunk; chunk && chunk != mark.chunk; 
	    chunk = chunk->next)
	while (chunk == rows[row].chunk) row++;
    if (chunk == NULL) {
	printf("Markpos: chunk %x cp %x not on screen\n",mark.chunk,mark.cp);
	return(zeropos);
	}
    else if (row > Nrows) {
	printf("Markpos: chunk %x cp %x at row %d\n",mark.chunk,mark.cp,row);
	return(zeropos);
	}
    row--;
    } /* end else */
/*^*/ myprint(2)("Markpos chunk %x cp %x row %d\n",mark.chunk,mark.cp,row);

  p.col = Markcol(row,mark);
  p.row = row;
  return(p);
  }


/* Posmark: given a position on the screen, return the Mark of the character
   nearest to it.  If there is no match, ALTER the Pos to match the truth. */
Mark Posmark(ppos) register  Pos *ppos;
{ Mark m;
  register int row, col, prevcol;
  register char ch;

/*^*/ myprint(2)("Posmark of (%d,%d)  ",ppos->row,ppos->col);
  row = ppos->row;
  if (!rows[row].exists) {  /* beyond end of text */
    while(!rows[row].exists) row--;
    col = rows[row].length;
    m = endmark;
    }
  else if (row == Nrows)  { /* works on Nrows ONLY for column 0 */
    col = 0;
    m = Rowmark(Nrows);
    }
  else if (ppos->col >= rows[row].length) {  /* beyond end of line */
    col = rows[row].length;
    if (rows[row].continued) col--;
    m = Rowsend(row);
    }

  else {
    m = Rowmark(row);
    col = 0;
    while (col <= ppos->col) {
	prevcol = col;
	ch = *m.cp++;
	Advance(&m);
	col = CountWidth(ch,col); 
	}
    col = prevcol;
    Retract(&m);
    }

/*^*/ myprint(2)("finds mark (%x, %x) at (%d,%d)\n", m.chunk, m.cp,
	row, col);
  ppos->row = row;
  ppos->col = col;
  return(m);
  }


/* Backrows: find the line n rows back from a given line.  If that would */
/* land you in the middle of an overflowed line, go to the beginning of  */
/* that line.  Calculations are done in terms of tabs: text lying after	 */
/* the last-seen tab is of a known length, hence "solid".  Text lying    */
/* before the last-seen tab is of uncertain length, hence "fluid".	 */
/* The calculation is faulty in one respect: it assumes that all tabs	 */
/* fill out a field of length 8, calculates the natural length of the	 */
/* line, and divides by Ncols.  However, when Ncols mod 8 != 0 a tab at	 */
/* the end of the line may fill out a field of length <8.		 */
Mark Backrows(m,n) Mark m;  int n;
{ register int rowcount, solid, fluid, tabseen;
  register Chunk chunk;
  register char *cp;
  register char ch;
  Mark newmark;

  chunk = m.chunk;  cp = m.cp;
  rowcount = -1;

  while (rowcount < n) {
    solid = fluid = tabseen = 0;
    cp--;
    if (cp < chunk->text) {
	if (!chunk->prev)  return(Makemark(chunk, chunk->text));
	else {
	    chunk = chunk->prev;
	    cp = Chunkend(chunk) - 1;
	    }
	}
    ch = *cp;
    if (ch == '\t') {
	if (tabseen) solid += (fluid & 07) + 1;
	else solid = fluid;
	tabseen = 1;  fluid = 0;
	}
    else if (ch == '\n') {
	if (tabseen) solid += (fluid & 07) + 1;
	else solid = fluid;
	if (solid > 0)  rowcount += 1 + ((solid-1)/Ncols);
	else rowcount++;
	solid = fluid = tabseen = 0;
	}
    else fluid += charsize[ch];	/* all chars of predictable size */
    }
  newmark = Makemark(chunk, cp+1); /* forward from the \n */
  Advance(&newmark);
  return(newmark);
  }

