/**************  Routines for ansi standard terminal interface  **************/
#include <Vio.h>
#include "ansipad.h"

static char escsequence[20];

PadEscSequence(p,string)  File *p;  register char *string;
{
  PadSend(p,'\033');	/* escape */
  while (*string != '\0')  PadSend(p,*string++);
  }

PadCRLF(p)  File *p;
{ 
  PadClearToEOL(p);
  PadReturn(p);
  PadNewLine(p);
  }

PadPutCursor(p,row,col)  File *p;  int row,col;
{
  sprintf(escsequence,"[%d;%df",row+1,col+1);
  PadEscSequence(p,escsequence);
  }

PadScrollUp(p, top, bottom)  File *p;  int top, bottom;
{
  sprintf(escsequence,"[%d;%dr",top+1,bottom+1);
  PadEscSequence(p,escsequence);
  PadEscSequence(p,"D");
  }

PadScrollDown(p, top, bottom)  File *p;  int top, bottom;
{
  sprintf(escsequence,"[%d;%dr",top+1,bottom+1);
  PadEscSequence(p,escsequence);
  PadEscSequence(p,"M");
  }
