/*	action.c:	Keyboard Command Actions 			*/

#include "vedit.h"
#include "chardef.h"
#include "ansipad.h"

extern File *OpenName();
File *FileDesc;
SystemCode error;

/* The compound command system:  the following sequences are recognized	*/
/* as command prefixes, not as command prefixes in themselves.  This	*/
/* recognition is handled in StateMachine, which returns -1 until it 	*/
/* has recognized a complete command, then adds high order bits to the	*/
/* final character to indicate the prefix.				*/
/* Escape		like the "meta" key in the original emacs	*/
/* Control-X		precedes "large" file, buffer, region commands	*/
/* Escape Escape	prefix to "escape arrow" sequences on SMI's	*/
/* Escape [		prefix to ANSI standard arrow key codes		*/
/* Escape [ O		prefix to SMI PF1-PF4 keys			*/
/* Escape Escape [	"escape-arrow"					*/
/* Escape Escape [ O	"escape-PFn"					*/
/* The macros by which I express these compound commands, CONTROL,	*/
/* ESCAPE, and ANSI, are defined in chardef.h .				*/

int	quoted = 0, hiquote = 0, keystate = 0, escmodifier = 0;

/* Setstate and Clearstate are local macros to StateMachine */
#define Setstate(s)	{keystate = s;  return(-1);}
#define Clearstate(b)	{n = ch | b | escmodifier;  \
			 keystate = escmodifier = 0;  \
			 return(n);}


int StateMachine(ch)  char ch;
{
  int n;
  switch(keystate) {
    case 0:	if (ch == ESC)  {Setstate(1);}
		else if (ch == CONTROL('X'))  {Setstate(2);}
		else return(ch);
	/* esc */
    case 1:	if (ch == ESC) {
		    escmodifier = 0x100;
		    return(-1);  /* stay in state 1 */
		    }
		else if (ch == '[') {Setstate(3);}
		else if (ch == 'O') {Setstate(4);}
		else {Clearstate(0x100);}
	/* ^X */
    case 2:	Clearstate(0x200);
	/* esc [ */
    case 3:	Clearstate(0x400);
	/* esc O */
    case 4:	Clearstate(0x800);
    }
  }


KeyAction(ch)  int ch;
{ unsigned int cmd;
  static unsigned int oldcmd = 0;

  int i,n,eof;
  char *cp, c;
  Chunk chunk,nchunk;
  Pos p;
  Mark m;
  Marklink marklp;

  cmd = ch;
/*^*/ myprint(8)("Keyaction 0x%x ",cmd);
  if (hiquote) {SelfInsert(ch|0x80);  hiquote = 0;}
  else if (quoted || (cmd >= ' ' && cmd < '\177')) {SelfInsert(ch);quoted = 0;}
  else switch(cmd) {

    case CONTROL('Q'):	/* quote following character */
	quoted = 1;
	break;

    case CONTROL('\\'):	/* insert following character with high bit set */
	hiquote = 1;
	break;

    case CONTROLX(CONTROL('Z')):	/* quit editor entirely */
	i = 0;
	goto Quitter;

	/* quit with confirmation: ^C has a different meaning when */
	/* dealing with ved-server windows.			   */
    case CONTROL('C'):	
	i = 1;
Quitter:if (AnyBufsModified()) {
	    NewMsg("There are modified buffers.  Save them? ");
	    n = Yesno();
	    if (n < 0)  break;			/* ^G abort */
	    else if (n > 0)  SaveAsNeeded();	/* yes */
	    }					/* no - just go on */
	else if (i) {
	    NewMsg("Confirm to quit? ");
	    if (Yesno() <= 0)  break; /* no or abort */
	    }
	SelectPad(stdout);
	return(-1);

    case CONTROL('G'):
    case ESCAPE(CONTROL('G')):
    case CONTROLX(CONTROL('G')):
    case ANSI(CONTROL('G')):
	Beep();
	break;

    case RIGHT_ARROW:
    case ANSI('C'):
    case CONTROL('F'):
	Forespace();
	break;

    case LEFT_ARROW:
    case ANSI('D'):
    case CONTROL('B'):
	Backspace();
	break;

    case CONTROL('A'):
	curcol = 0;
	curmark = Rowmark(currow);
	PadPosition(pad,currow,curcol);
	wishcol = 0;
	break;

    case CONTROL('E'):
	curmark = Rowsend(currow);
	MarkSetcursor(curmark);
	wishcol = Ncols;
	break;

    case DOWN_ARROW:
    case ANSI('B'):
    case CONTROL('N'):	/* down one physical line */
	Downaline();
	break;

    case UP_ARROW:
    case ANSI('A'):
    case CONTROL('P'):
	Upaline();
	break;

    case PF1:
    case SMI_PF1:
    case CONTROL('Z'):
	Scroll();
	break;
 
    case PF2:
    case SMI_PF2:
    case ESCAPE('z'):
	Backscroll();
	break;

    case ESCAPE('f'):	/* forward one word */
	if (Atend(curmark)) {Beep(); break;}
	curmark = ForwardWord(curmark);
	DispSetcursor(curmark);
	break;

    case ESCAPE('b'):	/* backward one word */
    case ESCAPE('\b'):	/* escape-backspace works too */
	if (Atstart(curmark)) {Beep(); break;}
	curmark = BackWord(curmark);
	DispSetcursor(curmark);
	break;

    case ESCAPE(DOWN_ARROW):	/* move view 1/2 screen down in the text */
    case ESCAPE(ANSI('B')):
    case ESCAPE(PF1):
    case ESCAPE(SMI_PF1):
	n = Nrows/2;
	if (!rows[n].exists) {Beep(); break;} 
	while(rows[n].continues) n--;
	m = Rowmark(n);
	Display(m);
	if (currow < Nrows/2) {
	    Setcursor(Rowmark(0), zeropos);
	    wishcol = curcol;
	    }
	else MarkSetcursor(curmark);
	break;

    case ESCAPE(UP_ARROW):	/* move view 1/2 screen up in the text */
    case ESCAPE(ANSI('A')):
    case ESCAPE(PF2):
    case ESCAPE(SMI_PF2):
	m = Backrows(Rowmark(0),Nrows/2);
	Display(m);
	if (currow >= Nrows/2) {
	    Setcursor(Rowmark(0), zeropos);
	    wishcol = curcol;
	    }
	else MarkSetcursor(curmark);
	break;


    case CONTROL('V'):
	PadHome(pad);
	if (!rows[Nrows-2].exists) {Beep(); break;}
	n = Nrows-2;
	while (rows[n].continues) n--;
	Display(Rowmark(n));	/* in which all Rowmarks are redefined */
	Setcursor(Rowmark(0), zeropos);
	wishcol = 0;
	break;

    case ESCAPE('v'):
	PadHome(pad);
	m = Backrows(Rowmark(0), Nrows-2);
	Display(m);
	Setcursor(m, zeropos);
	wishcol = 0;
	break;

    case CONTROL('L'):
	PadHome(pad);
	Display(Rowmark(0));
	DispSetcursor(curmark);	/* absolutely guarantee a consistent cursor */
	break;

    case ESCAPE(','):   /* pop to top of screen */
    case ANSI('H'):	/* the Home key on some keyboards */
	Setcursor(Rowmark(0), zeropos);  wishcol = curcol;
	break;

    case ESCAPE('.'):	/* pop to bottom of screen */
	PosSetcursor(Makepos(Nrows-1,Ncols-1));  wishcol = curcol;
	break;

    case ESCAPE('<'):
	Display(headmark);
	Setcursor(headmark, zeropos);
	wishcol = 0;
	break;

    case ESCAPE('>'):
	DispSetcursor(endmark);  /* wishcol is automatic */
	break;

    case ESCAPE('g'):	/* go to numbered line */
	NewMsg("Go to line: ");  n = Getline(linebuf, 72);
	BackToPad();
	i = atoi(linebuf);
	if (i<1) i=1;
	n = GotoLine(i);
	if (n < i) {
	    printf("\nfile ends at line %d",n);
	    Flush(stdout);
	    }
	break;

/* RJN -- 4/22/83 -- Added TagSearch (^Xt) */
    case CONTROLX('t'): /* tag search */
    	NewMsg("Tag:"); 
	n = Getline(linebuf,80);
	if (n > 0) 
	  { /* Transfer tag to search string */
	    for( i = 0; i < n; i++) 
	        searchstring[i] = linebuf[i];
	    searchlen = n;
	    searchstring[n] = NULL;	/* not the ved convention */
	    TagSearch( searchstring );
	  }
	break;

    case CONTROL('S'):	/* string search */
	NewMsg("Search:");  n = Getline(linebuf,80);
	if (n < 0) break;
	if (n > 0) {  /* new search string, not old one */
	    for (i=0; i<n; i++)  searchstring[i] = linebuf[i];
	    searchlen = n;
	    }
	  /*FALLTHRU*/


    case PF3:
    case SMI_PF3:
    case ESCAPE('s'):	/* search again for same string */
	SelFind(Search(searchstring, searchlen));
	break;

    case CONTROL('R'):	/* reverse search */
	NewMsg("Reverse search:");  n = Getline(linebuf,80);
	if (n < 0) break;
	if (n > 0) {  /* new search string, not old one */
	    for (i=0; i<n; i++)  searchstring[i] = linebuf[i];
	    searchlen = n;
	    }
	  /*FALLTHRU*/
    case PF4:
    case SMI_PF4:
    case ESCAPE('r'):	/* reverse search for same string */
	SelFind(ReverseSearch(searchstring, searchlen));
	break;

    case ESCAPE('q'):	/* query replace */
	NewMsg("Replace: ");  n = Getline(linebuf, 80);
	if (n < 0) break;
	if (n > 0) {
	    for (i=0; i<n; i++) searchstring[i] = linebuf[i];
	    searchlen = n;
	    }
	Msg("  with: ");  replen = Getline(repstring, 80);
	if (replen < 0) {
	    replen = 0;
	    break;
	    }
	SelFind(Search(searchstring, searchlen));
	break;

/*************************  Text changing commands  ************************/
    case DEL:
    case CONTROL('H'):  /* backspace */
	if (Atstart(curmark)) {Beep(); break;}
	if (currow == 0 && curcol == 0) Backscroll();
	Backspace();
   /*FALLTHRU*/

    case CONTROL('D'):
ctrlD:
	DeleteForward();
	break;

    case ESCAPE('d'):	/* delete word forward */
	if (Atend(curmark)) {Beep(); break;}
	mousemark = ForwardWord(curmark);  /* a handy Marklist mark */
	p = Markpos(mousemark);
	goto delword;

    case ESCAPE('h'):
    case ESCAPE(DEL):	/* delete word backward */
	if (Atstart(curmark)) {Beep(); break;}
	mousemark = curmark;  p = curpos;
	curmark = BackWord(curmark);
	DispSetcursor(curmark);
delword:
	PreAdjust(mousemark, p, &eolmark, &eolpos);
	FreeText(BlockDelete(curmark, mousemark));
	AdjustDisplay(curmark, eolmark, &curpos, &eolpos);
	if (currow == Nrows) Scroll();
	Setcursor(curmark, curpos);
	break;

    case '\r':	/* the Return key */
	SelfInsert('\n');
	break;

    case '\t':	/* the Tab key */
	SelfInsert('\t');
	break;

    case '\n':	/* the Linefeed key:  newline and indent */
	i = CountIndent(curmark);
	SelfInsert('\n');
	InsertIndent(i);
	break;

    case ESCAPE('\t'):  /* indent current line like previous one */
	m = Backrows(curmark, 0);
	MarkSetcursor(m);
	Retract(&m);
	i = CountIndent(m);
	InsertIndent(i);
	break;

    case CONTROL('O'):
	PreAdjust(curmark,curpos,&eolmark,&eolpos);
	TextInsertChar('\n');
	if (MarkEQ(curmark,eolmark)) {
	    eolmark.cp++;
	    Advance(&eolmark);
	    }
	AdjustDisplay(curmark,eolmark,&curpos,&eolpos);
	Setcursor(curmark,curpos);
	break;

    case CONTROL('K'):
	if (Atend(curmark)) {Beep(); break;}
	ch = *curmark.cp;
	if (ch=='\n') {
	    if (oldcmd == CONTROL('K')) KillbufAddNewline();
	    else {
		FreeText(killbuffer);
		killbuffer = killbuftail = NewChunk();
		killbuffer->prev = killbuffer->next = NULL;
		killbuffer->length = 1;
		killbuffer->text[0] = '\n';
		}
	    goto ctrlD;
	    }
	else {  /* find the block */
/*^*/ myprint(0x80)("^K: here goes...");  /* delete into killbuffer */
	    PreAdjust(curmark,curpos,&eolmark,&eolpos);
/*^*/ myprint(0x80)("eolmark (%x, %x)  eolpos (%d,%d)\n",
		eolmark.chunk,eolmark.cp,eolpos.row,eolpos.col);
	    if (eolpos.row < Nrows) m = eolmark;
	    else {
		m = curmark;
		do {ch= *m.cp++;  eof = Advance(&m);}
		 while (ch !='\n' && !eof);
		if (ch == '\n')  Retract(&m);
		}
	    nchunk = BlockDelete(curmark,m);
	    AdjustDisplay(curmark,eolmark,&curpos,&eolpos);
	    Setcursor(curmark, curpos);
	    if (oldcmd == CONTROL('K')) KillbufAdd(nchunk);
	    else {
		FreeText(killbuffer);
	    	killbuffer = killbuftail = nchunk;
		while (killbuftail->next) killbuftail = killbuftail->next;
		}
	    }
	break;

    case CONTROL('Y'):
    case ESCAPE('y'):
	if (killbuffer == NULL || killbuffer->length == 0) break;
	nchunk = CopyText(killbuffer);
	PreAdjust(curmark,curpos,&eolmark,&eolpos);
	m = BlockInsert(curmark,killbuffer);
	killbuffer = nchunk;
	AdjustDisplay(m,eolmark,&curpos,&eolpos);
	if (ch == CONTROL('Y')) {
	    regionmark = curmark;
	    if (currow == Nrows) Scroll();
	    Setcursor(m,curpos);
	    }
	else  DispSetcursor(curmark);
	break;

    case CONTROLX(CONTROL('V')):
	if (SaveIfModified() == 0) break;
	NewMsg("visit file: ");
	if ( (n = Getline(linebuf,72)) < 0 )
	    break;

/* RJN - 8/12/83 - changed to handle absolute path names */
	FreeText(headmark.chunk);
	BackToPad();
	if ( n > 0 ) 
	    nchunk = ReadFile( OpenName( filename, linebuf ) );
	else 
	  {
	    nchunk = NULL;
	    filename[ 0 ] = NULL;
          }

	if (nchunk == NULL) ClearBuffer();
	else InitBuffer(nchunk,readfile_end);
	Display(headmark);
	Setcursor(headmark, zeropos);  wishcol = curcol;
	modified = 0;
	break;

    case CONTROLX(CONTROL('S')):
	WriteWithAsk();
	modified = 0;
	Banner();
	break;

    case CONTROLX(CONTROL('W')):
/* RJN - 8/12/83 - changed to handle absolute path names */
	NewMsg("write file: ");  n = Getline(linebuf,72);
	if (n>0) {
	    /* try to write the file, then open for reading so we can
	       get the name.  Yes, this is a hack */
	    if ( !(modified = !WriteFile( linebuf, headmark, endmark )) )
 	        Close( OpenName( filename, linebuf ) );
	    Banner();
	    }
	break;

    case ESCAPE('~'):		/* mark this buffer unmodified */
	modified = 0;
	break;

    case CONTROLX('b'):		/* toggle backup option */
	backupoption ^= 1;
	if (backupoption) NewMsg("Backup option on");
	else NewMsg("Backup option off");
	break;

    case CONTROLX('c'):		/* change context */
        NewMsg("New context name: " );
        n = Getline(linebuf,79);
	BackToPad();
	if (n <= 0) break;
	if ( (error = ChangeDirectory( linebuf )) != OK )
	  {
	    NewMsg( "ChangeDirectory: " );
	    Msg( ErrorString( error ) );
	    break;
  	  }
	SetContextBanner();
	break;

    case CONTROLX(CONTROL('I')):  /* Insert File */
/* RJN - 8/12/83 - changed to handle absolute path names */
	NewMsg("insert file: ");  n = Getline(linebuf,79);
	if (n <= 0) break;
	BackToPad();
	nchunk = ReadFile( OpenName(filename2, linebuf) );
	if (!nchunk) break;	/* file not found */
Insert:	i = (currow == 0 && curcol == 0);
	m = BlockInsert(curmark,nchunk);
	if (i) Display(m);  /* make sure he gets to see what was inserted */
	else Display(Rowmark(0));
	regionmark = curmark;  /* Mark at the postinsertion point */
	curmark = m;	       /* cursor at the preinsertion point */
	break;	


    case ESCAPE('{'):		/* V-style start new block */
	OpenBrace();
	break;

    case ESCAPE('}'):		/* V-style end block */
	CloseBrace();
	break;

    case ESCAPE(RIGHT_ARROW):
    case ESCAPE(ANSI('C')):
	ShoveRight(4);
	break;

    case ESCAPE(LEFT_ARROW):
    case ESCAPE(ANSI('D')):
	ShoveLeft(4);
	break;

/**********************  Mark and Region Commands *********************/

    case SET_UP:
    case CONTROL('@'):
    case CONTROLX(CONTROL('M')): /* set the Mark (regionmark) */
	regionmark = curmark;  wishcol = curcol;
	NewMsg("Mark set");  
	break;

    case CONTROLX(CONTROL('X')):  /* Exchange Cursor and Mark */
	m = curmark;  curmark = regionmark;  regionmark = m;
	DispSetcursor(curmark);
	break;

    case CONTROLX(CONTROL('R')):  /* Write Region */
	NewMsg("Write region to file: ");
	n = Getline(linebuf,79);
	if (n <= 0) break;
	if (MarkEQ(regionmark,curmark)) 
	  { 
	    NewMsg("empty region not written"); 
     	  }
	else
	  {
	    if (MarkGT(regionmark,curmark))
	        WriteFile( linebuf, curmark, regionmark);
	    else 
	        WriteFile( linebuf, regionmark, curmark);
	    wishcol = curcol;  
	  }
	break;

    case CONTROLX(CONTROL('K')):  /* Kill Region */
	if (MarkEQ(regionmark,curmark)) break;
	FreeText(killbuffer);
	if (MarkGT(regionmark,curmark)) 
	    killbuffer = BlockDelete(curmark,regionmark);
	else  killbuffer = BlockDelete(regionmark,curmark);
	Display(Rowmark(0));
	MarkSetcursor(curmark);  wishcol = curcol;
	break;	    

/**********************  Multi-Buffering Commands  ************************/

    case CONTROLX('g'):		/* get file into new window */
	Flush(pad);  RedrawPad(pad);
	StoreBuffer(thisbuffer);
/*^*/ myprint(0x800)("Buffer #%d stored\n",thisbuffer);

	NewMsg("get file: ");
	if ( (n = Getline( linebuf, 72 )) < 0 ) 
	    break;	/* user abort */

/* RJN - 8/12/83 - changed to handle absolute path names */
	if ( n > 0 ) 
	    nchunk = ReadFile( OpenName( filename, linebuf ) );
	else 
	  { /* blank file name */
	    nchunk = NULL;
	    filename[0] = '\0';
	  }
/*^*/ myprint(0x800)("file %s chunk %x  ",filename,nchunk);
	n = NewBuffer(nchunk);  /* handles display and cursor */
	if (n==0) FreeText(nchunk);
/*^*/ myprint(0x800)("done.\n");
	wishcol = 0;
	break;

    case CONTROLX('d'):	/* Delete the current window and buffer.  The next
			   lower numbered window becomes selected.  */
	if (SaveIfModified() == 0) break;
	n = DeleteBuffer();
	if (n < 0) {
	    SelectPad(stdout);
	    return(-1);  /* last buffer: exit ved */
	    }
	break;

    case CONTROLX('y'):	/* Yank killbuffer into a new window */
	if (killbuffer == NULL || killbuffer->length == 0) {
	    NewMsg("Nothing to yank");
	    break;
	    }
	nchunk = CopyText(killbuffer);
	Flush(pad);  RedrawPad(pad);
	StoreBuffer(thisbuffer);
	filename[0] = '\0';	/* no file name */
	n = NewBuffer(nchunk);
	if (n) modified = 1;
	else FreeText(nchunk);
	wishcol = 0;
	break;

    case CONTROLX('a'):	/* Apart: chop out region and put it in a new window*/
	if (MarkEQ(regionmark,curmark)) {
	    NewMsg("Region is empty");
	    break;
	    }
	if (MarkGT(regionmark,curmark)) 
	    nchunk = BlockDelete(curmark,regionmark);
	else  nchunk = BlockDelete(regionmark,curmark);
	Display(Rowmark(0));
	MarkSetcursor(curmark);
	RedrawPad(pad);
   /* now we make the new buffer and window */
	StoreBuffer(thisbuffer);
	filename[0] = '\0';	/* no file name */
	n = NewBuffer(nchunk);
	if (n) modified = 1;
	else {
	    if (killbuffer) FreeText(killbuffer);
	    killbuffer = nchunk;
	    }
	wishcol = 0;
	break;

    case CONTROLX('m'):		/* merge windows */
	NewMsg("Select window to merge ");
	n = PickWindow(0);
	if (n<0) {NewMsg("Aborted");  break;}
	if (n == thisbuffer) {
	    NewMsg("Can't merge a window into itself");
	    break;
	    }
	  /* now we delete the chosen buffer but keep its text */
	i = thisbuffer;
	PickBuffer(n);
	DestroyProcess(keyproc);
	free(rows);
	free(buffers[thisbuffer].ptr);
	buffers[thisbuffer].ptr = NULL;
	buffers[thisbuffer].pad = 0;
	Close(pad);
	nchunk = headmark.chunk;
	SelectBuffer(i);
	goto Insert;	/* the ^X^I (Insert File) command */

     /* Keypad number keys: select the corresponding buffer */
    case K1:	case CONTROLX('1'):	PickBuffer(0);  break;
    case K2:	case CONTROLX('2'):	PickBuffer(1);  break;
    case K3:	case CONTROLX('3'):	PickBuffer(2);  break;
    case K4:	case CONTROLX('4'):	PickBuffer(3);  break;
    case K5:	case CONTROLX('5'):	PickBuffer(4);  break;
    case K6:	case CONTROLX('6'):	PickBuffer(5);  break;
    case K7:	case CONTROLX('7'):	PickBuffer(6);  break;
    case K8:	case CONTROLX('8'):	PickBuffer(7);  break;
    case K9:	case CONTROLX('9'):	PickBuffer(8);  break;


/************************  Debugging Keys  *************************/

    case CONTROLX('s'):	/* manually run the scavenger */
	Scavenge(curmark.chunk);
	break;

    case ESCAPE('\n'): /* force a CR and flush of stdout */
	putchar('\n');
	Flush(stdout);
	break;

    case ESCAPE('0'):	/* dynamic control of debug */
	NewMsg("debug> ");  n = Getline(linebuf,72);
	sscanf(linebuf,"%x",&debug);
	printf("debug is %x\n",debug);
	Flush(stdout);
	break;

    case ESCAPE('1'):	/* dump cursor data */
	printf("cursor: chunk=%x  cp=%x  row=%d  col=%d  ch=%c,  wishcol=%d\n",
		curmark.chunk,curmark.cp,currow,curcol,*curmark.cp,wishcol);
	Flush(stdout);
	break;

    case ESCAPE('2'):	/* contents of the current chunk */
	putchar('\n');
	for (cp = curmark.chunk->text; cp < Chunkend(curmark.chunk); cp++)
		putchar(*cp);
	putchar(11);	/* control-K, a vertical bar */
	putchar('\n');
	Flush(stdout);
	break;

    case ESCAPE('3'):	/* dump the Marklist */
	putchar('\n');
	for (marklp = Marklist; marklp; marklp = marklp->next)
	    printf("<chunk %x, cp %x>  ",marklp->pmark->chunk,
		marklp->pmark->cp);
	putchar('\n');  Flush(stdout);
	break;

    case ESCAPE('4'):
	printf("\n");
	DumpChunks(headmark.chunk);
	break;

    case ESCAPE('5'):
	SixRows();
	break;

    case ESCAPE('6'):
	LastRows();
	break;

    case ESCAPE('7'):    /* chunks and contents of killbuffer */
	printf("killbuffer:\n");
	DumpChunks(killbuffer);
	for (chunk = killbuffer; chunk; chunk = chunk->next)
	  for (cp = chunk->text; cp < Chunkend(chunk); cp++)
		putchar(*cp);
	Flush(stdout);
	break;

    case ESCAPE('8'):	/* cause a SplitChunk at cursor */
	if (curmark.cp == curmark.chunk->text)
		NewMsg("At chunk start, can't split.");
	else if (curmark.cp == Chunkend(curmark.chunk))
		NewMsg("At chunk end, can't split.");
	else {
	    SplitChunk(curmark.chunk,curmark.cp);
	    NewMsg("chunk split");}
	break;

    case ESCAPE('9'):		/* cause an exception on purpose */
	chunk = NULL;
	chunk = chunk->prev;  /* BOOM! */
	break;

    case ESCAPE('-'):		/* display major Marks */
	printf("headmark = (%x, %x)  endmark = (%x, %x)  regionmark = (%x, %x)\n",
		headmark.chunk, headmark.cp, endmark.chunk, endmark.cp,
		regionmark.chunk, regionmark.cp);
	Flush(stdout);
	break;

    default:
	sprintf(linebuf,"Undefined key %c (%o)",cmd,cmd);
	NewMsg(linebuf);
	Beep();
    }  /* end switch(cmd) */

  oldcmd = cmd;
  return(0);  /* normal termination: don't quit */
  } /* end KeyAction() */
