/*
 *  raise.c
 *
 *  This file contains the routines necessary to perform the 'raise'
 *  operation, which will raise a specified object to the top of the
 *  display.
 *
 *  David Kaelbling, May 1983
 */
 
 
/* Includes */
# ifdef VAX
# include "stdio.h"
# else
# include "Vio.h"
# endif
# include "Vgts.h"
# include "splines.h"
# include "draw.h"
 
 
/* Imports */
extern RaiseObject();
extern Checkpoint();
extern short SelectObject();
 
 
/* Exports */
extern ActRaise();
 
 
/* Local Definitions */

/*
 *  This routine is the main driver for the raise command.  It will
 *  call SelectObject() to get the user to pick an object to be raised.
 *  Using CAlmostDone to confirm will permit multiple objects to be
 *  raised, in the order specified.
 */
 
ActRaise( cmd )
	enum MenuOptions cmd;
  {
    short selected, p1, p2, raising;
    ITEM_LIST_PTR *victim;
    
    /* Make ready */
    Checkpoint();
    raising = 1;
    p1 = 0;  p2 = -1;
    
    /* Loop, doing the work. */
    while (raising)
      {
	raising = SelectObject( &victim, cmd, &p1, &p2,
		"RAISE:  Select an object type.", &selected, 0,
		0, NULL );
	cmd = CNull;
	
	/* Did the user Abort? */
	if (selected == 2)
	  {
	    raising = 0;
	    break;
	  }
	
	/* Something was selected. */
	if (selected)
	  {
	    /* Everything was selected.  Do nothing. */
	    printf("Raising everything has no effect.\n");
	  }
	else if (victim)
	  {
	    /* Raise one object */
	    RaiseObject( victim, 1 );
	  }
      }
  }
