/*
 *  perm.c
 *
 *  This file contains the code the deal with the permanent menu commands.
 *  The only permanent menu commands which stand on their own are the
 *  Miscellaneous commands and the Help command.
 *
 *  David Kaelbling, May 1983
 */
 
 
/* Includes */
# ifdef VAX
# include "stdio.h"
# else
# include "Vio.h"
# endif
# include "Vgts.h"
# include "splines.h"
# include "draw.h"
 
 
/* Imports */
extern Quit();
extern DebugObjectList();
extern GetMisc();
extern char *GetString();
extern RedrawActivelist();
extern EraseObject();
extern Checkpoint();
extern CopyObject();
extern MoveObject();
extern NewObject();
extern NewGroup();
 
 
/* Exports */
extern PermMisc();
extern PermHelp();
extern PermExit();
 
 
/* Local Definitions */
# define tolower(c)	(((c >= 'A') && (c <= 'Z')) ? (c - 'A' + 'a') : c)
# ifdef VAX
# define File FILE		/* Make files work on both machines */
# endif

/*
 *  This internal routine is a helper process for WriteFile().  This
 *  routine will scan the activelist, and print the description of
 *  each object the first time it is encountered.
 */
 
ScanWrite( fp, ptr, cnt )
	File *fp;
	ITEM_DESCRIPTOR *ptr;
	short *cnt;
  {
    short i;
    ITEM_LIST_PTR *p;
    SPLINE *sptr;
    POINT *pptr;
    
    /* Stop when we run out of data. */
    if (ptr == NULL)
	return;
    
    if (ptr->filnum == 0)
      {	
	/* Print new items, numbering them as we go. */
	ptr->filnum = ++(*cnt);
	fprintf( fp, "%d\n", ptr->filnum );
	fprintf( fp, "%d %d %d %d %d %d %d %d\n",
		ptr->type, ptr->subtype, ptr->typedata,
		ptr->xmin, ptr->xmax, ptr->ymin, ptr->ymax, ptr->base );
	switch (ptr->type)
	  {
	    case TextObj:
	        /* Text.  Print the text string. */
		for (i = 0; i <= MAXLEN; i++)
		    putc( ptr->data[i], fp );
		fprintf( fp, "\n" );
		break;
	    
	    case GroupObj:
	        /* Groups.  Print the group name, and its items. */
		for (i = 0; i <= MAXLEN; i++)
		    putc( ptr->name[i], fp );
		fprintf( fp, "\n" );
		p = (ITEM_LIST_PTR *) ptr->data;
		while (p)
		  {
		    fprintf( fp, "%d %d ", p->dx, p->dy );
		    ScanWrite( fp, p->itemdesc, cnt );
		    p = p->next;
		  }
		fprintf( fp, "-1 -1 -1\n" );
		break;
	    
	    default:
	        /* Splines.  Print the spline data. */
		sptr = (SPLINE *) ptr->data;
		fprintf( fp, "%d %d %d %d %d %d %d %d\n",
			sptr->order, sptr->numvert, sptr->nib, sptr->border,
			sptr->closed, sptr->filled, sptr->opaque, sptr->pat );
		pptr = &(sptr->head);
		for (i = 0; i < sptr->numvert; i++)
		    fprintf( fp, "    %d %d\n", pptr[i].x, pptr[i].y );
		break;
	  }
      }
    else
	fprintf( fp, "%d\n", ptr->filnum );
  }

/*
 *  This internal routine will write the activelist into a file.
 */
 
WriteFile()
  {
    short count;		/* Reachable item count */
    char *fname;
    File *fp, *fopen();
    ITEM_DESCRIPTOR *id;
    ITEM_LIST_PTR *p;
    
    /* Discard ridiculous cases */
    if ((activelist->prev == NULL) || (itemlist == NULL))
      {
	printf("There is no point to writing an empty file.\n\r");
	return;
      }
    
    /* Get the file */
    printf("Output file name?  ");
    if ((fname = GetString()) == NULL)
      {
	printf("Write File Aborted.\n\r");
	return;
      }
    if ((fp = fopen( fname, "w" )) == NULL)
      {
	printf("Error:  Couldn't open file '%s'.\n\r", fname);
	printf("Write File Aborted.\n\r");
	free( fname );
	return;
      }
    printf("Writing file '%s', please wait .", fname );
    fputs( FILEHEADER, fp );
    
    /* We have a file to write.  Reset all of the file numbers. */
    if (Debug)
	printf("Resetting file numbers in itemlist.\n\r");
    id = itemlist;
    while (id)
      {
	id->filnum = 0;
	id = id->prev;
      }
    
    /* Scan and print all of the items referenced by the activelist. */
    printf(".");
    if (Debug)
	printf("Doing real work.\n\r");
    count = 0;
    for ( p = activelist->prev; p; p = p->next )
      {
	fprintf( fp, "%d %d ", p->dx, p->dy );
	ScanWrite( fp, p->itemdesc, &count );
      }
    fprintf( fp, "-1 -1 -1\n" );
    
    /* Close the file and finish up. */
    fclose( fp );
    free( fname );
    printf(". done.\n\r");
    modified = 0;
  }

/*
 *  This internal routine is a helper process for ReadFile().
 */
 
ScanRead( dx, dy, count, filtrans, transcnt, fp )
	short dx, dy, count;
	ITEM_LIST_PTR *filtrans[];
	short *transcnt;
	File *fp;
  {
    enum ObjTypes type;
    short subtype, typedata, xmin, xmax, ymin, ymax, base;
    char *data, *name;
    unsigned short order, numvert, border, closed, filled, opaque;
    enum Nib nib;
    enum Pattern pat;
    short i;
    short cnt, newdx, newdy;
    ITEM_LIST_PTR *ptr, *gptr;
    SPLINE *sptr;
    POINT *pptr;
    
    /* Have we already done this item? */
    if (filtrans[count-1])
      {
	CurrentObject = filtrans[count-1];
	return;
      }
    
    /* Read in the basic data. */
    fscanf( fp, "%d %hd %hd %hd %hd %hd %hd %hd ",
	&type, &subtype, &typedata,
	&xmin, &xmax, &ymin, &ymax, &base );
    switch (type)
      {
	case TextObj:
	    /* Text.  Read the string. */
	    if ((data = (char *) malloc( MAXLEN+1 )) == NULL)
	      {
		printf("\n\rOut of memory.  Can't read a text string.\n\r");
		return;
	      }
	    fscanf( fp, "%1s", &(data[0]) );
	    for (i = 1; i <= MAXLEN; i++)
	        data[i] = getc( fp );
	    NewObject( data, type, subtype, typedata, xmin, xmax,
		    ymin, ymax, base, NULL, Debug, dx, dy );
	    break;
	
	case GroupObj:
	    /* Groups.  Read the group name. */
	    if ((name = (char *) malloc( MAXLEN+1 )) == NULL)
	      {
		printf("\n\rOut of memory.  Can't read a group name.\n\r");
		return;
	      }
	    fscanf( fp, "%1s", &(name[0]) );
	    for (i = 1; i <= MAXLEN; i++)
	        name[i] = getc( fp );
	    
	    /* Read all of the items, and then build the group. */
	    if ((gptr = (ITEM_LIST_PTR *)
		malloc( sizeof(ITEM_LIST_PTR) )) == NULL)
	      {
		printf("\n\rOut of memory.  Can't read a group.\n\r");
		return;
	      }
	    gptr->prev = gptr->next = NULL;
	    fscanf( fp, "%hd %hd %hd ", &newdx, &newdy, &cnt );
	    while( cnt != -1 )
	      {
		ScanRead( newdx, newdy, cnt, filtrans, transcnt, fp );
		if ((ptr = (ITEM_LIST_PTR *)
		    malloc( sizeof(ITEM_LIST_PTR) )) == NULL)
		  {
		    printf("\n\rOut of memory.  Can't read a group.\n\r");
		    return;
		  }
		if (gptr->next)
		    gptr->next->next = ptr;
		else
		    gptr->prev = ptr;
		ptr->flag = 0;
		ptr->call = 0;
		ptr->next = NULL;
		ptr->prev = gptr->next;
		ptr->dx = newdx;
		ptr->dy = newdy;
		ptr->itemdesc = CurrentObject->itemdesc;
		gptr->next = ptr;
		fscanf( fp, "%hd %hd %hd ", &newdx, &newdy, &cnt );
	      }
	    RedrawActivelist( 0 );
	    NewObject( gptr->prev, type, subtype, typedata, xmin, xmax,
		    ymin, ymax, base, name, Debug, dx, dy );
	    NewGroup( CurrentObject, (typedata == 0), 0 );
	    break;
	
	default:
	    /* Splines.  Read the data points. */
	    fscanf( fp, "%hd %hd %d %hd %hd %hd %hd %d",
		&order, &numvert, &nib, &border,
		&closed, &filled, &opaque, &pat );
	    if ((sptr = (SPLINE *) malloc( sizeof(SPLINE) +
		(numvert - 1) * sizeof(POINT) )) == NULL)
	      {
		printf("\n\rOut of memory.  Can't read a spline.\n\r");
		return;
	      }
	    sptr->order = order;
	    sptr->numvert = numvert;
	    sptr->nib = nib;
	    sptr->border = border;
	    sptr->closed = closed;
	    sptr->filled = filled;
	    sptr->opaque = opaque;
	    sptr->pat = pat;
	    pptr = &(sptr->head);
	    for (i = 0; i < numvert; i++)
		fscanf( fp, "    %hd %hd ", &(pptr[i].x), &(pptr[i].y) );
	    NewObject( sptr, type, subtype, typedata, xmin, xmax,
		ymin, ymax, base, NULL, Debug, dx, dy );
	    break;
      }
    
    /* We have created a new object.  Cache its pointer. */
    if (count >= *transcnt)
      {
	*transcnt += 100;
	if ((filtrans = (ITEM_LIST_PTR **)
	    realloc( filtrans, sizeof(ITEM_LIST_PTR) * (*transcnt) )) == NULL)
	  {
	    printf("\n\rOut of memory.  Can't expand cache table.\n\r");
	    return;
	  }
	for (i = (*transcnt) - 100; i < (*transcnt); i++)
	    filtrans[i] = NULL;
      }
    filtrans[count-1] = CurrentObject;
  }

/*
 *  This internal routine will read a file, appending it to the activelist.
 */
 
ReadFile()
  {
    char *fname;
    File *fp, *fopen();
    ITEM_LIST_PTR **filtrans;
    short count, transcnt;
    short dx, dy;
    
    /* Get the file pointer */
    printf("Input file name?  ");
    if ((fname = GetString()) == NULL)
      {
	printf("Read File Aborted.\n\r");
	return;
      }
    if ((fp = fopen( fname, "r" )) == NULL)
      {
	printf("Error:  Couldn't open file '%s'.\n\r", fname);
	printf("Read File Aborted.\n\r");
	free( fname );
	return;
      }
    printf("Reading file '%s', please wait .", fname);
    
    /* Check the file header. */
    fgets( fname, MAXLEN, fp );
    if (strcmp( fname, FILEHEADER ))
      {
	printf("\n\rFile not in current SUN Draw format.\n\r");
	free( fname );
	fclose( fp );
	return;
      }
    
    /* Allocate the filnum to pointer translation buffer. */
    printf(".");
    transcnt = 100;
    if ((filtrans = (ITEM_LIST_PTR **)
	calloc( transcnt, sizeof(ITEM_LIST_PTR *) )) == NULL)
      {
	printf("\n\rOut of memory.  Can't read a file.\n\r");
	free( fname );
	fclose( fp );
	return;
      }
    
    /* Read and load all of the referenced items */
    printf(".");
    fscanf( fp, "%hd %hd %hd ", &dx, &dy, &count );
    while( count != -1 )
      {
	ScanRead( dx, dy, count, filtrans, &transcnt, fp );
	fscanf( fp, "%hd %hd %hd ", &dx, &dy, &count );
      }
    
    /* Update the display */
    RedrawActivelist( 0 );
    DisplayItem( sdf, mainSymbol, mainVgt );
    free( fname );
    fclose( fp );
    printf(". done.\n\r");
  }

/*
 *  This internal routine will fail to generate a press file.
 */
 
PressFile()
  {
    printf("Sorry, press files are currently unimpletmented.\n\r");
    printf("You can obtain hardcopy of bitmaps of the screen\n\r");
    printf("by using the 'bits' and 'bitpress' programs.\n\r");
    printf("Detailed instructions are given in the SUN Draw\n\r");
    printf("Internals and Implementation Guide, under\n\r");
    printf("Future Extensions.\n\r");
  }

/*
 *  This routine will deal with the miscellaneous menu.
 */
 
PermMisc()
  {
    short i;
    register ITEM_LIST_PTR *p, *q;
    
    GetMisc( &i );
    switch (i)
      {
	case 0:
	    /* Clear the screen.  Erase everything. */
	    if (CurrentCmd != CMisc)
	      {
		printf("You cannot clear the screen while another command");
		printf(" is in progress.\n\r");
		break;
	      }
	    Checkpoint();
	    p = activelist->prev;
	    while (p)
	      {
	        q = p->next;
		EraseObject( p, 0 );
		p = q;
	      }
	    DisplayItem( sdf, mainSymbol, mainVgt );
	    modified = 0;
	    CurrentObject = NULL;
	    break;
	    
	case 1:
	    WriteFile();
	    break;
	
	case 2:
	    ReadFile();
	    break;
	
	case 3:
	    PressFile();
	    break;
	
	case 4:
	    if (Debug)
	      {
		Debug = 0;
		printf("Exit Debug mode.\n\r");
	      }
	    else
	      {
		Debug = 1;
		printf("Enter Debug mode.\n\r");
		printf("    sdf = %d, menuVgt = %d, mainVgt = %d,\n\r",
			sdf, menuVgt, mainVgt );
		printf("    item = %d, menuSymbol = %d, mainSymbol = %d.\n\r",
			item, menuSymbol, mainSymbol );
		printf("\n\r");
		DebugObjectList( "active list", activelist, 4 );
	      }
	    break;
      }
  }

/*
 *  This routine will provide all of the help facilities.
 */
 
PermHelp()
  {
    short helping;
    short x, y, but;
    enum MenuOptions cmd;
    
    /* Determine topic */
    cmd = CNull;
    helping = 1;
    while (helping)
      {
	printf("\fHELP:  Select a specific command, or Help to exit.\n\r\n\r");
	switch (cmd)
	  {
	    case CNull:
		printf("You are inside the help facility.\n\r");
		printf("To return to the regular program, hit Help again.\n\r");
		printf("For help on a specific command, hit that command.\n\r");
		printf("For help with the mouse buttons, push the right\n\r");
		printf("button while inside the drawing area.\n\r");
		printf("For even more help, see the User's manual.\n\r");
		break;
	    
	    case CRotate:
	        printf("The rotate command lets you rotate objects about\n\r");
		printf("a specific point.  You need to select the object,\n\r");
		printf("the point to rotate about, and two points which\n\r");
		printf("define the angle of rotation.  Rotating Text only\n\r");
		printf("moves it.  It doesn't rotate individual letters.\n\r");
		break;
		
	    case CScale:
		printf("Expand or contract objects about a point.\n\r");
		printf("Select the object, the fixed point, and a pair of\n\r");
		printf("points which define the stretch factor.\n\r");
		break;
	    
	    case CMove:
	        printf("Move an object about.  Select the object, and two\n\r");
		printf("points which define the distance to move it.\n\r");
		break;
	    
	    case CCopy:
		printf("Copy an object. Select the object, and two points\n\r");
		printf("which move the copy off of the original.\n\r");
		break;
	    
	    case CDraw:
		printf("The draw command is used to create new objects.\n\r");
		printf("If you ever select an object type without first\n\r");
		printf("selecting a command, the program assumes you wish\n\r");
		printf("to draw an object of that type.\n\r");
		break;
		
	    case CAlter:
	        printf("Modify an existing object.  This lets you change\n\r");
		printf("the fill pattern of filled object, the shape of\n\r");
		printf("objects, the nib used to draw them, etc.\n\r");
		break;
		
	    case CErase:
	        printf("Erase (delete) an existing object.  By using\n\r");
		printf("undo, you can get back a recently deleted object.\n\r");
		break;
		
	    case CLower:
	        printf("Lower puts an object behind all of the others.\n\r");
		printf("If you are using opaque ink, this is useful.\n\r");
		break;
		
	    case CRaise:
	        printf("Raise puts an object in front of all the others.\n\r");
		printf("If you are using opaque ink, this is useful.\n\r");
		break;
	    
	    case CAllObj:
	        printf("When possible, this means select all of the\n\r");
		printf("objects at once. Useful for moving, copying, etc.\n\r");
		break;
	    
	    case CText:
	        printf("Text objects are strings of characters.  The font\n\r");
		printf("used to display the text does not change this.\n\r");
		break;
		
	    case COpenCurve:
		printf("A curve which does not close automatically.\n\r");
		break;
		
	    case CClosedCurve:
	        printf("A curve which automatically closes itself.\n\r");
		break;
	
	    case CCurrentObj:
		printf("Usually this means select the current object.\n\r");
		printf("When drawing new objects, this means create an\n\r");
		printf("object of the same type as the current one.\n\r");
		break;
	
	    case COpenPolygon:
		printf("A bunch of connected straight lines.\n\r");
		break;
	
	    case CClosedPolygon:
		printf("A closed polygon.  When drawing one, you need\n\r");
		printf("only give the corners of the object.\n\r");
		break;
	
	    case CGroup:
		printf("A group of objects is several objects taken\n\r");
		printf("together as a unit.  All groups have names,\n\r");
		printf("which are used to identify them.\n\r");
		break;
	
	    case CTemplate:
		printf("Templates are standard shapes.  Arrowheads (both\n\r");
		printf("open and closed, wide and narrow), Rectangles,\n\r");
		printf("Ovals, and Circles are supported.\n\r");
		break;
	
	    case CDone:
		printf("Done is used to confirm your choices.  It will\n\r");
		printf("cause the current command to be executed, and\n\r");
		printf("finished.  If you wish to execute the current\n\r");
		printf("command, then keep executing it, use the left\n\r");
		printf("two mouse keys to signal 'Almost Done'.\n\r");
		break;
	    
	    case CAbort:
		printf("Abort will stop the current command, making\n\r");
		printf("things look like they did before you started it.\n\r");
		break;
	
	    case CUndo:
		printf("Undo will attempt to reverse the effects of the\n\r");
		printf("last selection you made.  If you hit 'Undo' when\n\r");
		printf("no command is in progress, the last command you\n\r");
		printf("did will be reveresed.  If you undo a command by\n\r");
		printf("mistake, hit undo %d more times.\n\r", NUMBACKUP - 1);
		printf("If you use undo during the middle of a command,\n\r");
		printf("it will undo your previous selection.\n\r");
		break;
	
	    case CMisc:
		printf("This contains all of the miscellaneous commands:\n\r");
		printf("for reading and writing files, for clearing the\n\r");
		printf("screen, etc.\n\r");
		break;
	
	    case CHelp:
		helping = 0;
		break;
	
	    case CExit:
		printf("The exit command will exit the program.\n\r");
		printf("It does not automatically save your work, but it\n\r");
		printf("will ask you if you really want to exit with\n\r");
		printf("unsaved changes.\n\r");
		break;
	
	    case CNib:
		printf("The nib command lets you change the default nib,\n\r");
		printf("which is used when creating new objects.  Nibs\n\r");
		printf("come in four shapes and sizes.  The shapes are\n\r");
		printf("circular, square, a horizontal dash, and a\n\r");
		printf("vertical bar.  Size 0 is a single dot.\n\r");
		break;
		
	    case CPattern:
		printf("That command lets you change the fill defaults.\n\r");
		printf("You can select opaque or transparent ink, or one\n\r");
		printf("of a number of fill patterns.  The 'Fill on/off'\n\r");
		printf("command controls whether new closed objects\n\r");
		printf("are filled or not.\n\r");
		break;
	
	    case CFilling:
		printf("That command toggles whether or not new closed\n\r");
		printf("objects are filled.\n\r");
		break;
		
	    case CTextDefault:
		printf("That command controls how new text is positioned\n\r");
		printf("(by the bottom left, center, or right), and which\n\r");
		printf("font it is in.\n\r");
		break;
	
	    case CDataPoint:
		printf("Pressing mouse buttons in the drawing area can\n\r");
		printf("have many effects, depending on the buttons used.\n\r");
		printf("The buttons work as follows:\n\r");
		printf("  x - -: Data point right here.\n\r");
		printf("  - x -: Find the nearest sticky point.\n\r");
		printf("  - - x: Data point at nearest grid intersection.\n\r");
		printf("  x x -: Almost Done.  (Try it for more info.)\n\r");
		printf("  x - x: Checkpoint.  (Try it for more info.)\n\r");
		printf("  - x x: Undo.  (Try it for more info.)\n\r");
		printf("  x x x: Abort.  (Try it for more info.)\n\r");
		printf("The mouse is currently pointing at (%d, %d)\n\r",
			x, y);
		break;
	
	    case CCheckPoint:
		printf("Create a checkpoint.  Normally, a checkpoint is\n\r");
		printf("made before each command, but if you are using\n\r");
		printf("'Almost Done' to run several commands together,\n\r");
		printf("you may want to use this command for safety.\n\r");
		break;
	
	    case CAlmostDone:
		printf("The Almost Done command is similar to the Done\n\r");
		printf("command, except that you are still executing the\n\r");
		printf("same command after you use it.  Done will finish\n\r");
		printf("the command entirely.\n\r");
		break;
		
	    default:
		printf("Internal Error:  Bad command to Help (%d).\n\r", cmd);
		break;
	  }
	
	/* Update state. */
	if (helping)
	  {
	    printf("\n\r\n\r");
	    GetInput( &cmd, &x, &y, &but );
	  }
	else
	    printf("Exiting the Help Facility.\n\r\n\r");
      }
  }

/*
 *  This function will perform the 'exit' command.
 */
 
PermExit()
  {
    char c;
    
    /* Don't exit in the middle of things. */
    if (CurrentCmd != CExit)
      {
	printf("You can't exit when other commands are in progress.\n\r");
	return;
      }
    
    /* If unsaved changes exist, confirm exit. */
    if (modified)
      {
        do
	  {
	    printf("\n\rThere are unsaved changes.\n\r");
	    printf("Do you really want to Exit? ");
	    fflush( stdout );
	    scanf("%c", &c );
	  }
	while (((c = tolower(c)) != 'y') && (c != 'n') && (c != 't'));
	if (c == 'n')
	  {
	    printf("\n\rAborted.\n\r");
	    return;
	  }
      }
    printf("\n\r");
    Quit();
  }
