/*
 *  init.c
 *
 *  This file contains the routines used to initialize the screen, windows,
 *  and internal data structures.  The only external entry point is
 *  Initialize().
 *
 *  David Kaelbling, April 1983
 */
 
/* Includes */
# ifdef VAX
# include "stdio.h"
# else
# include "Vio.h"
# endif
# include "Vgts.h"
# include "splines.h"
# include "draw.h"
    
    
/* Imports */
extern Highlight();
    
    
/* Exports */
extern Initialize();
short Debug;
short item;
short sdf;
short mainSymbol;
short menuSymbol;
short mainVgt;
short menuVgt;
short modified;
enum Nib DefaultNib;
enum Pattern DefaultPat;
short DefaultOpaque;
short DefaultFilling;
short DefaultCentering;
short DefaultFont;
enum MenuOptions CurrentCmd;
ITEM_LIST_PTR *CurrentObject;
ITEM_LIST_PTR *activelist, *backuplists[NUMBACKUP];
ITEM_DESCRIPTOR *itemlist;
short NumBackup, CurrentBackup;
extern FONTDATA FontData[];    
ITEM_LIST_PTR *Groups[MAXGROUP];
 
    
/* Local Definitions */
# define MVxmin		 420	/* Main View Left Screen Edge */
# define MVymin		  10	/* Main View Top Screen Edge */
# define MVxmax		1022	/* Main View Right Screen Edge */
# define MVymax		 790	/* Main View Bottom Screen Edge */
    
# define MLL		 160	/* Pixel length of a Menu Line */
# define AMY		   0	/* Action Menu lower left corner */
# define AMX		   0	/*   in world coordinates */
# define AMH		 200	/* Height of the action menu */
    
# define SMY		 -37	/* Static Menu lower left corner */
# define SMX		 325	/*   in world coordinates */
    
# define DMX		   0	/* Defaults Menu lower left corner */
# define DMY		 -31	/*   in world coordinates */
    
# define Mxmin		  10	/* Screen coordinates of the menu window */
# define Mxmax		 410
# define Mymin		  10
# define Mymax		 280

/*
 *  This internal routine will create the main drawing window, and do
 *  whatever initialization is necessary to start up the window system.
 */
  
InitScreen()
  {
    /* Initialize the Vgts and create the main view */
    if ((sdf = CreateSDF()) == -1)
      {
        printf("Couldn't create the sdf!\n\r\r");
	exit();
      }
    if ((mainSymbol = DefineSymbol( sdf, item++, "main draw symbol" ))
    	    != (item - 1))
      {
        printf("Couldn't define the main symbol!\n\r\r");
	Quit();
      }
    if (AddItem( sdf, item++, 0, 850, 0, 1100, AllEdges, SDF_OUTLINE, NULL ) 
    	    != (item - 1))
      {
        printf("Couldn't add the initial symbol!\n\r\r");
	Quit();
      }
    if (EndSymbol( sdf, mainSymbol, 0 ) != mainSymbol)
      {
	printf("Couldn't close the main symbol!\n\r\r");
	Quit();
      }
    if ((mainVgt = CreateVGT( sdf, GRAPHICS+ZOOMABLE,
	    mainSymbol, "drawing area")) == -1)
      {
	printf("Couldn't create the main Vgt!\n\r\r");
	Quit();
      }
    CreateView( mainVgt, MVxmin, MVymin, MVxmax, MVymax, 124, 180, 0, 0);
  }

/*
 *  This routine will create the menu, which consists of three sub-menus:
 *  the Action (Command/Object) Menu, the Static Menu (Exit, Help, .. Done),
 *  and the Defaults Menu, which specifies the default nib and fill pattern.
 */
 
InitMenu()
  {
    int i, y;			/* Scratch Variables */
    SPLINE *sptr;
    POINT *verts;
    
    /* Display the Action Menu */
    if ((menuSymbol = DefineSymbol( sdf, item++, "Action Menu")) != (item-1))
      {
	printf("Couldn't create menu symbol!");
	Quit();
      }
    
    /* Display all of the Commands */
    y = AMH - 20 + AMY;
    for (i = 0;  i < NumCommands;  i++)
      {
        Commands[i].itemno = AddItem( sdf, item++, AMX, MLL+AMX, y+2, y+19, 0,
				SDF_SIMPLE_TEXT, Commands[i].string );
	item++;  /* Leave room for highlighting box */
	AddItem( sdf, 0, AMX, MLL+AMX, y, 0, 0, SDF_HORIZONTAL_LINE, NULL );
	y -= 20;
      }
    
    /* Display all of the Objects */
    y = AMH - 20 + AMY;
    for (i = 0;  i < NumObjects;  i++)
      {
        Objects[i].itemno = AddItem( sdf, item++, MLL+AMX, MLL*2 + AMX,
			 y+2, y+19, 0, SDF_SIMPLE_TEXT, Objects[i].string );
	item++;  /* Leave room for highlighting box */
	AddItem( sdf, 0, MLL+AMX, MLL*2+AMX, y, 0, 0, SDF_HORIZONTAL_LINE, 0);
	y -= 20;
      }
    AddItem( sdf, 0, MLL+AMX, 0, 0, AMH-2, 0, SDF_VERTICAL_LINE, NULL );
    AddItem( sdf, 0, AMX, MLL*2 + AMX + 1, AMY - 1, AMH - 2 + AMY,
			AllEdges, SDF_OUTLINE, NULL );
    
    /* Display the Static Menu */
    y = SMY;
    for (i = 0;  i < NumStaticMenu;  i++)
      {
        StaticMenu[i].itemno = AddItem( sdf, item++, SMX+5, SMX+55,
			y+12, y+35, 0, SDF_SIMPLE_TEXT, StaticMenu[i].string);
	AddItem( sdf, 0, SMX, SMX+61, y+4, y+38, AllEdges, SDF_OUTLINE, 0 );
	item += 4;
        y += 40;
      }
    
    /* Display the Defaults Menu */
    DefaultsMenu[0].itemno = AddItem( sdf, item++, DMX+162, DMX+227,
			DMY+3, DMY+20, 0,
			SDF_SIMPLE_TEXT, DefaultsMenu[0].string );
    AddItem( sdf, 0, DMX+207, 0, DMY+3, DMY+20, 0, SDF_VERTICAL_LINE, NULL );
    AddItem( sdf, 0, DMX+227, 0, DMY+3, DMY+20, 0, SDF_VERTICAL_LINE, NULL );
    AddItem( sdf, 0, DMX+207, DMX+228, DMY+3, 0, 0, SDF_HORIZONTAL_LINE, 0 );
    AddItem( sdf, 0, DMX+207, DMX+227, DMY+20, 0, 0, SDF_HORIZONTAL_LINE, 0 );
    if ((sptr = (SPLINE *) malloc( sizeof(SPLINE) )) == NULL)
      {
	printf("Couldn't allocate nib structure pointer.\n\r\r");
	Quit();
      }
    sptr->order = 1;
    sptr->numvert = 1;
    sptr->nib = DefaultNib;
    sptr->border = 1;
    sptr->closed = 0;
    sptr->filled = 0;
    sptr->opaque = 0;
    sptr->pat = DefaultPat;
    sptr->head.x = DMX + 217;
    sptr->head.y = DMY + 12;
    DefaultsMenu[0].splineno = AddItem( sdf, item++, 0, 0,
		0, 0, 0, SDF_SPLINE, sptr );
    DefaultsMenu[0].ptr = (char *) sptr;
    AddItem( sdf, 0, DMX+158, DMX+231, DMY-1, DMY+23,
		AllEdges, SDF_OUTLINE, 0 );
    
    DefaultsMenu[1].itemno = AddItem( sdf, item++, DMX+242, DMX+315,
		DMY+3, DMY+20, 0, SDF_SIMPLE_TEXT, DefaultsMenu[1].string );
    if ((sptr = (SPLINE*) malloc( sizeof(SPLINE) + 3*sizeof(POINT) )) == NULL)
      {
	printf("Couldn't allocate fill menu structure pointer.\n\r\r");
	Quit();
      }
    sptr->order = 2;
    sptr->numvert = 4;
    sptr->nib = NibCircle0;
    sptr->border = 1;
    sptr->closed = 1;
    sptr->filled = 1;
    sptr->opaque = 1;
    sptr->pat = DefaultPat;
    verts = (POINT *) &(sptr->head);
    verts[0].x = DMX + 295;
    verts[0].y = DMY + 20;
    verts[1].x = DMX + 315;
    verts[1].y = DMY + 20;
    verts[2].x = DMX + 315;
    verts[2].y = DMY + 3;
    verts[3].x = DMX + 295;
    verts[3].y = DMY + 3;
    DefaultsMenu[1].splineno = AddItem( sdf, item++, 0, 0,
		0, 0, 0, SDF_SPLINE, sptr );
    DefaultsMenu[1].ptr = (char *) sptr;
    AddItem( sdf, 0, DMX+238, DMX+319, DMY-1, DMY+23,
		AllEdges, SDF_OUTLINE, 0 );
    
    DefaultsMenu[2].itemno = AddItem( sdf, item++, DMX+72, MLL+DMX-12,
		DMY+3, DMY+20, 0, SDF_SIMPLE_TEXT, DefaultsMenu[2].string );
    AddItem( sdf, 0, DMX+72, MLL+DMX-9, DMY-1, DMY+23,
        	AllEdges, SDF_OUTLINE, NULL );
	
    DefaultsMenu[3].itemno = AddItem( sdf, item++, DMX+1, DMX+60,
		DMY+3, DMY+20, 0, SDF_SIMPLE_TEXT, DefaultsMenu[3].string );
    AddItem( sdf, 0, DMX, DMX+65, DMY-1, DMY+23, AllEdges, SDF_OUTLINE, 0 );
    
    /* All menus created.  Display them! */
    
    /* Close the menu symbol */
    EndSymbol( sdf, menuSymbol, 0 );
    
    /* Now that the action menu symbol exists, create a VGT and view of it */
    if ((menuVgt = CreateVGT( sdf, GRAPHICS, menuSymbol, "draw menu"))
	    <= 0)
      {
	printf("Couldn't create menu VGT!\n\r\r");
	Quit();
      }
    
    /* Put headings into inverse video */
    Highlight( &(Commands[0]) );
    Highlight( &(Objects[0]) );
    
    CreateView( menuVgt, Mxmin, Mymin, Mxmax, Mymax, -7, -40, 0, 0 );
  }

/*
 *  This is the externally callable initialization routine.
 */
 
Initialize()
  {
    short i;
    
    /* Put the TTY into raw mode. */
    GetTTY();

    Debug = 0;
    sdf = 0;
    item = 1;
    menuSymbol = 0;
    mainSymbol = 0;
    menuVgt = 0;
    mainVgt = 0;
    modified = 0;
    DefaultNib = NibCircle1;
    DefaultPat = PatChainLink;
    DefaultOpaque = 0;
    DefaultFilling = 0;
    DefaultCentering = PositionCenter;
    DefaultFont = 10;		/* TimesRoman12B */
    CurrentCmd = CNull;
    CurrentObject = NULL;
    activelist = (ITEM_LIST_PTR *) malloc( sizeof(ITEM_LIST_PTR) );
    activelist->prev = NULL;
    activelist->next = NULL;
    NumBackup = NUMBACKUP;
    CurrentBackup = 0;
    for (i = NumBackup;  i--; )
      {
	backuplists[i] = (ITEM_LIST_PTR *) malloc( sizeof(ITEM_LIST_PTR) );
	backuplists[i]->prev = NULL;
	backuplists[i]->next = NULL;
      };
    itemlist = NULL;
    for (i = 0;  i < MAXGROUP;  i ++)
      {
	Groups[i] = NULL;
      }
    
    InitScreen();
    InitMenu();
  }
 
/*  Define the storage for the menu data  */
MenuData Commands[] =
  {
    "      Commands      ",	0,
    "   Rotate           ",	0,
    "   Scale            ",	0,
    "   Move             ",	0,
    "   Copy             ",	0,
    "   Draw             ",	0,
    "   Alter            ",	0,
    "   Erase            ",	0,
    "   Push to Back     ",	0,
    "   Bring to Front   ",	0,
  };
int NumCommands = sizeof(Commands) / sizeof(MenuData);
    
MenuData Objects[] =
  {
    "      Objects       ",	0,
    "   All Objects      ",	0,
    "   Text             ",	0,
    "   Open Curve       ",	0,
    "   Closed Curve     ",	0,
    "   Current Object   ",	0,
    "   Open Polygon     ",	0,
    "   Closed Polygon   ",	0,
    "   Group            ",	0,
    "   Template         ",	0,
  };
int NumObjects = sizeof(Objects) / sizeof(MenuData);
    
MenuData StaticMenu[] =
  {
    " Done ",	0,
    " Abort",	0,
    " Undo ",	0,
    " Misc ",	0,
    " Help ",	0,
    " Exit ",	0,
  };
int NumStaticMenu = sizeof(StaticMenu) / sizeof(MenuData);
    
DefMenuData DefaultsMenu[] =
  {
    "Nib:",	0, 0, NULL,
    "Fill:",	0, 0, NULL,
    " Fill off", 0, 0, " Fill on",
    "  Text ", 0, 0, NULL,
  };
int NumDefaultsMenu = sizeof(DefaultsMenu) / sizeof(DefMenuData);
    
FONTDATA FontData[] =
  {
    "Clarity12",	0, 0,
    "Cream12",		0, 0,
    "Helvetica10",	0, 0,
    "Helvetica10B",	0, 0,
    "Helvetica18",	0, 0,
    "Helvetica7",	0, 0,
    "Helvetica7B",	0, 0,
    "Helvetica7BI",	0, 0,
    "Helvetica7I",	0, 0,
    "TimesRoman12",	0, 0,
    "TimesRoman12B",	0, 0,
    "TimesRoman12I",	0, 0,
    "APL14",		0, 0,
    "Ascii12",		0, 0,
    "cmr12",		0, 0,
    "Cyrillic12",	0, 0,
    "Gates32",		0, 0,
    "Greek12",		0, 0,
    "Hebrew12",		0, 0,
    "Math12",		0, 0,
    "OldEnglish18",	0, 0,
    "Template64",	0, 0,
  };
