# define MAXCLICK	   10	/* Max. number of UnGetInput's allowed. */
# define NUMBACKUP	   10	/* Number of undo backup lists to maintain */
# define MAXLEN		  120	/* Maximum string length */
# define MAXGROUP	   13	/* Max. number of groups allowed */
# define MAXDIST	10000	/* Max. distance from an item */
# define FILEHEADER	"(* SUN Draw program data file *)\n"

# define PositionRight	    0	/* Position Text by lower right corner. */
# define PositionCenter	    1	/* Position Text by center of bottom edge. */
# define PositionLeft	    2	/* Position Text by lower left corner. */

enum ObjTypes
  {
    TextObj,			/* Text of an arbitrary font. */
    OpenSplineObj,		/* Open spline (curve). */
    ClosedSplineObj,		/* Closed spline. */
    OpenPolygonObj,		/* Open polygon (spline of order 2) */
    ClosedPolygonObj,		/* Closed polygon. */
    GroupObj,			/* Collection of other objects. */
    TemplateObj,		/* Standard shape. */
  };
   
enum TemplateTypes
  {
    NarArrowO,			/* Narrow Open Arrowhead. */
    NarArrowC,			/* Narrow Closed Arrowhead. */
    WideArrowO,			/* Wide Open Arrowhead. */
    WideArrowC,			/* Wide Closed Arrowhead. */
    Oval,			/* An oval. */
    Circle,			/* A circle */
    Rectangle,			/* A rectangle */
    NullTemplate,		/* Nothing. */
  };

typedef struct
  {
    char	*fontname;	/* Font name (eg, TimesRoman12B) */
    short	refnumber;	/* Vgts font identification number */
    short	loaded;		/* Font has been defined? */
  } FONTDATA;

/*
 * All objects are kept in a central objects list, called the
 * itemlist.  Objects are stored in the format below.  The data
 * field points to a set of ITEM_LIST_PTRs for groups, which defines
 * the members of the group and gives their relative displacements.
 * For text data is the actual character string.
 */
typedef struct ItemDescriptor
  {
    char			*data;		/* Generic data pointer */
    struct ItemDescriptor	*prev, *next;	/* Links within itemlist */
    enum ObjTypes		type;		/* Object type */
    short			subtype;	/* Template type, font num */
    short			typedata;	/* Centering style, copy # */
    short			number;		/* Vgts item number */
    short			symbol;		/* Vgts symbol number. */
    short			refs;		/* Reference count. */
    short			xmin, xmax, ymin, ymax;	/* Bounding box */
    short			base;		/* Text baseline. */
    char			*name;		/* Group Name */
    short			filnum;		/* Misc. for file i/o */
  }  ITEM_DESCRIPTOR;

/*
 * All of the objects currently being displayed are pointed to by
 * an entry in the activelist.  Each entry has the format below.  The
 * undo logs consist of old copies of the activelist.
 */
typedef struct ItemListPtrBlock
  {
    ITEM_DESCRIPTOR		*itemdesc;	/* itemlist entry */
    short			dx, dy;		/* relative offset */
    short			flag;		/* miscellaneous */
    short			call;		/* number of symbol call */
    struct ItemListPtrBlock	*prev, *next;
  }  ITEM_LIST_PTR;

/*
 * The SelectObject() routine can prompt the user for a variable number
 * of data points.  The storage for these points, along with the specific
 * prompt for each point, is kept in arrays with each entry of the type
 * described below.
 */
typedef struct
  {
    char 	*prompt;
    short	x, y;
    short	flag;
  }  POINT_DATA;

/*
 * The menu data structures are of the type below.
 */
typedef struct
  {
    char	*string;
    short	itemno, splineno;
    char	*ptr;			/*  Either second string or spline */
  }  DefMenuData;

typedef struct
  {
    char	*string;
    short	itemno;
  }  MenuData;
    
extern int NumCommands;		/* Number of entries in the Commands menu */
extern int NumObjects;		/* Number of entries in the Objects menu */
extern int NumStaticMenu;	/* Number of entries in the Static menu */
extern int NumDefaultsMenu;	/* Number of default-setting menu entries. */
extern MenuData Commands[];	/* Commands menu data. */
extern MenuData Objects[];	/* Objects menu data. */
extern MenuData StaticMenu[];	/* Static (permanent) menu data. */
extern DefMenuData DefaultsMenu[];	/* Defaults menu data. */
extern ITEM_LIST_PTR *Groups[MAXGROUP];	/* Group menu data. */
    
extern short Debug;			/* Print Debugging information? */
extern short item;			/* Vgts unique item number counter */
extern short sdf;			/* Vgts structured display file no. */
extern short menuSymbol;		/* Vgts menu symbol number */
extern short mainSymbol;		/* Vgts drawing area symbol number */
extern short menuVgt;			/* Vgts menu Virtual Graphics Term. */
extern short mainVgt;			/* Vgts drawing area VGT */
extern enum Nib DefaultNib;		/* Default Nib for line drawing. */
extern enum Pattern DefaultPat;		/* Default fill pattern */
extern short DefaultOpaque;		/* Use solid fill patterns? */
extern short DefaultFilling;		/* Fill closed objects? */
extern short DefaultCentering;		/* Text Positioning method */
extern short DefaultFont;		/* Default Font for text. */
extern enum MenuOptions CurrentCmd;	/* Current command. */
extern ITEM_LIST_PTR *CurrentObject;	/* Current object in activelist. */
extern short modified;			/* Unwritten changes exist? */
extern ITEM_DESCRIPTOR *itemlist;	/* Central Object Descriptor list */
extern ITEM_LIST_PTR *activelist;	/* Current (active) object display */
extern short NumBackup, CurrentBackup;	/* Backup information */
extern ITEM_LIST_PTR *backuplists[];	/* Backup information */
extern FONTDATA FontData[];		/* Loaded font table */

enum MenuOptions
  {
    CNull,		/* Bad command.  User missed everything. */
    CRotate,		/* Selections from the Commands Menu */
    CScale,
    CMove,
    CCopy,
    CDraw,
    CAlter,
    CErase,
    CLower,
    CRaise,
    CAllObj,		/* Selections from the Objects menu */
    CText,
    COpenCurve,
    CClosedCurve,
    CCurrentObj,
    COpenPolygon,
    CClosedPolygon,
    CGroup,
    CTemplate,
    CDone,		/* Selections from the Static (permanent) menu */
    CAbort,
    CUndo,
    CMisc,
    CHelp,
    CExit,
    CNib,		/* Selections from the Defaults menu */
    CPattern,
    CFilling,
    CTextDefault,
    CDataPoint,		/* Commands entered through the mouse keys. */
    CCheckPoint,
    CAlmostDone,
  };
