/*
 *  copy.c
 *
 *  This file contains the routines necessary to perform the 'copy'
 *  operation, which will copy an object on the screen, and as a side
 *  effect raise it to the top of the display list.
 *
 *  David Kaelbling, May 1983
 */
 
 
/* Includes */
# ifdef VAX
# include "stdio.h"
# else
# include "Vio.h"
# endif
# include "Vgts.h"
# include "splines.h"
# include "draw.h"
 
 
/* Imports */
extern CopyObject();
extern Checkpoint();
extern RedrawActivelist();
extern short SelectObject();
 
 
/* Exports */
extern ActCopy();
 
 
/* Local Definitions */
static POINT_DATA prompts[] =
  {
    { "Enter the starting point of the copy.", 0, 0, 0, },
    { "Enter the destination of the copy.", 0, 0, 0, },
  };

/*
 *  This routine is the main driver for the copy command.  It will
 *  call SelectObject() to get the user to pick an object to be copied.
 *  Using CAlmostDone to confirm will permit multiple objects to be
 *  copied, in the order specified.
 */
 
ActCopy( cmd )
	enum MenuOptions cmd;
  {
    register short deltax, deltay;
    short selected, p1, p2, copying;
    ITEM_LIST_PTR *victim;
    register ITEM_LIST_PTR *p, *q;
    
    /* Make ready */
    Checkpoint();
    copying = 1;
    p1 = 0;  p2 = -1;
    
    /* Loop, doing the work. */
    while (copying)
      {
	copying = SelectObject( &victim, cmd, &p1, &p2,
		"COPY:  Select an object type.", &selected, 1,
		2, prompts );
	cmd = CNull;
	
	/* Did the user Abort? */
	if (selected == 2)
	  {
	    copying = 0;
	    break;
	  }
	
	/* Something was selected. */
	deltax = prompts[1].x - prompts[0].x;
	deltay = prompts[1].y - prompts[0].y;
	if (selected)
	  {
	    /* Everything was selected.  */
	    p = activelist->prev;
	    q = activelist->next;
	    while (p)
	      {
		CopyObject( p, deltax, deltay, 0 );
		if (p == q)
		    break;
		p = p->next;
	      }
	    
	    /* Redisplay Everything. */
	    RedrawActivelist( 1 );
	  }
	else if (victim)
	  {
	    /* Copy one object */
	    CopyObject( victim, deltax, deltay, 1 );
	  }
      }
  }
