/*
 * test.c - a test of the remote VGTS implementation
 * Bill Nowicki September 1982
 */

# include <Vgts.h>
# ifdef VAX
# include <stdio.h>
# else VAX
# include <Vio.h>
# endif VAX

# define Objects 100	/* number of objects */

short sdf, vgt;

Quit()
  {
    /*
     * gracefully exit.  Not too much work on Unix.
     */
     DeleteVGT(vgt,1);
     DeleteSDF(sdf);
     ResetTTY();
     exit();
  }

main()
  {
    int i;
    short item;
    long start, end;

# ifdef VAX  
     printf("Remote VGTS test program\n");
# else VAX
     printf("VGTS test program\n");
# endif VAX
     fflush(stdout);
     GetTTY();
     sdf = CreateSDF();
     DefineSymbol( sdf, 1, "test" );
     AddItem( sdf, 2, 4, 40, 4, 60, NM, SDF_FILLED_RECTANGLE, NULL );
     EndSymbol( sdf, 1, 0 );
     vgt = CreateVGT(sdf, GRAPHICS+ZOOMABLE, 1, "random objects" );
     CreateView(vgt, 4, 4, 500, 320, 0, 0, 0, 0);

     time(&start);
     for (i=12; i<Objects; i++ )
       {
         short x = Random( -2, 155);
	 short y = Random( -10, 169);
	 short top = y + Random( 6, 100 );
	 short right = x + Random( 4, 120 );
	 short layer = Random( NM, NG );

         EditSymbol(sdf, 1);
	 DeleteItem( sdf, i-10);
	 switch (Random(1, 6) )
	   {
	     case 1:
               AddItem( sdf, i, x, right, y, top, layer, 
	 		SDF_FILLED_RECTANGLE, NULL );
	       break;
	       
	     case 2:
	       AddItem( sdf, i, x, x+1000, y, y+16, 0, SDF_SIMPLE_TEXT, 
	       	"Here is some simple text" );
	       break;
	       
	     case 3:
	       	AddItem( sdf, i, x, right, y, y+1, 0, 
			SDF_HORIZONTAL_LINE, NULL );
		break;
		
	    case 4:
	       	AddItem( sdf, i, x, x+1, y, top, 0, 
			SDF_VERTICAL_LINE, NULL );
		break;

	    case 5:
	       	AddItem( sdf, i, x, right, y, top, 0, 
			SDF_GENERAL_LINE, NULL );
		break;

	    case 6:
	       	AddItem( sdf, i, x, right, top, y, 0, 
			SDF_GENERAL_LINE, NULL );
		break;
  	    }
	 EndSymbol( sdf, 1, vgt );
       }
     time(&end);
     if (end==start) end = start+1;
     printf("%d objects in %d seconds, or %d objects/second\r\n",
     	Objects, end-start, Objects/(end-start));
     printf("Done!\r\n");
     Quit();
  }

Random( first, last )
  {
  	/*
	 * generates a random number between "first" and "last" inclusive.
	 */
    int value = rand()/2;
    value %= (last - first + 1);
    value += first;
    return(value);
  }
