/*
 * silmove.c - moving options for silly
 * Bill Nowicki April 1983
 *
 */

# include "silly.h"

# include <Vgts.h>
# include <Vio.h>
# include <text.h>
 
DoMove(copyFlag)
  {
  	/*
	 * Move the selected objects.  If the copyFlag is true,
	 * we move new copies; otherwise move the originals
	 */
    struct Object *list;	
    register struct Object *ob = SelectList;
    short buttons, x, y, xstart, ystart, xoffset, yoffset, xlast, ylast;

    if (ob==NULL)
      {
        printf("You have to select something first\r\n");
	return;
      }

    printf("%s objects from ", copyFlag ? "Copy" : "Move");
    Flush(stdout);
    RedrawPad(stdout);
    while ((buttons=GetGraphicsStatus(stdin,&xstart,&ystart,NULL))<=0)
      {
        if (buttons<0 || buttons==7)
	  {
	    printf("Aborted\r\n");
	    return;
	  }
      }
    if (copyFlag)
      {
		/*
		 * here we clone the selected objects if desired
		 */
        list = NULL;
        EditSymbol(sdf,TopSymbol);	
	for (ob=SelectList;ob;ob=ob->next)
	  {
	     register struct Object *temp = GetFreeObject();
	     if (temp==NULL)
	       {
	         printf("Too many objects\r\n");
		 return;	       
	       }
	     temp->kind = ob->kind;
	     temp->fontNumber = ob->fontNumber;
	     temp->xmin = ob->xmin;
	     temp->xmax = ob->xmax;
	     temp->ymin = ob->ymin;
	     temp->ymax = ob->ymax;
             temp->selected = 0;
	     temp->next = list;
	     list = temp;
             switch (temp->kind)
               {
	  	case Line:
	    	    AddItem(sdf,temp->number,
		    	temp->xmin, temp->xmax, temp->ymin, temp->ymax, BLACK,
	    		SDF_FILLED_RECTANGLE, NULL);
	    	    break;

    		case Text:
	       	    temp->string = (char *)malloc(strlen(ob->string)+1);
		    strcpy(temp->string,ob->string);
		    AddItem(sdf,temp->number,temp->xmin, temp->xmax, 
	    		FontMap[ temp->fontNumber ] == Template64 ?
			temp->ymax : temp->ymin, 0,
	        	FontMap[ temp->fontNumber ], SDF_TEXT, temp->string);
	            break;
	      } /* switch */
	  }  /* for */
        EndSymbol(sdf,TopSymbol,vgt);
      }
    else list = SelectList;

    printf("to desired position ");
    Flush(stdout);
    RedrawPad(stdout);
    xlast = x;
    ylast = y;

    while ((buttons=GetGraphicsStatus(stdin,&x,&y,NULL)) != 0)
      {
        xoffset = x - xstart;
	yoffset = y - ystart;
	
        if (buttons<0 || buttons==7)
	  {
	    printf("Aborted\r\n");
	    return;
	  }
	 if (x==xlast && y==ylast) continue;
	 xlast = x;
	 ylast = y;
         EditSymbol(sdf,TopSymbol);
         for (ob=list;ob;ob=ob->next)
          {
	    /*
	     * translate each object by the relative distance we
	     * have moved so far
	     */
        switch (ob->kind)
          {
	  case Line:
	    ChangeItem(sdf,ob->number,ob->xmin+xoffset, ob->xmax+xoffset, 
	    	ob->ymin+yoffset, ob->ymax+yoffset, 
		copyFlag ? BLACK : GRAY,
	    	SDF_FILLED_RECTANGLE, NULL);
	    break;

	case Text:
	    ChangeItem(sdf,ob->number,ob->xmin+xoffset, ob->xmax+xoffset, 
	    		(FontMap[ ob->fontNumber ] == Template64 ?
			ob->ymax : ob->ymin) + yoffset, 0,
	        FontMap[ ob->fontNumber ], SDF_TEXT, NULL);
#ifndef INVERT
	    ChangeItem(sdf,ob->number+SelectFlag,
	    		ob->xmin+xoffset, ob->xmax+xoffset, 
	    		ob->ymin+yoffset - 4, ob->ymax+yoffset, 
	    	HILIGHT, SDF_FILLED_RECTANGLE, NULL);
#endif INVERT
	    break;
      }
	  }
        EndSymbol(sdf,TopSymbol,vgt);
     }
     for (ob=list;ob;ob=ob->next)
       {
         ob->xmin += xoffset;
	 ob->xmax += xoffset;
	 ob->ymin += yoffset;
	 ob->ymax += yoffset;
       }
     printf("moved.\r\n");
  }


DoBox()
  {
    register struct Object *ob1, *ob2, *ob3, *ob4;
    short buttons, x, y, xstart, ystart, xoffset, yoffset, xlast, ylast;

    ob1 = GetFreeObject();
    ob2 = GetFreeObject();
    ob3 = GetFreeObject();
    ob4 = GetFreeObject();
    if (ob1==NULL || ob2==NULL || ob3==NULL || ob4==NULL)
      {
        printf("Too many objects already");
	return;
      }
    ob1->kind=Line;
    ob1->fontNumber=LineFont;
    ob2->kind=Line;
    ob2->fontNumber=LineFont;
    ob3->kind=Line;
    ob3->fontNumber=LineFont;
    ob4->kind=Line;
    ob4->fontNumber=LineFont;

    printf("Select one corner of Box ");
    Flush(stdout);
    RedrawPad(stdout);
    while ((buttons=GetGraphicsStatus(stdin,&xstart,&ystart,NULL))<=0)
      {
        if (buttons<0 || buttons==7)
	  {
	    printf("Aborted\r\n");
	    return;
	  }
      }
    printf("lift up at other corner ");
    Flush(stdout);
    RedrawPad(stdout);
    xlast = x;
    ylast = y;
    EditSymbol(sdf,TopSymbol);
    AddItem(sdf,ob1->number,x, x+Width, 
    		y, y+Width, BLACK, SDF_FILLED_RECTANGLE, NULL);
    AddItem(sdf,ob2->number,x, x+Width, 
    		y, y+Width, BLACK, SDF_FILLED_RECTANGLE, NULL);
    AddItem(sdf,ob3->number,x, x+Width, 
    		y, y+Width, BLACK, SDF_FILLED_RECTANGLE, NULL);
    AddItem(sdf,ob4->number,x, x+Width, 
    		y, y+Width, BLACK, SDF_FILLED_RECTANGLE, NULL);
    EndSymbol(sdf,TopSymbol,vgt);

    while ((buttons=GetGraphicsStatus(stdin,&x,&y,NULL)) != 0)
      {
        xoffset = x - xstart;
	yoffset = y - ystart;
	
        if (buttons<0 || buttons==7)
	  {
	    printf("Aborted\r\n");
	    return;
	  }
	 if (x==xlast && y==ylast) continue;
	 xlast = x;
	 ylast = y;
         EditSymbol(sdf,TopSymbol);
	 if (x>xstart)
	   {
             ob1->xmin = xstart;
             ob1->xmax = x;
             ob2->xmin = x-(Width-1);
             ob2->xmax = x;
             ob3->xmin = xstart;
             ob3->xmax = x;
             ob4->xmin = xstart;
             ob4->xmax = xstart+(Width-1);
	   }
	 else
	   {
             ob1->xmin = x;
             ob1->xmax = xstart;
             ob2->xmin = xstart-(Width-1);
             ob2->xmax = xstart;
             ob3->xmin = x;
             ob3->xmax = xstart;
             ob4->xmin = x;
             ob4->xmax = x+(Width-1);
	   }
	 if (y>ystart)
	   {
             ob1->ymin = ystart;
             ob1->ymax = ystart+(Width-1);
             ob2->ymin = ystart;
             ob2->ymax = y;
             ob3->ymin = y-(Width-1);
             ob3->ymax = y;
             ob4->ymin = ystart;
             ob4->ymax = y;
	   }
	 else
	   {
             ob1->ymin = y;
             ob1->ymax = y+(Width-1);
             ob2->ymin = y;
             ob2->ymax = ystart;
             ob3->ymin = ystart-(Width-1);
             ob3->ymax = ystart;
             ob4->ymin = y;
             ob4->ymax = ystart;
	   }
         ChangeItem(sdf,ob1->number, ob1->xmin, ob1->xmax, 
    		ob1->ymin, ob1->ymax, BLACK, SDF_FILLED_RECTANGLE, NULL);
         ChangeItem(sdf,ob2->number, ob2->xmin, ob2->xmax, 
    		ob2->ymin, ob2->ymax, BLACK, SDF_FILLED_RECTANGLE, NULL);
         ChangeItem(sdf,ob3->number, ob3->xmin, ob3->xmax, 
    		ob3->ymin, ob3->ymax, BLACK, SDF_FILLED_RECTANGLE, NULL);
         ChangeItem(sdf,ob4->number, ob4->xmin, ob4->xmax, 
    		ob4->ymin, ob4->ymax, BLACK, SDF_FILLED_RECTANGLE, NULL);
         EndSymbol(sdf,TopSymbol,vgt);
       }
     printf("done.\r\n");
  }


DoStretch()
  {
    register struct Object *ob = SelectList;
    short buttons, x, y, xstart, ystart, xlast, ylast;
    short xanchor, yanchor, width;

    if (ob==NULL || ob->kind!=Line)
      {
        printf("You have to select a line first\r\n");
	return;
      }

    printf("Select end to stretch ");
    Flush(stdout);
    RedrawPad(stdout);
    while ((buttons=GetGraphicsStatus(stdin,&xstart,&ystart,NULL))<=0)
      {
        if (buttons<0 || buttons==7)
	  {
	    printf("Aborted\r\n");
	    return;
	  }
      }
      	/*
	 * now we need to be clever, and  find the end of the line
	 * that we are farthest away from, and how wide it is.
	 */
    if ( abs(xstart - ob->xmin) > abs(xstart - ob->xmax) )
      xanchor = ob->xmin;
    else
      xanchor = ob->xmax;
    if ( abs(ystart - ob->ymin) > abs(ystart - ob->ymax) )
      yanchor = ob->ymin;
    else
      yanchor = ob->ymax;

    if ( abs(ob->xmax - ob->xmin) < abs(ob->ymax - ob->ymin) )
      width = ob->xmax - ob->xmin;
    else
      width = ob->ymax - ob->ymin;

    printf("lift up at desired position ");
    Flush(stdout);
    RedrawPad(stdout);
    xlast = x;
    ylast = y;

    while ((buttons=GetGraphicsStatus(stdin,&x,&y,NULL)) != 0)
      {

        if (buttons<0 || buttons==7)
	  {
	    printf("Aborted\r\n");
	    return;
	  }
	 if (x==xlast && y==ylast) continue;
	 xlast = x;
	 ylast = y;
         EditSymbol(sdf,TopSymbol);
         for (ob=SelectList;ob;ob=ob->next)
          {
	    /*
	     * translate the object by the relative distance we
	     * have moved so far
	     */
	    if ( abs(x - xanchor) < abs(y - yanchor) )
	    		/* Vertical */
	    {
	      ob->xmin = xanchor;
	      ob->xmax = xanchor+width;
	      if (y<yanchor)
	        {
		  ob->ymin = y;
		  ob->ymax = yanchor;
		}
	      else
	        {
		  ob->ymin = yanchor;
		  ob->ymax = y;
		}
	      }
	    else
	    {
    		/* Horizontal */
	      ob->ymin = yanchor;
	      ob->ymax = yanchor+width;
	      if (x<xanchor)
	        {
		  ob->xmin = x;
		  ob->xmax = xanchor;
		}
	      else
	        {
		  ob->xmin = xanchor;
		  ob->xmax = x;
		}
	      }
        ChangeItem(sdf,ob->number,ob->xmin,ob->xmax,
	    		ob->ymin, ob->ymax, GRAY, SDF_FILLED_RECTANGLE, NULL);
	  }
        EndSymbol(sdf,TopSymbol,vgt);
     }
     printf("done.\r\n");
  }


