/*
 * silly.h - definitions for .sil files on the VGTS
 * Bill Nowicki Januray 1983
 */


# define Password 034562	/* normal password */
# define CoordMask 1023		/* use only ten bits for coordinates */
# define GetFont(n) (n>>12)&15	/* get font bits from ymax short */
# define YOffset 700		/* Offset from top of "Alto" screen */

# define LineFont 14		/* "font" number for lines */

# define MaxObjects 999		/* size of object table */

enum ObjectState {Empty, Used, Deleted, Special};
enum ObjectKind {Line, Text};

struct Object
  {
    /*
     * the data structure for each object
     */
    enum ObjectState state;
    enum ObjectKind kind;
    short number;
    short xmin, ymin, xmax, ymax;
    short fontNumber;
    short selected;
    char *string;
    struct Object *next;
  };


/*
 * command codes
 */

# define CommandQuit 1
# define CommandWrite 2
# define CommandDebug 3
# define CommandDraw 4
# define CommandDelete 5
# define CommandText 6
# define CommandFont 7
# define CommandChange 8
# define CommandWidth 9
# define CommandMove 10
# define CommandStretch 11
# define CommandBox 12
# define CommandCopy 13

# define TopSymbol 1		/* Item number for top symbol */
# define MarkSymbol 2		/* the symbol for mark */
# define MarkItem 3		/* instance of the mark */
# define FirstItem 4		/* first normal item (SIL object) */

# define SelectFlag	1024	/* must be greater than MaxObjects */

/*
 * VGTS Standard font codes
 */

# define Helvetica10 0
# define Helvetica10B 1
# define Helvetica10I 0
# define Helvetica10BI 0
# define Helvetica7 2
# define Helvetica7B 3
# define Helvetica7I 5
# define Helvetica7BI 6
# define Template64 4


extern struct Object *SelectList;
extern char FontMap[];
extern short sdf, vgt;
extern short Width;
extern struct Object *GetFreeObject();
