#include <Vgts.h>
#include "checkers.h"

/* Routines used to select a piece using the mouse. */



static PopUpEntry mainMenu[] =
  {
    "Redraw",			REDRAW,
    "Pass (skip turn)",		PASS,
    "Change search depth",	DEPTH,
    "Edit board",		EDIT,
    "Back up one move",		BACKUP,
    "Resign",			RESIGN,
    0, 0
  };

static PopUpEntry depthMenu[] =
  {
    "1",	1,
    "2",	2,
    "3",	3,
    "4",	4,
    "5",	5,
    "6",	6,
    "7",	7,
    "8",	8,
    0, 0
  };


int GetResponse(editFlag)
    /* Wait for the user to either select a square of the board with either
     * the left or the middle button, or select an entry from the popup menu
     * obtained by clicking the right button. In the former case, the position
     * (in Board) of the selected square is returned (or possibly, if editFlag
     * is set, the position of a selected square in the Edit mode menu).
     * In the latter case, the number of the selected menu entry is returned.
     */
  {
    extern short Sdf, Vgt, FirstSquareItem, Edit_Menu_FirstSquare;
    extern int	Index[];

    short x, y, buttons, vgt, i, j, result, boardIndex;

    /* Loop until a square is selected, or the right button is clicked and
     * something is selected from the main menu. */
    while(1)
      {
	GetMouseClick(&x, &y, &buttons, &vgt);
	if ( (buttons & RightButton) && !editFlag )
	  {
	    if ((result = popup(mainMenu)) < 0)
		continue;
	    return (result);
	  }
	i = x/SQUARE_SIZE; j = y/SQUARE_SIZE;
	if ( (i < 0) || (i > 7) || (j < 0) || (j > 7) )
	  {
	    if (!editFlag) continue;
	    if ( (x < EDIT_MENU_X) || (x > EDIT_MENU_X+SQUARE_SIZE) ||
		 (y < EDIT_MENU_Y) || (y >= EDIT_MENU_Y+7*SQUARE_SIZE) )
		continue;
	    return( Edit_Menu_FirstSquare + (y-EDIT_MENU_Y)/SQUARE_SIZE - 1 );
	  }
	if (!(boardIndex = Index[(i<<3) + (7-j)]))
	    continue;
	return (boardIndex);
/* The following code isn't used - somehow it doesn't work. */
/*	FindMousedObject(Sdf, x, y, Vgt, All, &hitList);
printf("hitList.NumOfElements = %d\n",hitList.NumOfElements);
	for ((i = hitList.NumOfElements, p = hitList.Header); i>0; --i)
{printf("p->item = %d\n",p->item);
	    if (p->item > FirstSquareItem)
		return (p->item - FirstSquareItem);*/
      }
  }


int GetDepth()
    /* Select from the "depth" menu, to change the depth of searching. If
     * the user clicks outside the menu, then the current Depth is returned.
     */
  {
    short i;
    extern int Depth;

    if ((i = popup(depthMenu)) < 0)
	return (Depth);
    return (i);
  }
