/* bits - a program for editing rasters
 * Documented in /usr/sun/help/bits.help
 * (c) Per Bothner, Sept 1983.
 */
#include <Vio.h>
#include <bitmaps.h>
#include <sfont.h>
#include <framebuf.h>
#include <rasterops.h>
#include <Vgts.h>
#include <m68000.h>
extern MemRaster *SubRaster(), *RasterOp(), *GetRaster(), *Update(),
    *ReadFontChar(), *LoadSFChar(), *AdjustEdges();
char *GetString(), *strcpy();
extern Sfont TimesRoman12;
extern MemRaster WholeFB;
int GXBase = GXDefaultBase;
GETCHAR() {int c;Flush(stdout);c=getchar();putchar(c);Flush(stdout);return c;}
MemRaster EmpRaster = {0, 0, 0, IsNullRaster};
MemRaster InvEmpRaster = {0, 0, 0, IsNullRaster+InverseRaster};
MemRaster *(RastTab[28]) = {&EmpRaster, &WholeFB, 0};
FontEntry *GetFontEntry();
char *curFontName = "TimesRoman12";
FontEntry *curFont;
char name[100]; /* temp. string buffer */
#define GXBase GXDefaultBase
MemRaster *r;
int c;
#define getint() (c = 0, Getint())
#define UniqueCopy(r) RasterOp(0,r,GXcopy)
short sdf, vgt, scale = Scale8+ScaleFramed;
#define InvertRaster '~'
#define CTRL(x) (x&0x1F)
#define ReadRaster	CTRL('R')
#define WriteRaster	CTRL('W')
#define WriteHex	CTRL('T')
#define SaveCopy	CTRL('K')
#define NewName		CTRL('N')
#define OldName		CTRL('O')
#define BitBlt		CTRL('B')
#define ReadChar	'`'
#define Experimental	CTRL('X')
static PopUpEntry Menu[] =
  {
    "Quit",			4,
    "Give name to raster",	NewName,
    "Lookup named raster",	OldName,
    "Invert",			InvertRaster,
    "Save a fresh copy",	SaveCopy,
    "Query",			'?',
    "Read raster",		ReadRaster,
    "Write raster",		WriteRaster,
    "Write hex",		WriteHex,
    "Raster operation",		BitBlt,
    "Read character from font",	ReadChar,
    "Redraw",			'\r',
    0, 0
  };
#define Xload 1
#define Xwrite 2
#define Xget 3
#define Xsave 4
#define Xoptions 5
static PopUpEntry ExperimentalMenu[] =
  {
    "Load new font from file",	Xload,
    "Write font to file",	Xwrite,
    "Get character in font",	Xget,
    "Store as character in font", Xsave,
    "Change output options",	Xoptions,
    0, 0
  };
/*enum CharStatus  {*/
#define NullChar 0
#define NotReadChar 1
#define InCoreChar 2

struct CharData
  {
    short status;
    short width;
    union
      {
        MemRaster *raster;
	CharInfo cInfo;
      } u;
  } FontTab[256];
short CharAlign = 1, underLinePos = 3, underLineWidth = 1,
    maxWidth = 8, descent = 0,
    minChar = 0, maxChar = 127, offsetInFile = 0, height = 16;
FILE *inFont = 0;
static PopUpEntry RasterOpMenu[] =
  {
    "Invert Source",		0,
    "Invert Destination",	1,
    "Copy",			GXcopy,
    "Or (Paint) to destination",GXpaint,
    "And to destination",	GXand,
    "Xor into destination",	GXxor,
    0, 0
  };

static PopUpEntry NamesMenu[14] =
  {
    "The empty raster",		0,
    "The screen",		1,
    0, 0
  };
static NamesCount = 2;
MemRaster *curRaster;
int curOtherRefs = 0; /* 1 if *curRaster has other refs i.e. in NamesMenu */
short x=0, y=0, buttons=0, oldButtons=0; char cbuf[30]; File vgtFile;
main()
  { int function, i;
    curFont = GetFontEntry(curFontName, 0);
    GetTTY();
    sdf = CreateSDF();
    DefineSymbol(sdf,1,0);
#define OutlineItem 3
    AddItem(sdf,OutlineItem, 0, 10, 0, 10, 0, SDF_OUTLINE, 0);
    AddItem( sdf, 2, 10, 1000, 10, 26, 0, SDF_SIMPLE_TEXT,
	     "Remote VGTS raster test program" );
    EndSymbol(sdf,1,0);
    vgt = CreateVGT(sdf, GRAPHICS+ZOOMABLE, 1, "Bits (raster editor)");
    /* CreateView(vgt, 16, 10, 612, 350, -2, -2, Scale8, 1); */
    DefaultView(vgt, 0, 0, -4, -4, Scale8, 1, 0, 0);
    ModifyPad(stdin, ReportTransition+LF_Output+CR_Input); 
    vgtFile.fileserver = stdin->fileserver;
    vgtFile.fileid = vgt;
    
    Update(SubRaster(0, 0, 0, 0, 16, 32));

    for ( ; ; )
      {
        oldButtons = buttons;
	c=GetEvent(stdin,&x,&y,&buttons,cbuf);
	if (c < 0) {printf("Mouse Error!"); Flush(stdout);continue;}
	if (c > 0) { c = *cbuf; goto mouseXit;}
	if (buttons == MiddleButton)
	  { int edges=0;
	    if (x==-1) edges+=LeftEdge;
	    if (y==-1) edges+=BottomEdge;
	    if (x==curRaster->width) edges+=RightEdge;
	    if (y==curRaster->height) edges+=TopEdge;
	    if (edges) { AdjustEdges(edges); continue;}
	    /* ... else fall through ... */
	  }
	if ((buttons == LeftButton || buttons == MiddleButton)
	    && (curRaster->where & MemoryRaster))
	  { int old, new = buttons==LeftButton; oldButtons = buttons;
	    while (buttons==GetMouseStatus(&vgtFile,&x,&y,0))
	      {
	        old = ChangeBit(curRaster, x, curRaster->height - 1 - y, new);
		if (new == !old) Show(curRaster);
	      }

	    continue;
	  }
	if (buttons == RightButton)
	  {
	    c=GetEvent(stdin,&x,&y,&buttons,cbuf);
	    if (c||buttons) continue;
	    c = popup(Menu);
	    if (c < 0) continue;
	    /* ... else fall through ... */
	  }
	else continue;
  mouseXit:
    switch(c)
     {
	case '\r': putchar(c); c = '\n'; /* fall thru ... */
	case '\n':
	    Show(curRaster);  continue;
	case '?': Statistics(curRaster); continue;
	case '>': { int dx, dy; /* shift by dx, dy */
	    dx=getint(); dy=getint();
	    r = curRaster;
	    curRaster = SubRaster(0, r, dx, dy, r->height - dy, r->width - dx);
	    continue;
	  }
	case '/': { int w, h; /* restrict to w*h */
	    printf(" width:");Flush(stdout);    w=getint();
	    printf(" height:");Flush(stdout); h=getint();
	    r = curRaster;
	    curRaster = SubRaster(0, r, 0, 0, h, w);
	    continue;
	  }

        case ':': c = GETCHAR();
	    if(c == '0'||c=='*') c = 26; else { c-='A';c &= 0x1F;}
	    RastTab[c] = curRaster; continue;
        case InvertRaster:
	    if (curRaster==&EmpRaster) {curRaster = &InvEmpRaster; continue;}
	    curRaster = SubRaster(0, curRaster, 0, 0,
	        curRaster->height, curRaster->width);
	    curRaster->where ^= InverseRaster;
	    Show(curRaster);
	    continue;
	case SaveCopy:
	    Update(UniqueCopy(curRaster)); continue;
	case BitBlt: {
	    int invSrc = 0, invDst = 0; short function;
	    if (NamesCount<=2)
	      {
		printf(
 "The destination must be selected from the name table, which is empty!\n");
		Flush(stdout); continue;
	      }
	  askOp:
	    c = popup(RasterOpMenu);
	    if (c < 0) continue;
	    if (c == 0) {invSrc = !invSrc; goto askOp;}
	    if (c == 1) {invDst = !invDst; goto askOp;}
	    function = c;
	    if (invSrc) {d0=function;function=InvertSource();}
	    if (invDst) {d0=function;function=InvertDest();}
	    c = popup(NamesMenu+2);
	    if (c < 0) continue;
	    Update(RasterOp(RastTab[c], curRaster, function)); curOtherRefs++;
	    continue;
	  }
        case '=': case '|': case '^': {
	    int invDst;
	    function = c == '=' ? GXcopy : c == '|' ? GXpaint : GXxor;
	    c = GETCHAR();
	    if (invDst = (c == '~')) c = GETCHAR();
	    r = RastTab[c];
	    if (invDst) r->where ^= InverseRaster;
	    r = (MemRaster *)(RasterOp(r, curRaster, function));
	    if (c < 26 && invDst) r->where ^= InverseRaster;
	    curRaster = r;
	    continue;
	}
	case CTRL('C'): case CTRL('D'): case CTRL('Z'):
	    Quit();
	case OldName:
	    c=popup(NamesMenu);
	    if (c>=0) {Update(RastTab[c]); curOtherRefs++;}
	    continue;
	case NewName: { int i;
	    if (NamesCount>12)
	        {printf("No more names!\n");Flush(stdout);continue;}
	    printf("Type name to remember raster as: "); Flush(stdout);
	    if (!GetString()) continue;
/*	    for (i = 2; i < NamesCount; i++)
	        if (strcmp(name, NamesMenu[i].string) == 0)
		    ...
*/
	    NamesMenu[NamesCount].string=strcpy(malloc(strlen(name)+1),name);
	    NamesMenu[NamesCount].menuNumber = NamesCount;
	    RastTab[NamesCount] = curRaster; curOtherRefs++;
	    NamesCount++;
	    NamesMenu[NamesCount].string = 0;
	    NamesMenu[NamesCount].menuNumber = 0;
	    continue;
	  }
	case ReadRaster: Update(GetRaster()); continue;
	case WriteRaster: PutRaster(curRaster,0); continue;
	case WriteHex: PutRaster(curRaster,1); continue;
	case ReadChar: Update(ReadFontChar()); continue;
	case '@': c = GETCHAR();
	    curRaster = (MemRaster *)(FontRaster(0,curFont->font, c&0x7F));
	   continue;
	case Experimental:
	     c = popup(ExperimentalMenu);
	     switch (c)
	       {
		case Xload: LoadFont(); break;
		case Xget: c = GETCHAR(); curOtherRefs++;
		    Update(LoadSFChar(inFont,c)); continue;
	       }
	     continue;
	default:
/*	if (c >= 'a' && c <= 'z') {curRaster = RastTab[c - 'a']; continue;}
	if (c >= 'A' && c <= 'Z') {curRaster = RastTab[c - 'A']; continue;}*/
	printf("c=%x.",c); c &= 0x7F;
	}
      }
  }

Getint() { int n=0, negative;
    while (!c || c==' '||c=='\t') c=GETCHAR();
    if (negative = c == '-') c=GETCHAR();
    while(c >='0' && c<='9') {n *= 10; n+= c - '0'; c = GETCHAR();}
    return negative ? -n : n;
}
Quit()
  {
    DeleteVGT(vgt,1);
    DeleteSDF(sdf);
    ResetTTY();
    exit();
  }

Show(r)
    MemRaster *r;
    /* update the VGT to display raster 'r' */
  {
    EditSymbol(sdf,1);
    DeleteItem(sdf,2);
    if (r && ((r->where & ~InverseRaster) == IsFbRaster))
        AddItem(sdf, 2, 0, 99, 0, 16, 0, SDF_TEXT, "<Frame buffer raster>");
    else if (!r || !(r->where & MemoryRaster))
        AddItem(sdf, 2, 0, 99, 0, 16, 0, SDF_TEXT,
	    !r || !(r->where&InverseRaster) ? "<Empty raster>"
	    : "<Black empty raster>");
    else
      { int temp = r->bitOffset || r->height != r->stride;
	if (temp) r = UniqueCopy(r);
        AddItem(sdf, 2, 0, r->width-1, 0, r->height-1,
	    r->where&InverseRaster, SDF_RASTER, r->start);
        if (temp) FreeRaster(r);
      }
    if (r)
      ChangeItem(sdf, OutlineItem, -1, r->width, -1, r->height,
	AllEdges, SDF_OUTLINE, 0);
    EndSymbol(sdf, 1, vgt);
  }

char *
GetString()
    /* read string from keyboard. If BELL, abort and return 0, else string. */
  {
    char  *s = name, c;
	    do {c=GETCHAR();} while ( c==' '||c=='\t') ;
	    while (c!=' ' && c!='\t' && c!='\r' && c!='\n') {
	        if (c=='\b' || c==127)
		    {if (s > name) {s--;printf(" \b");Flush(stdout);}}
		else if (c==('G'&0x1F))
		    {printf("---Aborted---");Flush(stdout);return (0);}
		else *s++ = c;
		c = GETCHAR();
	      }
	    *s = 0;
    return(name);
  }
MemRaster *
GetRaster()
  { File *f; register MemRaster *r; int i;
    printf("File to read in .sun format: ");
    if (!GetString()) return(0);
    f = fopen(name, "r");
    if (f <= 0) {strcat(name, ".sun"); f = fopen(name, "r");}
    if (f <= 0) {printf("!not Open!"); Flush(stdout); return(0);}
    r = (MemRaster*)(malloc(sizeof(MemRaster)));
    fseek(f, 4, 1);
    fread(&(r->height), 2, 1, f);
    r->stride = r->height;
    r->bitOffset = 0;
    r->where = HeadRaster+LinkedRaster+MemoryRaster;
    r->next = r;
    fread(&(r->width), 2, 1, f);
    i = r->height * ((r->width + 15) >> 4) << 1;
    r->start = (short*)(malloc(i));
    fread(r->start, i, 1, f);
    fclose(f);
    return(r);
  }

PutRaster(r, inHex)
    register MemRaster *r;
    /* write raster to file, in one of two formats:
     * inhex=0: .sun format
     * inhex=1: hex text that can be compiled by c.
     */
  {
    File *f; int i, temp;
    if (!inHex) printf("File to write in .sun format: ");
    else printf("File to write to in hex: ");
    if (GetString() == NULL) return(0);
    f = fopen(name,"w");
    if (f <= 0) {printf("!not Open!");Flush(stdout);return(0);}
    i = r->height * ((r->width + 15) >> 4) << 1;
    if (temp = (r->bitOffset || r->height != r->stride)) {
       r = RasterOp(0, r, GXcopy);
    }
    if (!inHex)
      {
	putc(157,f); putc(3,f); putc(0,f); putc(1,f);
	putc((r->height) >> 8, f);
	putc((r->height) & 0xFF, f);
	putc((r->width) >> 8, f);
	putc((r->width) & 0xFF, f);
	fwrite(r->start, i, 1, f);
      }
    else
      { register unsigned short *w = (unsigned short *)(r->start);
        register int j; i >>= 1;
	for (j = 0; ++j <= i; )
	  {
	    fprintf(f,"\t0x%x", *w++);
	    if (j<i) putc(',', f);
	    if (j>=i || !(j&7)) putc('\n',f);
	  }
      }
    if(temp) FreeRaster(r);
    fclose(f);
    return(1);
  }

Statistics(r)
    register MemRaster *r;
  { int i; register MemRaster *q;
    printf("Raster data: height: %d, width: %d.%s\n",
	r->height, r->width, r->where&InverseRaster ? "Inverted" : "");
    if (r->where&MemoryRaster)
	printf("\t[bitoffset: %d, stride: %d, start-address: %x]\n",
	    r->bitOffset, r->stride, r->start);
    if (r->where&LinkedRaster)
      { 
	for ((q = r->next, i = 0); q != r; q = q->next) i++;
	printf("\t%s. Other rasters pointing at same bitmap: %d.\n",
	    r->where&HeadRaster ? "HeadRaster" : "SubRaster",
	    i);
      }
    Flush(stdout);
	
  }

MemRaster *
ReadFontChar()
  {	
    FontEntry *tempFont;
    printf("Use font (current is: %s): ", curFontName); Flush(stdout);
    if (!GetString()) return(0);
    if (*name)
      {
        curFontName = (char*)strcpy(malloc(strlen(name)+1),name);
	printf("Font file (default is /usr/sun/lib/libsfonts.a): ");
	Flush(stdout);
	if (!GetString()) return(0);
	if ((tempFont = GetFontEntry(curFontName, *name ? name : 0)) > 0)
	    curFont = tempFont;
	else
	  { printf("!!! Font not found !!!\n"); Flush(stdout); return(0);}
      }
    printf("Character? "); Flush(stdout);
    c = GETCHAR(); putchar('\n'); Flush(stdout);
    return (UniqueCopy(FontRaster(0, curFont->font, c&0x7F)));
  }

#define FreeMemRaster(r) \
    if (r && r->where&LinkedRaster) {FreeRaster(r); free(r);}
MemRaster *
Update(r)
    MemRaster *r;
  {
    if (!r) return(0);
    if (!curOtherRefs) FreeMemRaster(curRaster)
    Show(curRaster = r);
    curOtherRefs = 0; /* by default */
    return(r);
  }

LoadFont()
  {
    printf("Load font: "); Flush(stdout);
    if (!GetString()) return(0);
    if (inFont <= 0) fclose(inFont);
    inFont = fopen(name,"r");
    if (inFont <= 0) {printf("Not found!\n"); Flush(stdout); return(0);}
    LoadSFont(inFont);
  }
ClearFont()
  { register ch;
    for (ch = 0; ch <= 255; ch++)
      {
	FontTab[ch].status = NullChar;
	FontTab[ch].width = 0;
	FontTab[ch].u.raster = &EmpRaster;
      }
  }
fgetshort(fp)
    FILE *fp;
  { unsigned char ch = 0xFF & getc(fp);
    return((ch << 8) + (0xFF & getc(fp)));
  }

LoadSFont(fp)
    FILE *fp;
  { unsigned char ch;
    ClearFont();
    fgetshort(fp);
    height = fgetshort(fp);
    maxWidth = fgetshort(fp);
    descent = fgetshort(fp);
    minChar = getc(fp); maxChar = getc(fp);
    fseek(fp, 6, 1);
    for (ch = minChar; ch <= maxChar; ch ++)
      {
	fread(&(FontTab[ch].u.cInfo), 4, 1, fp);
	FontTab[ch].status = NotReadChar;
	FontTab[ch].width = FontTab[ch].u.cInfo.width;
      }
  }

MemRaster *
LoadSFChar(fp, ch)
    register unsigned char ch; FILE *fp;
  { register CharInfo *cInf = &FontTab[ch].u.cInfo;
    register offset = cInf->bit, width;
    register MemRaster *raster;
    if (FontTab[ch].status != NotReadChar) return (FontTab[ch].u.raster);
    fseek(fp, FontTab[ch].u.cInfo.word + offsetInFile, 0);
    width = offset + cInf->width;
    raster = SubRaster(0, 0, 0, 0, height, width);
    fread(raster->start, (height*(width+15)>>4) << 2, 1, fp);
    FontTab[ch].u.raster = UniqueCopy(
        SubRaster(0, raster, offset, 0, height, width - offset));
    FreeMemRaster(raster);
    FontTab[ch].status = InCoreChar;
    return(FontTab[ch].u.raster);
  }

WriteFont(format)
  {
  }

WriteSFont(fp)
    FILE *fp;
  { unsigned char ch; MemRaster *workRaster;
/*    calculate, write length of file
    putshort(height, fp);
    putshort(maxWidth, fp);
    putshort(descent, fp);
    if (minChar > MINCHAR) minChar = MINCHAR;
    putc(minChar, fp);
    if (maxChar < MAXCHAR) maxChar = MAXCHAR;
    putc(maxChar, fp);
    putc((underLinePos << 3) + underLineWidth, fp);
    putc(0x80*(index[-1]>=0 
	+ 0x40*(!(CharAlign%16)) + 0x20 * (!(CharAlign%8)) 
	+ 0x10 * (indexable > 0), fp);
    putword(0, fp); putshort(0, fp); * no kerning *
    bufUsed = 0;
    for (ch = minChar; ch <= maxChar; ch++)
      {
	bufUsed = ((bufUsed + CharAlign - 1) / CharAlign) * CharAlign;
	putshort(, fp);
	putc( , fp);
	switch(FontTab[ch].status)
	  {
	    case NullChar: putc(0, fp); break;
	    case NotReadChar: putc(pointer&0xFF, fp); break;
	    case InCoreChar: putc(pointer->width, fp); break;
	  }
      }
    workRaster = SubRaster(0, 0, 0, 0, height, (maxWidth+31)&0xFFF0);
    for (ch = minChar; ch <= maxChar; ch++)
      {
	if (FontTab[ch].status == NotReadChar) Load(ch);
	if (FontTab[ch].status == NotReadChar) Free(...ch);
      }
    free workRaster;
*/
  }
MemRaster *
AdjustEdges(edges)
  { short xLeft= -1, xRight=curRaster->width,
         yBot= -1, yTop=curRaster->height, changed;
    while (GetMouseStatus(&vgtFile,&x,&y,&buttons) >= 0)
	if (buttons==MiddleButton)
	  { changed=0;
	    if (edges&LeftEdge && x!=xLeft) {xLeft=x;changed=1;}
	    if (edges&RightEdge &&x!=xRight) {xRight=x;changed=1;}
	    if (edges&TopEdge && y!=yTop) {yTop = y;changed=1;}
	    if (edges&BottomEdge && y!=yBot) {yBot = y;changed=1;}
	    if (changed)
	      {
		EditSymbol(sdf,1);
		ChangeItem(sdf, OutlineItem, xLeft,xRight,yBot,yTop,
		 AllEdges,SDF_OUTLINE,0);
	        EndSymbol(sdf, 1, vgt);
	     }
	  }
	else if (buttons) return(curRaster);
	else
	    return(Update(SubRaster(0, curRaster, 
		xLeft+1, curRaster->height - yTop,
		yTop-yBot-1, xRight-xLeft-1)));
  }

