/* amaze:  a distributed multi-person Vkernel game
 * Copyright (c) 1983  Eric J. Berglund & David R. Cheriton
 *
 * This file, test.c, is the 8th of 8 files which make up the distributed
 * game amaze.  It consists of performance analysis routines.
 * It contains InitTests and PrintTestResults.
 */

#include "amaze.h"

int maxoff[ MAX_PLAYERS ];
int sum[ MAX_PLAYERS ];
int count[ MAX_PLAYERS ];
int weirdcount[ MAX_PLAYERS ];


InitTests( state )
	GameState *state;
  {
    unsigned i;
    for( i = 0; i < MAX_PLAYERS; i++ )
      {
	maxoff[ i ] = 0;
	sum[ i ] = 0;
	count[ i ] = 0;
	weirdcount[ i ] = 0;
      }
  }

ConductTests( monster, i )
	MonsterState *monster;
	unsigned i;
  {
    int diff;
    diff = Abs( monster->x - monster->old_x ) + Abs( monster->y - monster->old_y );
    if( monster->old_living_status == ALIVE || monster->old_living_status == HIDDEN && Abs( monster->x - monster->old_x ) < 700 )
      {
	if( diff > maxoff[ i ] ) maxoff[ i ] = diff;
	if( diff > 10 ) weirdcount[ i ]++;
	sum[ i ] += diff;
	count[ i ]++;
      }
  }


PrintTestResults( state )
	GameState *state;
  {
    unsigned i;
    for( i = 0; i < MAX_PLAYERS; i++ )
      if( i != state->mymonsternumber )
	printf( "monster #  %d  maxoff  %d  avg  %d  count %d  weirdct %d\n",
	  i, maxoff[ i ], count[i] == 0 ?  0 : sum[i]/count[i], count[i],
	  weirdcount[i] );
  }
