/*  amaze : a distributed multi-person Vkernel game.
 *  Copyright (c) 1983  Eric J. Berglund  &&  David R. Cheriton
 *
 *  This file, init.c, is the 3rd of 8 files which make up the distributed
 *   game amaze.  It contains the one routine Initialize, which is responsible
 *   for creating most of the helper processes, determining the other
 *   players currently running the game, and initializing both the state
 *   of the game and the maze representation of that state.
 */

#include "amaze.h"

#define TIMES_TO_TRY	1	/* Number of times to try getting a	*/
				/* valid game manager.  I had this up	*/
				/* to 3 when the kernel wasn't as solid	*/
				/* as it is now.			*/


GameState state;		/* The actual allocation of space for	*/
				/* state.				*/



GameState *Initialize()
  {
    extern KeyboardReader(), GameTimer(), StatusInquirer();
    extern GXBase;

    Message msg;
    GameRequest *req = (GameRequest *) msg;
    GameReply *replymsg = (GameReply *) msg;

    ProcessId pid, gamemgrpid, manager;
    MonsterState *monster;
    unsigned i;


    state.mymanager = GetPid( 0, LOCAL_PID );
    state.myautopilot = NULL_PROCESS;
    state.mykeyboardreader = Create( 3, KeyboardReader, 500 );
    Ready( state.mykeyboardreader, 1, state.mymanager ); 

    printf( "AMAZE!!!!!!!!! *** Distributed Multi-person Game\n" );

    i = 1;
    do
      gamemgrpid = GetPid( GAME_MANAGER, REMOTE_PID );
    while( (gamemgrpid == 0 || !ValidPid( gamemgrpid )) && i++ < TIMES_TO_TRY );

    req->requestcode = JOIN_GAME;
    if( (gamemgrpid == 0) || (Send(req, gamemgrpid) == 0) )
      {
	/* We are starting a new game and not joining an existing one. */
	printf( "***New Game Starting***\n" );

	monster = &(state.monsterstates[0]);
	monster->gamemanager = state.mymanager;

	for( i = 1; i < MAX_PLAYERS; i++ )
	  {
	    state.monsterstates[i].gamemanager = NULL_PROCESS;
	    state.monsterstates[i].statusinquirer = NULL_PROCESS;
	  }
      }

    else if( replymsg->replycode == OK )
      {
	/* We are joining an existing game. */
	printf( "*** Game Already Exists***\n" );

	/* Analyze the JOIN_GAME reply to determine the other managers, find
 	 * out what monsternumber I've been given, and create status inquirers
	 * to ask about the other players in the game.
	 */

	for( i = 0; i < MAX_PLAYERS; ++i )
	  {
	    manager = replymsg->monstermanagers[i];
	    if( manager == state.mymanager )
	      {
		state.mymonsternumber = i;
		printf( "*** Joining game as player %d ***\n", i );
	      }
	  }

	for( i = 0; i < MAX_PLAYERS; ++i )
	  {
	    monster = &(state.monsterstates[i]);
	    manager = replymsg->monstermanagers[i];
	    monster->gamemanager = manager;
	    if( manager != NULL_PROCESS &&  manager != state.mymanager )
	      {
		pid = Create( 3, StatusInquirer, 1500 );
		Ready( pid, 4, state.mymonsternumber, state.mymanager,
								 i, manager);
		monster->statusinquirer = pid;
		monster->remoteasker = RESPOND_WHEN_ASKED;
	      }
	    else
	      {
		monster->statusinquirer = NULL_PROCESS;
		monster->remoteasker = NO_ONE_WAITING;
	      }
	  }
      }

    else
      {
	printf( "Refused permission to join game\n" );
	return( NULL );
      }

/* Set up the initial display and state for the game.
 * Defer displaying the other monsters until the status inquirers report
 * back to us.
 */
    SetPid( GAME_MANAGER, state.mymanager, ANY_PID );

    Delay( 1, 0 );

    InitState( &state );
    InitTests( &state );

    GXBase = GXDefaultBase;
    GXwidth = 1;
    DrawMaze( &state );
    DrawPicture( &state );

    state.mytimer = Create( 5, GameTimer, 2000 );
    Ready( state.mytimer, 3, state.mymanager, GAME_CLICKS, &state );

    return( &state );
  }
