/*  amaze: a distributed multi-person Vkernel game.
 *  Copyright (c) 1983  Eric J. Berglund  &  David R. Cheriton
 *
 *  This file, draw.c, is the 7th of 8 files which make up the distributed
 *  game amaze.  It contains virtually all references to the graphical
 *  display of the maze and the players' states.  These include the
 *  rasters for the monsters, missiles, explosions ( missiles which have
 *  hit a wall ), the door, and the vertical and horizontal rectangles
 *  which make up the maze display.  Most of these graphics, and some of
 *  the initial work on the program, were done by Judy Sybille.
 *  The routines included are DrawMaze, BlinkDoor, and DrawPicture.
 */


#include "amaze.h"


/*  Raster arrays for monsters. */


short monster0[120] = {		/* Spike */
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x3,0x2,0xFFFE,
	0x3806,0x0802,0x2,0x3,0x1,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x800,0x800,0x1800,0x1800,0x3800,0x800,0x800,0x800,0x800,0x800,
	0x800,0x800,0x800,0x1C00,0x3E00,0xE380,0x80C0,0x6660,0x6620,0x30,
	0x3F,0x20,0xAE20,0x7560,0x80C0,0xC380,0x7E00,0x1800,0x1000,0x1000,
	0x1000,0x1000,0x1000,0x1000,0x1000,0x1C00,0x1800,0x1800,0x1000,0x1000,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x1C00,
	0xFF00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0};



short monster1[120] = {		/* Double ghost */
	0x0,0x0,0x78,0x1CF,0x301,0xE00,0x1800,0x1000,0x3000,0x2803,
	0x3001,0x2208,0x2514,0x28A2,0x4BAE,0x4BAE,0x4514,0x4208,0x4000,0x4000,
	0x4000,0x4000,0x4000,0x4000,0x4000,0xC000,0x8000,0x8000,0x8000,0x8060,
	0x81F8,0x830C,0x8606,0x87FE,0x8000,0x8000,0x8000,0x8000,0x8000,0xFFFF,
	0x0,0x0,0x1E,0xF3,0xC380,0x4200,0x6600,0x3400,0x1C00,0x800,
	0x0,0x0,0x0,0xE1,0x111,0x2CA,0x1D1,0xE0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x80,0x100,0x100,0x0,0x0,0x7F,
	0x60,0x30,0x1F,0x6,0x0,0x0,0x1800,0x3C00,0x2400,0xE7FF,
	0x0,0x0,0x0,0x8000,0xC000,0x7000,0x1800,0x800,0xC00,0x400,
	0x400,0x400,0x400,0xE400,0x1600,0xCA00,0xD200,0xE200,0x200,0x200,
	0x200,0x200,0x200,0x200,0x1200,0xB00,0x900,0x100,0x100,0xE100,
	0x6100,0xC100,0x8100,0x100,0x100,0x100,0x100,0x100,0x100,0xFF00};


short monster2[120] = {		/* E. T. */
	0x7E,0x3E3,0xE00,0x187F,0x30C0,0x6000,0xC21C,0x8232,0x8222,0x8634,
	0x841C,0x8400,0x8003,0x81FE,0x8000,0xC078,0x4000,0x6003,0x3000,0x1C00,
	0x780,0xE0,0x20,0x3E,0x13,0x18,0xC,0x6,0x2,0x2,
	0x3,0x1,0x1,0x1,0x0,0x0,0x0,0x0,0x0,0x0,
	0x7E,0xFFC3,0x0,0xFE,0x3,0x0,0x7E38,0x4244,0x2444,0x2C,
	0x38,0x4200,0x81C0,0x7F,0x0,0x1E,0x3C00,0xC3C0,0x0,0x0,
	0x1,0x7,0x4,0x7C,0xC3C8,0x7E10,0x30,0x30,0x40,0x40,
	0xC3C0,0x7E80,0x1880,0x8180,0x8180,0xC300,0x4200,0x4200,0x4200,0x4200,
	0x0,0xC000,0x7000,0x1800,0xC00,0x600,0x4300,0x4100,0x4100,0x6100,
	0x2100,0x2100,0x100,0x8100,0x100,0x300,0x200,0x600,0xC00,0x3800,
	0xE000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0};


short monster3[120] = {		/* Pumpkin */
	0x0,0x3C,0xE7,0x381,0x607,0xC3D,0x820,0x18E0,0x1080,0x3080,
	0x6180,0x411F,0xC13F,0x8119,0x8300,0x8200,0x8200,0x8200,0x8200,0x8300,
	0x8100,0xC100,0x4100,0x4100,0x4170,0x4138,0x619E,0x20CF,0x30C7,0x1861,
	0xC20,0x420,0x620,0x3F0,0x50,0x30,0x3C,0x7,0x1,0x0,
	0x400,0xC18,0x18FF,0x9B81,0x5EE0,0xFFB0,0x808,0x806,0x802,0x801,
	0x800,0x88F8,0xCBFC,0x8998,0x800,0x800,0x800,0x1800,0x1800,0x3C00,
	0x7E00,0xFF00,0x800,0x800,0x800,0x803,0x866,0x9FE4,0x9CF8,0xFCF0,
	0x800,0x800,0x803,0x806,0x80C,0x818,0x831,0x867,0xFFFC,0x0,
	0x0,0x0,0x0,0xE000,0x3000,0x1800,0xC00,0x600,0x200,0x200,
	0x8300,0x4100,0x4100,0x4100,0x4100,0x4100,0x2100,0x2100,0x2100,0x3100,
	0x1100,0x1300,0x1200,0x1200,0x2200,0x2200,0x2200,0x2200,0x4200,0x4600,
	0xC400,0x8C00,0x9800,0x1000,0x3000,0x6000,0xC000,0x0,0x0,0x0};


short monster4[120] = {		/* Eyeball */
	0x0,0xF,0x3F,0x7F,0x1FF,0x3FF,0x7FF,0xFFF,0xFFF,0x1FF8,
	0x3FE0,0x3F87,0x7E1F,0x787F,0x61FE,0x47FC,0xBFFA,0xFFF8,0xFFF8,0xFFF1,
	0x9FF8,0x8FFA,0xE7F8,0xF3F9,0x78FC,0x7C7E,0x7F3F,0x7F8F,0x3FC7,0x3FF1,
	0x1FF8,0xFFE,0xFFF,0x7FF,0x3FF,0x1FF,0x7F,0x3F,0xF,0x0,
	0xFF00,0xFFF0,0xFFF8,0xFFFE,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0x3F,
	0x7,0xFFC1,0xEFF8,0xFE,0x827F,0x103F,0x229F,0x801F,0x5F,0x10F,
	0x12F,0x1F,0x435F,0x201F,0x443F,0x107F,0x2F8,0xFFF0,0xFFC1,0xFF8F,
	0x3F,0x7F,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFE,0xFFFC,0xFFF0,0xFF00,
	0x0,0x0,0x0,0x0,0x8000,0xC000,0xE000,0xF000,0xF000,0xF800,
	0xFC00,0xFC00,0x7E00,0x1E00,0x8E00,0xE200,0xFF00,0xFF00,0xFF00,0xFF00,
	0xFF00,0xFD00,0xF100,0xE300,0x8E00,0x1E00,0x7E00,0xFE00,0xFC00,0xFC00,
	0xF800,0xF000,0xF000,0xE000,0xC000,0x8000,0x0,0x0,0x0,0x0};


struct mem_raster MonsterRaster[] =  {{MONSTER_WIDTH,MONSTER_HEIGHT,monster0},
				{MONSTER_WIDTH,MONSTER_HEIGHT,monster1},
				{MONSTER_WIDTH,MONSTER_HEIGHT,monster2},
				{MONSTER_WIDTH,MONSTER_HEIGHT,monster3},
				{MONSTER_WIDTH,MONSTER_HEIGHT,monster4}};


short int SkullHead[ 120 ] = {
	0x0, 0x0, 0x0, 0x1003, 0x381f, 0x3c3f, 0xf87f, 0xfcff,
	0xffff, 0x5fff, 0xfff, 0x7f8, 0x3f0, 0x3e0, 0x3c0, 0x3c0,
	0x3c0, 0x1c0, 0x1e0, 0xe0, 0xf0, 0x78, 0x7f, 0x3f,
	0x1f, 0xf, 0x1f, 0x3f, 0x7f, 0x2fd, 0x7f3, 0xfe1,
	0x7c0, 0x1e0, 0x1c0, 0x80, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0xfff00, 0xffc0, 0xfff8, 0xfffc, 0xfffe, 0xffff,
	0xffff, 0xffff, 0xffff, 0xff1f, 0x7e0f, 0x3c07, 0x1803, 0x1803,
	0x1803, 0x1803, 0x3c07, 0x3c07, 0x660f, 0xe71e, 0xc3fc, 0xe7f8,
	0xfff0, 0xfff0, 0xf8, 0x5afc, 0xfffe, 0x5adf, 0xcf, 0xff87,
	0xff03, 0x7e07, 0x3, 0x1, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x800, 0x1c00, 0x3c00, 0x1f00, 0x1f00,
	0xbf00, 0xfa00, 0xf000, 0xe000, 0xc000, 0xc000, 0xc000, 0xc000,
	0xc000, 0xc000, 0x8000, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x8000, 0xe000, 0xf000,
	0xe000, 0x8000, 0x8000, 0x0, 0x0, 0x0, 0x0, 0x0 };

struct mem_raster SkullRaster = { MONSTER_WIDTH, MONSTER_HEIGHT, SkullHead };



/* Rasters for JUST_FIRED and WHIZZING missiles. */

short MissileRight[ 64 ] = {
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0xffc0, 0xfff0, 0xfffc, 0xffff, 0xffff, 0xfffc, 0xfff0, 0xffc0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0  };

short MissileLeft[ 64 ] = {
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x3, 0xf, 0x3f, 0xff, 0xff, 0x3f, 0xf, 0x3,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0  };

short MissileUp[ 64 ] = {
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x1800, 0x1800, 0x3c00, 0x3c00, 0x7e00, 0x7e00, 0xff00, 0xff00,
	0xff00, 0xff00, 0xff00, 0xff00, 0xff00, 0xff00, 0xff00, 0xff00,
	0xff00, 0xff00, 0xff00, 0xff00, 0xff00, 0xff00, 0xff00, 0xff00 };

short MissileDown[ 64 ] = {
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0xff00, 0xff00, 0xff00, 0xff00, 0xff00, 0xff00, 0xff00, 0xff00,
	0xff00, 0xff00, 0xff00, 0xff00, 0xff00, 0xff00, 0xff00, 0xff00,
	0xff00, 0xff00, 0x7e00, 0x7e00, 0x3c00, 0x3c00, 0x1800, 0x1800 };

struct mem_raster MissileRaster[] = {
	 { MISSILE_WIDTH, MISSILE_HEIGHT, MissileUp },
	 { MISSILE_WIDTH, MISSILE_HEIGHT, MissileDown },
	 { MISSILE_WIDTH, MISSILE_HEIGHT, MissileLeft },
	 { MISSILE_WIDTH, MISSILE_HEIGHT, MissileRight } };


/* Rasters for explosions--missiles which have HIT_WALL. */

short ExplosionUp[ 120 ] = {
	0x4007, 0x21e, 0x2238, 0x22ff, 0x41fc, 0x47e7, 0x5f0f, 0x409f,
	0x6037, 0xa00f, 0x9019, 0x9031, 0x8a61, 0x8583, 0xc213, 0x420b,
	0x4127, 0x30c7, 0x1806, 0xf2e, 0x1de, 0x4f, 0x58, 0x30,
	030, 0x28, 0x66, 0x41, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x93ec, 0x73e, 0xa9f, 0x121f, 0xf, 0x818c, 0x80e4, 0x12f6,
	0x32f9, 0x7abf, 0xffcf, 0xffc1, 0xffe2, 0xeef0, 0xce72, 0x867c,
	0x8638, 0x1e7c, 0xe39c, 0x20e, 0x207, 0x2207, 0xc007, 0x119,
	0x320, 0x6c0, 0x3c00, 0xf000, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x400, 0x400, 0x8000, 0xc200, 0xe200, 0xf200, 0xa00, 0x4400,
	0xc200, 0xc200, 0xe200, 0xf100, 0x1d00, 0x500, 0x100, 0x200,
	0x600, 0xc00, 0x3800, 0xe000, 0x8000, 0x0, 0x8000, 0x8000,
	0x8000, 0xc000, 0x4000, 0x6000, 0x2000, 0x2000, 0x1000, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 };


short ExplosionDown[ 120 ] = {
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x800, 0x400, 0x400, 0x600, 0x200, 0x303, 0x104,
	0x198, 0x1e0, 0xe0, 0x1e0, 0x770, 0x1c39, 0x303e, 0x601c,
	0x403e, 0x804e, 0xa00f, 0xb847, 0x8f83, 0x47f3, 0x43fd, 0x439f,
	0x226f, 0x5027, 0x4f31, 0x47f0, 0x43f8, 0x1f9, 0x207c, 0x203c,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0xf82, 0x3c66, 0x6014, 0xc00c,
	0x800c, 0x31a, 0x44f2, 0x403b, 0x4074, 0xc760, 0x78e3, 0x61e4,
	0x61d0, 0x73c8, 0x77c1, 0xff86, 0xff8c, 0xff98, 0x5ef0, 0x4cec,
	0x48f9, 0x1f0, 0x81e7, 0x3f, 0x48ff, 0x501c, 0xe078, 0x79e0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x8000, 0xf000, 0x1800, 0x600, 0x8200,
	0x4200, 0x4300, 0xa100, 0x5100, 0x900, 0x900, 0x500, 0x600,
	0x200, 0xfa00, 0xe200, 0x8200, 0x4400, 0x4400, 0x4000, 0x800 };


short ExplosionLeft[ 120 ] = {
	0x1e, 0x1ee1, 0xc10c, 0x208, 0x418, 0xc30, 0x1df0, 0x3ce0,
	0x38f0, 0x796a, 0xff61, 0xfce1, 0xf1c7, 0xc3cf, 0x3bf, 0x27fc,
	0x4438, 0xf1ff, 0xc03f, 0xa07e, 0x91f8, 0xfc, 0x7e, 0x863f,
	0x97ff, 0xd7c7, 0xdfc0, 0x7b61, 0x79b2, 0x3c98, 0x1c08, 0x1d04,
	0xe04, 0x760b, 0x604, 0x208, 0x8230, 0x30c0, 0xf83, 0x7e,
	0x0, 0x8000, 0xc000, 0x6000, 0x2002, 0x301c, 0x1070, 0x1bc0,
	0xf00, 0x1e00, 0x7e00, 0xf100, 0xe100, 0xc080, 0x4040, 0x2040,
	0x4180, 0xfcc0, 0xc060, 0x4020, 0x4030, 0x2430, 0x2210, 0xa210,
	0xc410, 0xf420, 0xfc20, 0x1e40, 0xb80, 0x91e0, 0x4e30, 0x4800,
	0x9800, 0x1000, 0x1000, 0x3000, 0x6000, 0x4000, 0x8000, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 };


short ExplosionRight[ 120 ] = {
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x10, 0xc, 0x7, 0x1, 0x2, 0x4, 0x4, 0x8,
	0x8, 0x8, 0xc, 0xc, 0x4, 0x6, 0x3, 0x1,
	0x2, 0x2, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x3, 0xe, 0x38, 0x40, 0x0, 0x0, 0x0, 0x0,
	0x7e, 0x1c1, 0x203, 0x60c, 0xc10, 0x820, 0x8d0, 0x01920,
	0x1220, 0x7210, 0x8919, 0xd04d, 0x7886, 0x3f03, 0x2fe3, 0x23ff,
	0x45fc, 0x447e, 0x243f, 0x21f, 0x27e, 0x3fc, 0x3fff, 0x841c,
	0x43f, 0x2fd, 0x3f3, 0x87e3, 0x8f87, 0x7e86, 0x7856, 0xf00f,
	0xd80f, 0x80f, 0xc0c, 0x418, 0x611, 0x330, 0x187, 0x78,
	0x0, 0xf000, 0xe00, 0x4100, 0x4000, 0x6000, 0x6e00, 0x7000,
	0xb800, 0x3800, 0x3c00, 0x9e00, 0xde00, 0xfb00, 0xeb00, 0xe900,
	0x6100, 0x0, 0x0, 0x8900, 0x500, 0x300, 0x8f00, 0x2200,
	0xe400, 0xc000, 0xc300, 0x8f00, 0x3f00, 0xff00, 0x9e00, 0x1c00,
	0x3c00, 0xb800, 0x3000, 0x2000, 0x4000, 0x8300, 0x7c00, 0x0 };

struct mem_raster ExplosionRaster[] = {
	{ EXPLOSION_WIDTH, EXPLOSION_HEIGHT, ExplosionUp },
	{ EXPLOSION_WIDTH, EXPLOSION_HEIGHT, ExplosionDown },
	{ EXPLOSION_WIDTH, EXPLOSION_HEIGHT, ExplosionLeft },
	{ EXPLOSION_WIDTH, EXPLOSION_HEIGHT, ExplosionRight } };



/* The fb_rasters for the vertical and horizontal lines of the
 * maze, and for the door are arranged according to the standard
 * SUN graphics package :
 *	struct fb_raster
 *	  {
 *	    short height;
 *	    short width;
 *	    short x;	pixel-x-address of upper left corner
 *	    short y;	pixel-y-address of upper left corner
 *	  };
 */


struct fb_raster VerticalWalls [ NUM_VERT_WALLS ] =
       {359, 10,   0,   0,
	380, 10,   0, 409,
	359, 10, 789,   0,
	380, 10, 789, 409,
	 90, 20,  59, 199,
	390, 20,  59, 339,
	 90, 20, 129,  59,
	180, 20, 129, 269,
	230, 20, 129, 499,
	 79, 20, 199,   0,
	110, 20, 199, 409,
	150, 20, 199, 639,
	 90, 20, 339, 199,
	300, 20, 409,  59,
	 90, 20, 479, 269,
	110, 20, 509, 409,
	110, 20, 579, 479,
	 90, 20, 579, 639,
	160, 20, 629, 269,
	240, 20, 649, 549,
	160, 20, 719, 129,
	250, 20, 719, 479};

struct fb_raster HorizontalWalls [ NUM_HORIZ_WALLS ] =
       {10, 799,   0,   0, 
	20,  90,  59,  59, 
	20,  90,  269, 59, 
	20, 330,  409, 59, 
	20,  79,   0, 129, 
	20, 300, 129, 129, 
	20, 260, 479, 129, 
	20, 230,  59, 199, 
	20, 260, 409, 199, 
	20, 160, 199, 269, 
	20, 190, 549, 269, 
	20,  79,   0, 339, 
	20, 230, 199, 339, 
	20, 100, 479, 339, 
	20, 100, 699, 339, 
	20, 120, 199, 409, 
	20, 120, 409, 409, 
	20,  70, 579, 409, 
	20, 100, 699, 409, 
	20, 160, 579, 479, 
	20, 400, 129, 499, 
	20, 400, 199, 569, 
	20, 170, 199, 639, 
	20, 180, 419, 639, 
	20, 260, 269, 709, 
	10, 799,   0, 779};


struct fb_raster DoorPanels[9] =
       {10, 10, 319, 409,
	10, 10, 329, 419, 
	10, 10, 339, 409, 
	10, 10, 349, 419, 
	10, 10, 359, 409, 
	10, 10, 369, 419, 
	10, 10, 379, 409, 
	10, 10, 389, 419, 
	10, 10, 399, 409};

struct fb_raster Door = { 20, 90, 319, 409 };


extern int  MonsterDisplayY [];



/* Draw the maze and the figures of the players to the right of it. */

DrawMaze( state )
	GameState *state;
  {
    unsigned i;
    register struct mem_raster *memraster;
    struct fb_raster destraster;

    ScreenClear();

    GXfunction = GXset;
    for( i = 0; i < NUM_VERT_WALLS; i++ )
      RasterFill( &VerticalWalls[i] );
    for( i = 0; i <NUM_HORIZ_WALLS ; i++ )
      RasterFill( &HorizontalWalls[i] );

    for( i=0; i<MAX_PLAYERS; i++ )
      {
	memraster = state->monsterstates[i].raster;
	destraster.x = MONSTER_DISPLAY_X;
	destraster.y = MonsterDisplayY[ i ];
	destraster.height = memraster->height;
	destraster.width = memraster->width;
	GXfunction = GXcopy;
	RasterPut( &destraster, memraster );
      }
  }


BlinkDoor()
  {
    static int modulus;
    unsigned i;

    if( ( ++modulus & 7 ) == 7 )
      {
	if( modulus & 8 )
	  {
	    GXfunction = GXset;
	    for( i = 0; i < 9; i++ )
	      RasterFill( &DoorPanels[i] );
	  }
	else
	  {
	    GXfunction = GXclear;
            RasterFill( &Door );
	  }
      }
  }



/* Draw the graphical representation of the state of each missile and monster.
 */

DrawPicture( state )
	GameState *state;
  {
    struct mem_raster *memraster;
    struct fb_raster destraster;
    short int i;
    MonsterState *monster;
    MissileState *missile;
    int pixelsoff;

    for( i=0; i < MAX_PLAYERS; i++ )
      {
	monster = &( state->monsterstates[ i ] );
	missile = &( monster->missile );

	switch( missile->state )
	  {
	    case JUST_LOADING:
		/* Erase from previous position. */
 		memraster = &( ExplosionRaster[ missile->direction ] );
		destraster.x = missile->old_x;
		destraster.y = missile->old_y;
		destraster.height = memraster->height;
		destraster.width = memraster->width;
		GXfunction = GXclear;
		RasterFill( &destraster );
		break;

	    case LOADING:
		/* Don't display. */
		break;

	    case JUST_READY:
		/* Display away from the maze. */
		memraster = &( MissileRaster[ RIGHT ] );
		destraster.x = missile->x;
		destraster.y = missile->y;
		destraster.height = memraster->height;
		destraster.width = memraster->width;
		GXfunction = GXcopy;
		RasterPut( &destraster, memraster );
		missile->old_x = destraster.x;
		missile->old_y = destraster.y;
		break;

	    case READY:
		/* Don't erase or redisplay. */
		break;

	    case JUST_FIRED:
	    case WHIZZING:
		/* Erase at former position and draw at new position. */
		memraster = missile->raster;
		destraster.x = missile->old_x;
		destraster.y = missile->old_y;
		destraster.height = memraster->height;
		destraster.width = memraster->width;
		GXfunction = GXclear;
		RasterFill( &destraster );
		destraster.x = missile->x;
		destraster.y = missile->y;
		GXfunction = GXcopy;
		RasterPut( &destraster, memraster );
		missile->old_x = destraster.x;
		missile->old_y = destraster.y;
		break;

	    case HIT_WALL:
		/* Alternately erase former image and draw explosion--to
		 * give flashing effect to explosion. */
		memraster = &( ExplosionRaster[ missile->direction ] );
		destraster.height = memraster->height;
		destraster.width = memraster->width;
		if( missile->count & 1 )
		  {
		    destraster.x = missile->x;
		    destraster.y = missile->y;
		    GXfunction = GXcopy;
		    RasterPut( &destraster, memraster );
		    missile->old_x = destraster.x;
		    missile->old_y = destraster.y;
		  }
		else
		  {
		    destraster.x = missile->old_x;
		    destraster.y = missile->old_y;
		    GXfunction = GXclear;
		    RasterFill( &destraster );
		  }
	  }

	BlinkDoor();

	switch( monster->living_status )
	  {
	    case CONCEIVED:
		/* Draw in "uterus box" in center of the screen. */
		memraster = monster->raster;
		destraster.x = monster->x;
		destraster.y = monster->y;
		destraster.height = memraster->height;
		destraster.width = memraster->width;
		GXfunction = GXcopy;
		RasterPut( &destraster, memraster );
		break;

	    case EMBRYO:
		/* Don't erase or redisplay. */
		break;

	    case ALIVE:
		/* Erase at former position and draw at new position. */
		memraster = monster->raster;
		destraster.x = monster->old_x;
		destraster.y = monster->old_y;
		destraster.height = memraster->height;
		destraster.width = memraster->width;
		GXfunction = GXclear;
		RasterFill( &destraster );
		destraster.x = monster->x;
		destraster.y = monster->y;
		GXfunction = GXcopy;
		RasterPut( &destraster, memraster );
		monster->old_x = destraster.x;
		monster->old_y = destraster.y;
		monster->old_living_status = monster->living_status;
		break;

	    case HIDDEN:
		/* Erase at former position and display inverted if it's my
		 * own monster, not at all if another's monster. */
		memraster = monster->raster;
		destraster.x = monster->old_x;
		destraster.y = monster->old_y;
		destraster.height = memraster->height;
		destraster.width = memraster->width;
		GXfunction = GXclear;
		RasterFill( &destraster );
		destraster.x = monster->x;
		destraster.y = monster->y;

		if( i == state->mymonsternumber )
		  {
		    GXfunction = GXcopy;
		    RasterPut( &destraster, memraster );
		    GXfunction = GXinvert;
		    RasterFill( &destraster );
		  }
		monster->old_x = destraster.x;
		monster->old_y = destraster.y;
		monster->old_living_status = monster->living_status;
		break;

	    case SHOT:
		/* Alternately display the monster and a skull at the scene
		 * of the murder. */
		memraster = monster->raster;
		destraster.x = monster->old_x;
		destraster.y = monster->old_y;
		destraster.height = memraster->height;
		destraster.width = memraster->width;
		GXfunction = GXclear;
		RasterFill( &destraster );

		GXfunction = GXcopy;
		if( monster->count & 1 )
		    RasterPut( &destraster, &SkullRaster );
		else
		    RasterPut( &destraster, memraster );
		break;

	    case STIFF:
		/* Display a skull at the scene of the murder. */
		memraster = monster->raster;
		destraster.x = monster->old_x;
		destraster.y = monster->old_y;
		destraster.height = memraster->height;
		destraster.width = memraster->width;
		GXfunction = GXclear;
		RasterFill( &destraster );
		GXfunction = GXcopy;
		RasterPut( &destraster, &SkullRaster );
		break;

	    case DYING:
		/* Alternately display the monster and the monster inverted
		 * inverted at the place of death. */
		memraster = monster->raster;
		destraster.x = monster->old_x;
		destraster.y = monster->old_y;
		destraster.height = memraster->height;
		destraster.width = memraster->width;
		if( monster->count & 1 )
		  {
		    GXfunction = GXinvert;
		    RasterFill( &destraster );
		  }
		else
		  {
		    GXfunction = GXcopy;
		    RasterPut( &destraster, memraster );
		  }
		break;

	    case JUST_DIED:
		/* Erase the monster from the point of death. */
		memraster = monster->raster;
		destraster.x = monster->old_x;
		destraster.y = monster->old_y;
		destraster.height = memraster->height;
		destraster.width = memraster->width;
		GXfunction = GXclear;
		RasterFill( &destraster );
		break;

	    case DEAD:
		/* Don't display. */
		break;

	  }
      }
  }
