/*
 * spiral.c
 *
 * Sun Spirals by Jeffrey Mogul
 *
 * stolen from:
 * Hackmem Minksy?
 */

#define XBIAS 0
#define YBIAS 0

#include "framebuf.h"

extern int GXBase;

/*
 * POINT(x,y) sets the given point to whatever the prevailing
 * function is.
 */
#define	POINT(x,y) {\
    GXsetX((x)+XBIAS);\
    *(short*)(GXBase|GXupdate|GXsource|GXselectY|(((y)+YBIAS)<<1))=\
    						0xFFFF;\
    }

/*
 * spiral starts with a circle going through x0,y0 centered
 * at cx,cy
 * mode is either GXset or GXclear
 * r should be something like 4
 * endx is limit on x value.
 */
spiral(x0,y0,r,cx,cy,mode,endx)
int x0;
int y0;
register int r,cx,cy;
unsigned int mode;
int endx;
{ /*	*/
	register int x,y;
	register int xtemp;

	GXfunction = mode;

	x = x0;
	y = y0;

	while (x < endx) {
		POINT(cx+x,cy+y);
		xtemp = x;
		x += (y>>r);
		y -= (xtemp>>r);
		}

}	

/*
 * spiralclp is like spiral but clips instead of scissors.
 */
spiralclp(x0,y0,r,cx,cy,mode,endx)
int x0;
int y0;
register int r,cx,cy;
unsigned int mode;
int endx;
{ /*	*/
	register int x,y;
	register int dx,dy;
	int xtemp;
	

	GXfunction = mode;

	x = x0;
	y = y0;

	while (x < endx) {
		dx = cx+x;
		dy = cy+y;
		if ((dx > 0) && (dx < 1024) &&
			(dy > 0) && (dy < 1024))
				POINT(cx+x,cy+y);
		xtemp = x;
		x += (y>>r);
		y -= (xtemp>>r);
		}

}	
