/*
 * sins.c - a cute graphics hack
 *
 * Author: Mike J. Spreitzer
 *
 * March 1982
 * 
 * Incorporated into td by Bill Nowicki
 */

struct sinusoid {float phase, freq, amplitude;};
struct liss {struct sinusoid x, y;};

#include <rasterops.h>
#include <framebuf.h>

#include "triangles.c"

extern double sin();

struct fb_raster rastemp;

#define mybitblt(ix, iy, dx, dy) {rastemp.x = ix; rastemp.y = iy; rastemp.width = dx; \
 rastemp.height = dy; RasterFill(&rastemp);}

#define fullcycle 360.0
#define halfcycle 180.0
#define quartercycle 90.0

#define mymin(m,n) ((n < m)? n : m)

int do_more = 1;
int centerx = 400;
int centery = 400;
int myhalfwidth = 390;
int myprintflag = 0;

square(a, b)
struct intpoint *a, *b;
mybitblt(mymin(a->x, b->x), mymin(a->y, b->y), abs(a->x - b->x), abs(a->y - b->y))

printsin(naml, nams, s)
char *naml, *nams;
struct sinusoid *s;
{
printf("%s.%s is phase=%f, freq=%f, ampl=%f\n",
    naml, nams, s->phase, s->freq, s->amplitude);
}

printliss(naml, l)
char *naml;
struct liss *l;
{
printsin(naml, "x", &l->x);
printsin(naml, "y", &l->y);
}

int want_more()
{
char c;
int holding, more;
holding = 0; more = 1;
while (more && do_more && (holding || linereadyrx(0))) {
    while (!linereadyrx(0)) ;
    c = lineget(0);
    if (c == 'p') myprintflag = 1 - myprintflag;
    else if (c == 'h') {if (!holding) {holding = 1; printf("holding... ");} }
    else if (c == 'c') {if (holding) {holding = 0; printf("continuing... \n");} }
    else if (c == 'a') {printf(" Aborting pattern.\n"); more = 0; }
    else if (c == 'q') {printf(" I quit!\n"); more = 0; do_more = 0; }
    else if (holding) printf("c=>continue, p=>toggle printout, a=>abort pattern, q=>quit sinning\n");
    else printf("h=>hold, p=>toggle printout, a=>abort pattern, q=>quit sinning\n");
    }
return more;
}

dosin(nsteps, incr, ca, cb, cc, tri)
int nsteps, tri;
float incr;
struct liss *ca, *cb, *cc;
{
float t;
struct intpoint pa, pb, pc;
/* printf("doing it with %d steps, %f incr.\n", nsteps, incr); */
if (myprintflag) {
    printf("steps=%d, incr=%f, tri=%d\n", nsteps, incr, tri);
    printliss("a", ca);
    printliss("b", cb);
    if (tri) printliss("c", cc);
    }
GXfunction = GXclear;
mybitblt(0, 0, 1024, 1024);
for (t=0; (nsteps != 0) && want_more(); nsteps--, t += incr) {
    GXfunction = GXinvert;
    evalliss(&pa, ca, t);
    evalliss(&pb, cb, t);
    if (tri) {
	evalliss(&pc, cc, t);
	triangle(&pa, &pb, &pc);
	}
    else square(&pa, &pb);
    }
}

float evalsinusoid(s, t)
struct sinusoid *s;
float t;
{float r;
float ctr = 2.0 * 3.141592653589793 / fullcycle;
int n, sign;
t = s->phase + t * s->freq;
if (t < 0) {sign = -1; t = -t;} else sign = 1;
n = t/fullcycle;
t = t - n * fullcycle;
if ((t >= quartercycle) && (t < (quartercycle + halfcycle))) t = halfcycle - t;
r = s->amplitude * sign * sin(t * ctr);
#ifdef debugliss
printf("evaling p=%f, f=%f, a=%f, t=%f to get %f\n",
    s->phase, s->freq, s->amplitude, t, r);
#endif
return r;
}

evalliss(p, l, t)
struct intpoint *p;
struct liss *l;
float t;
{
p->x = centerx + evalsinusoid(&l->x, t);
p->y = centery + evalsinusoid(&l->y, t);
#ifdef debugliss
printf("got x=%d, y=%d\n", p->x, p->y);
#endif
}

fillin(y, lx, rx)
int y, lx, rx;
{
  register short *xp = (short *)(GXBase|GXupdate|GXselectX);
  register int count = rx-lx;
  GXsetY(y);
  xp += lx;
  GXwidth = 16;
  while (count>16)
     {
       *xp = count;
       xp += 16;
       count -= 16;
     }
   if (count>0)
     {
       GXwidth = count;
       *xp = count;
     }
}

getsinusoid(nam, s)
char *nam;
struct sinusoid *s;
{float p, f, a;
printf("phase, freq, and amp for %s: ", nam);
scanf("%f, %f, %f", &p, &f, &a);
s->phase = p;
s->freq = f;
s->amplitude = a;
}

getliss(nam, l)
char *nam;
struct liss *l;
{
printf("for curve %s:\n", nam);
getsinusoid("x", &l->x);
getsinusoid("y", &l->y);
}

getNgo()
{
struct liss a, b, c;
int steps;
int tri;
float incr;
int status;

  do
   {
      printf("which (0=>wrectangles, 1=>triangles, 2=>quit): ");
      scanf("%d", &tri);
      if (tri > 1) {do_more = 0; return; }
      printf("steps, 360degrees/increment: ");
      status = scanf("%d, %f", &steps, &incr);
      printf( "steps=%d, increment=%f\n", steps, incr );
    } while (status != 2 || incr == 0.0);
  incr = fullcycle/incr;
  getliss("a", &a);
  getliss("b", &b);
  if (tri) getliss("c", &c);
  dosin(steps, incr, &a, &b, &c, tri);
}

makeOneUp()
{
struct liss a, b, c;
float power = 32768.0;
float incr;
int steps, tri, n;
#define pickAnAmp 0.4*myhalfwidth + 0.6*myhalfwidth*rand()/power
#define pickAphase (n = 72 * rand()/power, 5.0 * n)
#define pickAfreq (n = 0.8 + 10.0*(rand()/power)*(rand()/power), (0.5 > (rand()/power))?n:-n)
#define pickAnOddFreq (n = 5.0*(rand()/power)*(rand()/power), 1+2*n)
if (0.5 < (rand()/power)) {
    a.x.amplitude = b.x.amplitude = c.x.amplitude = myhalfwidth;}
else {
    a.x.amplitude = pickAnAmp;
    b.x.amplitude = pickAnAmp;
    c.x.amplitude = pickAnAmp; }
a.y.amplitude = a.x.amplitude;
b.y.amplitude = b.x.amplitude;
c.y.amplitude = c.x.amplitude;
a.x.phase = pickAphase;
a.y.phase = pickAphase;
if (0.6 < (rand()/power)) {
    b.x.phase = pickAphase;
    b.y.phase = pickAphase;
    c.x.phase = pickAphase;
    c.y.phase = pickAphase; }
else {
    b.x.phase = pickAphase;
    b.y.phase = b.x.phase + a.y.phase - a.x.phase;
    c.x.phase = pickAphase;
    c.y.phase = c.x.phase + a.y.phase - a.x.phase;}
if (0.3 < (rand()/power)) {
    if (0.5 > (rand()/power)) {
	a.y.freq = a.x.freq = pickAfreq;
	b.y.freq = b.x.freq = pickAfreq;
	c.y.freq = c.x.freq = pickAfreq;}
    else {
	a.x.freq = a.y.freq = b.x.freq = b.y.freq = c.x.freq = c.y.freq = 1.0;}
    }
else {
    a.x.freq = pickAfreq;	a.y.freq = pickAfreq;
    b.x.freq = pickAfreq;	b.y.freq = pickAfreq;
    c.x.freq = pickAfreq;	c.y.freq = pickAfreq; }
if (0.3 < rand()/power) tri = 0; else tri = 1;
steps = 360 - 180*tri;
incr = fullcycle/steps;
dosin(steps, incr, &a, &b, &c, tri);
delay();
}

delay()
{struct intpoint a, b, c;
int i;
a.x = a.y = 300;
c.x = c.y = 700;
b.x = 300; b.y = 700;
for (i=0; (want_more()) && do_more && (i < 16); i++) {
    GXfunction = GXnoop;
    triangle(&a, &b, &c);
    }
}

mysins(cx, cy, dxy)
int cx, cy, dxy;
{
int s, t;
do_more = 1;
GXcontrol = GXvideoEnable;
if ((cx == 0) || (cy == 0)) {
    printf("screen centerx, centery = "); scanf("%d, %d", &centerx, &centery);
    printf("centering at %d, %d\n", centerx, centery);
    dxy = 390;
    }
else {centerx = cx; centery = cy; myhalfwidth = dxy; }
printf("seed (0 => manual operation) : ");
scanf("%d", &s);
if (s == 0) printf("in manual mode\n");
else {printf("on autopilot\n"); srand(s); }
for (t=0; t < s; t += 17) rand();
myprintflag = 0;
while (do_more) {
    if (s == 0) getNgo();
    else makeOneUp();
    }
}
