/*
 * scroll.c - test the scrolling speed of the RasterCopy operation
 *
 * Copyright (c) William I. Nowicki May 1982
 */

# include <framebuf.h>
# include <rasterops.h>


short buf[1024];

struct fb_raster src = { 1022, 1023, 0,2}, 
		 dst = { 1022, 1023, 0,0},
		 top = { 2, 1023, 0, 0 },
		 bot = { 2, 1023, 0, 1022 },
		 screen = { 200, 200, 400,400 };
		 
struct mem_raster mem = { 2, 1023, buf };

int GXBase;

int UpBy = 2;

Change(n)
  {
    /*
     * rotate up n pixels at a crack
     */
    UpBy = n;
    src.height = 1024 - n;
    dst.height = 1024 - n;
    bot.y      = 1024 - n;
    src.y      = n;
    top.height = n;
    bot.height = n;
    mem.height = n;
  }

main()
  {
    GXBase = GXProbe();
    while (1)
     {
      while (!linereadyrx(0))
        {
          GXfunction = GXcopy;
/*        RasterGet(  &mem, &top );
	  RasterCopy( &dst, &src );  
	  RasterPut(  &bot, &mem ); */
	  RasterRoll( &screen, UpBy );
        }

      switch (getchar())
        {
	  case 'q': exit();
	  case '-': Change( -UpBy );
	  	break;

	  case '1': Change(1);
	  	break;
	  case '2': Change(2);
	  	break;
	  case '3': Change(3);
	  	break;
	  case '4': Change(4);
	  	break;
	  case '5': Change(5);
	  	break;
	  case '6': Change(6);
	  	break;
	  case '7': Change(7);
	  	break;
	  case '8': Change(8);
	  	break;
	  case '9': Change(9);
	  	break;
	}      
    }
  }
