/*	standard routine to read and write a .pix header		*/

#define ReadPicHeader(name,format,maxgray,height,width) 		\
									\
	if (getchar () != 157) {					\
		fprintf (stderr, "%s: not a graphics file\n", name);	\
		exit (1);						\
		}							\
	if (getchar () != (format)) {					\
		fprintf (stderr, "%s: unrecognized format\n");		\
		exit (1);						\
		}							\
	getchar ();							\
	(maxgray) = getchar ();						\
	(height) = getchar ();						\
	(height) = ((height) << 8) + getchar ();			\
	(width) = getchar ();						\
	(width) = ((width) << 8) + getchar ()				\

#define WritePicHeader(format,maxgray,height,width)			\
									\
	putchar (157);							\
	putchar (format);						\
	putchar (0);							\
	putchar (maxgray);						\
	putchar ((height) >> 8);					\
	putchar ((height) & 0377);					\
	putchar ((width) >> 8);						\
	putchar ((width) & 0377)					\
