program Translate (PicIn*, AscOut);

(*  This translates a picture file in ".pic" format to ".asc" format, so that they
	can be safely FTP'd around the network.


	Format of a ".pic" file on SAIL, for the PIX program.
	=====================================================

Picture is H samples high, W samples wide, B bits/sample

decimal word #	     contents
--------------	     --------

	0		-1			to confirm file format
	1		B
	2		ceil(W/floor(36/B))	#36-bit words per scanline

	3		Y0			first scanline #
	4		Y0 + H - 1		last scanline #

	5		X0			first col #
	6		X0 + W - 1		last col #

	7-127					unused

	128-EOF		Data samples, scanning Left to Right, then Top to Bottom.
			Each scanline starts on a word boundary.  Samples are
			byte-packed in the word.

*)

(* type	Word = set of 0..35; *)
type Word = packed array [0..35] of boolean;

var	ByteSize:	integer;
	ScaleFactor:	integer;
	MaxGray:	integer;
	Height,	Width:	integer;
	Row, Col:	integer;
	PicIn:		file of integer;
	AscOut:		text;
	CurrentWord:	record
			case integer of
      			  1: (w: Word);
			  2: (i: integer);
			end;
	BitsLeft:	integer;
	CurrentBit:	integer;
	I, J:		integer;

procedure ReadWord (var X: integer);
	begin
	X := PicIn^;
	BitsLeft := 36;
	CurrentBit := 0;
	get (PicIn)
	end;

function ReadByte (NBits: integer): integer;
	var Sum, i: integer;
	begin
	if (BitsLeft < NBits) then
		ReadWord (CurrentWord.i);
	if (NBits = 36) then
		Sum := CurrentWord.i
	else
		begin
		Sum := 0;
		for i:= 1 to NBits do
			begin
			if (CurrentWord.w [CurrentBit]) then
				Sum := 2*Sum + 1
			else
				Sum := 2*Sum;
			CurrentBit := CurrentBit + 1
			end
		end;
	BitsLeft := BitsLeft - NBits;
	ReadByte := Sum;
	end;

begin
BitsLeft := 0;
reset (PicIn);
rewrite (AscOut);
I := ReadByte (36);
if (I <> -1) then
	writeln (tty, 'wrong file type', I);
ByteSize := ReadByte (36);
if (ByteSize < 1) or (ByteSize > 8) then
	writeln (tty, 'wrong byte size', ByteSize);
I := ReadByte (36);
Height := ReadByte (36);
	Height := ReadByte (36) - Height + 1;
Width := ReadByte (36);
Width := ReadByte (36) - Width + 1;
writeln (tty, 'image is ', Height, ' high by ', Width, ' wide.');
writeln (tty, 'byte size is' , ByteSize);
break (tty);
for I := 7 to 127 do
	j := ReadByte (36);

case (ByteSize) of
	1:	begin ScaleFactor := 255; MaxGray := 255 end;
	2:	begin ScaleFactor := 85;  MaxGray := 255 end;
	3:	begin ScaleFactor := 36;  MaxGray := 252 end;
	4:	begin ScaleFactor := 17;  MaxGray := 255 end;
	5:	begin ScaleFactor := 8;   MaxGray := 248 end;
	6:	begin ScaleFactor := 4;   MaxGray := 252 end;
	7:	begin ScaleFactor := 2;   MaxGray := 254 end;
	8:	begin ScaleFactor := 1;   MaxGray := 255 end
end; (* case *)

writeln (Ascout, 157:3);	(* magic number for pix files *)
writeln (Ascout, 1:3);		(* code for standard B&W file *)
writeln (Ascout, 0:3);		(* spare header byte, not used in format #1 *)
writeln (Ascout, MaxGray:3);	(* this value defined to be white *)

writeln (Ascout, (Height div 256):3);	(* Height high order byte *)
writeln (Ascout, (Height mod 256):3);	(*	  low order byte *)
writeln (Ascout, (Width div 256):3);	(* Width high order byte *)
writeln (Ascout, (Width mod 256):3);	(*	 low order byte *)


for Row := 1 to Height do
	begin
	for Col := 1 to Width do
		writeln (Ascout, (ReadByte (ByteSize) * ScaleFactor):3);
	BitsLeft := 0
	end
end.
