/*
 *	Graphics demo for Sun.  Reads a digitized photo in .sun format
 *	and displays it.  A quick hack, could be improved a lot.
 *
 *	Mike Kenniston, December 1981
 *
 * Bill Nowicki June 1982
 *	- Updated for newer packages
 *	- Set up stack
 *	- Added more dialog
 */

#include <framebuf.h>
#include <rasterops.h>
#include <stdio.h>
# include "m68000.h"

int Mem [1024];		/* big enough for one column */
int GXBase;


char temp[256];
char buf [100], user[100], host[100];

struct mem_raster src;
struct fb_raster  dst;

int Debug = 0;		/* true for debug printouts */

main ()
{
	int height, width;
	int colsleft;
	FILE *fp;
	register char *p;
	register int y;
	extern char _end;

	GXBase = GXProbe ();
	GXcontrol = GXvideoEnable;

	sp = (int *)emt_getmemsize();
	if (Debug) printf( "_end=0x%x, sp=0x%x\n", &_end, sp);
	printf( "Photo display program\n");
	printf( "Enter host name: "); scanf("%s",host);
	printf( "Enter user name: "); scanf("%s",user);
	printf( "Try car, planet, rods, or a full path name, or ``q'' to quit\n");

	while (1) 
	  {
		printf ("picture: ");
		scanf ("%s", buf);
		if (strcmp (buf, "q") == 0) break;
		if (index(buf,'/')==NULL)
		  {
		    sprintf( temp, "[%s:%s]/usr/sun/src/graphics/pix/%s",
		      host, user, buf );
		    strcpy( buf, temp );
		  }
		strcat (buf, ".sun");
		if (Debug) printf( "Before opening %s\n", buf );
		fp = fopen (buf, "r");
		if (Debug) 
		  {
		    printf( "returned from fopen, fp=0x%x\n", fp);
		    printf( "_cnt=%d, _ptr=0x%x, _base=0x%x, _flag=0x%x, _file=%d\n",
		       fp->_cnt, fp->_ptr, fp->_base, fp->_flag, fp->_file );
		  }
		if (fp == NULL)
		  {
		    printf( "Unable to open %s\n", buf);
		    continue;
		  }
		if (Debug) puts( "fopen OK!");
		if (getc(fp) != 157) 
		  {
			printf ("%s is not a graphics file\n", buf);
			fclose (fp);
			continue;
		  }
		if (Debug)
		  {
		    puts( "did a getc" );
		    printf( "_cnt=%d, _ptr=0x%x, _base=0x%x, _flag=0x%x, _file=%d\n",
		       fp->_cnt, fp->_ptr, fp->_base, fp->_flag, fp->_file );
		 }
		if (getc(fp) != 3) 
		  {
			printf ("%s is not a sun file\n", buf);
			fclose (fp);
			continue;
		  }

		getc (fp);
		getc (fp);

		ScreenClear();
		height = getc (fp);
		height = (height << 8) + getc (fp);
		width = getc (fp);
		width = (width << 8) + getc (fp);
		colsleft = width;

		dst.height = height;
		dst.y = 0;
		src.height = dst.height;
		src.width = dst.width;
		src.start = (short *) Mem;
		GXfunction = GXcopy;
		while (colsleft > 0) 
		  {
			p = (char *) Mem;
			for (y = height<<1; y--; )
				*p++ = getc (fp);

			dst.width = colsleft > 16 ? 16 : colsleft;
			dst.x = width - colsleft;
			RasterPut( &dst, &src);
			colsleft -= 16;
		   }
		fclose (fp);
	}
}
