#include <stdio.h>

#include <framebuf.h>
#include "rasterops.h"

/* io.h contains macro definitions storage and contants for Tom Davis's
   	user interface package    */

#include "io.h"		

/* Command word definitions */

#define Cmd_Undefined	-1
#define	Cmd_Set_Funct	1
#define Cmd_Rop_Copy	2
#define	Cmd_Set_Mask	3
#define	Cmd_Set_Source	4
#define Cmd_Rop_Fill	5
#define Cmd_Rop_MvMsk	6
#define Cmd_Rop_Put	7
#define Cmd_Rop_Get	8


CMD_WORD table[] =
    {
    "s", "et_function", "hex value", Cmd_Set_Funct,
    " m", "ask_reg", "hex value", Cmd_Set_Mask,
    " s", "ource_reg", "hex value", Cmd_Set_Source,
    "f", "ill_region", "x,y,h,w", Cmd_Rop_Fill,
    "m", "ove_mask", "x,y,h,w", Cmd_Rop_MvMsk,
    "c", "opy_raster", "sx,sy,h,w,dx,dy", Cmd_Rop_Copy,
    "p", "ut_raster", "x,y,h,w,index", Cmd_Rop_Put,
    "g", "et_raster", "index,x,y,h,w", Cmd_Rop_Get,
    0, 0, 0, 0
    };

char *read_buf_ptr;
char read_buf[READ_BUF_SIZE];

short	mask[16] = 
   	{ 0x8001, 0x4002, 0x2004, 0x1008, 0x810, 0x420, 0x240, 0x180,
	  0x180, 0x240, 0x420, 0x810, 0x1008, 0x2004, 0x4002, 0x8001 };

int		GXBase;
extern	short	scratch_buffer[];

main()
{
int i,x,y,h,w;
struct fb_raster	src, dst;	/* later change to raster */
struct mem_raster	msrc, mdst;	/* later change to raster */

    GXBase = GXProbe();
    printf("RasterCopy test routine\n");
    term_init();	/* initialize the user interface package */


    while(1){

label:
    GET_CMD(i,table,label)
    switch(i){
        case Cmd_Set_Funct:
	    GET_HEX(x, label)
	    GET_OK(label)
	    GXfunction = x;
	    break;

        case Cmd_Set_Mask:
	    GET_HEX(x, label)
	    GET_OK(label)
	    GXsetMask = x;
	    break;

        case Cmd_Set_Source:
	    GET_HEX(x, label)
	    GET_OK(label)
	    GXsetSource = x;
	    break;

	case Cmd_Rop_Copy:
	    GET_NUM(src.x, label)
	    GET_NUM(src.y, label)
	    GET_NUM(src.height, label)
	    GET_NUM(src.width, label)
	    GET_NUM(dst.x, label)
	    GET_NUM(dst.y, label)
	    GET_OK(label)
    /* Do a Framebuffer to Framebuffer Raster-Op involving Dest and Src */
	    ROP_DS_FF(&dst, &src);
	    break;

        case Cmd_Rop_Fill:
            GET_NUM(dst.x, label)
            GET_NUM(dst.y, label)
            GET_NUM(dst.height, label)
            GET_NUM(dst.width, label)
            GET_OK(label)
	    ROP_D_F (&dst);
	    break;
	    
	case Cmd_Rop_MvMsk:
            GET_NUM(dst.x, label)
            GET_NUM(dst.y, label)
            GET_NUM(dst.height, label)
            GET_NUM(dst.width, label)
            GET_OK(label)
	    ROP_DM_FM (&dst, mask);
	    break;

	case Cmd_Rop_Put:
            GET_NUM(dst.x, label)
            GET_NUM(dst.y, label)
            GET_NUM(dst.height, label)
            GET_NUM(dst.width, label)
	    GET_NUM(i, label);
            GET_OK(label)
	    msrc.start = &scratch_buffer[i];
	    ROP_DS_FM (&dst, &msrc);
	    break;

	case Cmd_Rop_Get:
	    GET_NUM(i, label);
            GET_NUM(src.x, label)
            GET_NUM(src.y, label)
            GET_NUM(src.height, label)
            GET_NUM(src.width, label)
            GET_OK(label)
	    mdst.start = &scratch_buffer[i];
	    ROP_DS_MF (&mdst, &src);
	    break;

	}

	puts("");
	read_buf_ptr = &read_buf[0];
	read_buf[0]=0;
    }
}
