/* rasterop
 * General two-operand rasterop, for rasters as defined in <bitmaps.h>
 * Limitations:
 * Source can be in memory or framebuffer, but destination must be memory.
 * Also, cannot handle raster in the FB which are close to the left edge
 * than out->bitOffset
 * Does not handle overlapping rasters yet.
 * Per Bothner, March 1983
 * Sept. 83 - Fixed problems with 'shift' PB
 */
#include <Vio.h>
#include <bitmaps.h>
#include <rasterops.h>
#include <framebuf.h>
#include <m68000.h>
#define GXBase GXDefaultBase
/* The routine compiles code into this table, making it non-reentrant */
short CodeTable[50];
#define compileW(x) {asm(" .word 0x34FC"); asm(x);} /* *copy++ = x */
MemRaster *
RasterOp(out, in, function)
  register MemRaster *in, *out;		/* a5, a4 */
  int function;	/* a subset of the GXfunction codes */
  {
    register char *outp;		/* a3 */
    register short *code;		/* a2 */
#define inp1 a0
#define inp2 a1
    register i;				/* d7 */
    register short columnCtr;		/* d6 */
    register short vertCtr;		/* d5 */
    register unsigned short mask;	/* d4 */
    register short shift;		/* d3 */
    short *saveCode, *loopTopPc;
    short inSkip, inSkip2, outSkip; /* address increments after each column */
    MemRaster tempRaster;
    char inWhere;
    int fullWidth; /* includes out->bitOffset */
    int height;
    if (!out)
      {
	out = (MemRaster *)(malloc(sizeof(MemRaster)));
	out->where = IsHeadRaster;
	out->height = out->stride = in->height;
	out->width = in->width;
	out->bitOffset = 0;
	out->start = (short *)(malloc(in->height * ((in->width + 15) >> 4) << 2));
	out->next = out;
	/* ??? modify function ? */
      }
    if (!in) {in = &tempRaster; in->where = IsNullRaster;}
    inWhere = in->where;
    if (inWhere & InverseRaster)
        {d0=function; function=InvertSource(); inWhere ^= InverseRaster;}
    if (out->where & InverseRaster) {d0=function; function=InvertDest();}
/* if (out->where == IsFbRaster) {GXfunction = function; function = GXcopy;}*/
    if (!inWhere)
      {
	function &= 0x3333; function |= function << 2;
	height = out->height; fullWidth = out->width;
	shift = 0;
      }
    else
      {
        shift = out->bitOffset - in->bitOffset;
	fullWidth=out->width; if (in->width < fullWidth) fullWidth=in->width;
	height = out->height; if (in->height < height) height = in->height;
	if (height <= 0) return out;
        inSkip = inSkip2 = (in->stride - height) << 1;
      }
    outp = (char *)out->start;
    outSkip = (out->stride - height) << 1;
    fullWidth += out->bitOffset;
    code = CodeTable; /* start compiling */
    *code++ = 0x3A3C; *code++ = height - 1; /* movw #height-1,d5 */
    loopTopPc = code;	/* top of inner loop */
    if (!inWhere)
	compileW(" moveq #0,d1")
    else if (inWhere == IsFbRaster)
      {
/*printf("From FB. x;%d,y%d,h:%d,w:%d.", GenToFbRaster(in)->x, GenToFbRaster(in)->y, in->height, in->width); Flush(stdout);*/
	compileW(" movw d1,a1@");	/* touch x */
	compileW(" movw a0@+,d1");	/* start pipeline */
	inSkip = height; inSkip++; /* compensate for above step */
	inSkip <<= 1; inSkip = -inSkip;
	loopTopPc = code;
        compileW(" movw a0@+,d1");
	inp1 = (long *)(GenToFbRaster(in)->y  + (short *)(GXBase|GXsource|GXselectY));
	i = GenToFbRaster(in)->x - out->bitOffset;
	shift = 0;
	if (i >= 0) inp2 = (long *)(i + (short *)(GXBase|GXselectX));
	else
	  {
	    inp2 = (long *)(GenToFbRaster(in)->x + (short *)(GXBase|GXselectX));
	    /* compileW(" lsrw out->bitOffset,d1") */
	    /* fixup after first column */
	  }
	GXwidth = 16;
	inSkip2 = 32;
      }
    else
      {
        inp1 = (long*)in->start; 
	compileW(" movw a0@+,d1")
	if (shift)
	  {
	    if (shift < 0) shift &= 0xF;
	    else inp1 = (long *)((short *)inp1 - in->stride);
	    inp2 = (long *)((short *)inp1 + in->stride);
	    compileW(" swap d1"); compileW(" movw a1@+,d1");
	    compileW(" lsrl d3,d1");
          }
      }
    saveCode = code;
    columnCtr = fullWidth >> 4; /* # of cols, except right one */
    if (i = out->bitOffset)
      {
	/* in this case we must output special code for the leftmost column
	 * We save the "pc", so we can overwrite this code later */
	mask = 0xFFFF; mask >>= i;
/*printf("left,rem=%d.",columnCtr);*/
	if (!columnCtr)
	  {
	    mask &= (-1) << (16 - (fullWidth & 0xF));
	    columnCtr--; /* indicate that there is no middle OR right columns left */
	  }
	call(CompileFunction);	
	*code++ = 0x51CD; i = (char*)loopTopPc - (char*)code; *code++ = i; /* dbf d5,loopTopPc */
        compileW(" rts");
        call(CodeTable);
	i = inSkip; asm(" addw d7,a0"); i = inSkip2; asm(" addw d7,a1");
	outp += outSkip;
        code = saveCode;
	columnCtr--; /* we just did the left column */
      }
    if (columnCtr > 0)
      {
	mask = 0xFFFF;
	call(CompileFunction);
	*code++ = 0x51CD; i = (char*)loopTopPc  - (char*)code;
	     *code++ = i; /* dbf d5,loopTop */
	*code++ = 0xD0FC; *code++ = inSkip; /* addw #inSkip,a0 */
	*code++ = 0xD2FC; *code++ = inSkip2; /* addw #inSkip2,a1 */
	*code++ = 0xD6FC; *code++ = outSkip; /* addw #outSkip,a3 */
	*code++ = 0x51CE; i = (char*)CodeTable - (char*)code;
	    *code++ = i; /* dbf d6,loopTop */
	compileW(" rts");
	call(CodeTable);
      }
    else if (columnCtr < 0) return(out); /* left column = right column */
    if (i = fullWidth & 0xF)
      { /* compile code for masking right column */
        code = saveCode;
	mask = (-1) << (16 - i);
	call(CompileFunction);
	*code++ = 0x51CD; i = (char *)loopTopPc - (char *)code; *code++ = i; /* dbf d5,loopTopPc */
        compileW(" rts");
	call(CodeTable);
      }
    return out;

asm("CompileFunction:")
/* This pseodo-function compiles code into CodeTable (pointed to by 'code')
 * to apply the logical operation 'function', using 'd1' as the source.
 * The result is 'a3@+'.
 * 'mask' (d4) must be set at "compiletime" to zeroes in bits where
 * the destination should be unchanged.
 */
/*printf("Function:%x.",function);*/
    switch(function & 15)
      {
	case GXclear & 15: /* 0 */
	    mask = ~mask;
	    if (!mask) compileW(" movw d4,a3@+")
	    else compileW(" andw d4,a3@+")
	    break;
	case 0x1:
	    compileW(" notw d1");
	    /* ... then fall through to case 0x4 ... */
	/* case 0x2 is just before case 0x8 */
	/* case 0x3=copyInverted is just before case 0xC */
	case 0x4:
	    compileW(" orw a3@+,d1");
	    if (mask != 0xFFFF) compileW(" andw d4,d1");
	    compileW(" eorw d1,a3@+");
	    break;
	case GXinvert & 15: /* 5 */
	    compileW(" eorw d4,a3@+");
	    break;
	case 0x9:
	    compileW(" notw d1");
	    /* ... then fall through to ... */
	case GXxor & 15: /* 6 */
	    if (mask != 0xFFFF) compileW(" andw d4,d1");
	    compileW(" eorw d1,a3@+");
	    break;
	/* case 0x7 is just before case 0xD */
	case GXpaintInverted & 15: /* 2 */
	    compileW(" notw d1");
	    /* ... then fall through to ... */
	case GXand & 15: /* 8 */
	    if (mask != 0xFFFF) compileW(" andw d4,d1");
	    compileW(" andw d1,a3@+");
	    break;
	/* case 0x9 is just before case 0x6 */
	case GXnoop & 15: /* A */
	    return(out);
	/* case 0xB is just before case 0xE */
	case GXcopyInverted & 15: /* 0x3 */
	    compileW(" notw d1");
	    /* ... then fall through to ... */
	case GXcopy & 15: /* C */
	    if (mask != 0xFFFF)
	      {
	        compileW(" movw a3@,d0");
	        compileW(" eorw d0,d1");
	        compileW(" andw d4,d1");
	        compileW(" eorw d0,d1");
	      }
	    compileW(" movw d1,a3@+");
	    break;
	case 0x7:
	    compileW(" notw d1");
	    /* ... fall through to ... */
	case 0xD:
	    compileW(" andw a3@,d1");
	    compileW(" notw d1");
	    if (mask != 0xFFFF) compileW(" andw d4,d1");
	    compileW(" eorw d1,a3@+");
	    break;
	case 0xB:
	    compileW(" notw d1");
	    /* ... fall through to ... */
	case GXpaint & 15: /* E */
	    if (mask != 0xFFFF) compileW(" andw d4,d1");
	    compileW(" orw d1,a3@+");
	    break;
	case GXset & 15: /* F */
	    if (mask != 0xFFFF) compileW(" orw d4,a3@+")
	    else compileW(" movw d4,a3@+");
	    break;
      }
    rts;
  }


/* InvertSource is used to transform an input GXfunction code (in regsiter d1)
 * to an output code (returned in d1) which corresponds to inverting the source
 * operand before applying the function code.
 * Uses d1 as a temporary.
 * The algorithm: d0 = d0 BITS[2,3,0,1,6,7,4,5,10,11,8,9,14,15,12,13]
 */
InvertSource()
  {
    asm(" movw d0,d1"); 
    asm(" lsrw #2,d1");
    asm(" lslw #2,d0");
    asm(" eorw d1,d0");
    asm(" andw #/CCCC,d0");
    asm(" eorw d1,d0");
  }
/* The same but for 'inverting' the destination: swap each bit in a pair of
 * bits (to simulate inverting the destination as input), and then take the
 * one's complement (to simulate inverting the output).
 */
InvertDest()
  {
    asm(" movw d0,d1");
    asm(" lsrw #1,d1");
    asm(" lslw #1,d0");
    asm(" eorw d1,d0");
    asm(" andw #/AAAA,d0");
    asm(" eorw d1,d0");
    asm(" notw d0");
  }
